/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.jar.Attributes;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TColumnDesc;
import org.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import org.apache.hive.service.rpc.thrift.TGetCatalogsResp;
import org.apache.hive.service.rpc.thrift.TGetColumnsReq;
import org.apache.hive.service.rpc.thrift.TGetColumnsResp;
import org.apache.hive.service.rpc.thrift.TGetCrossReferenceReq;
import org.apache.hive.service.rpc.thrift.TGetCrossReferenceResp;
import org.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import org.apache.hive.service.rpc.thrift.TGetFunctionsResp;
import org.apache.hive.service.rpc.thrift.TGetInfoReq;
import org.apache.hive.service.rpc.thrift.TGetInfoResp;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetPrimaryKeysReq;
import org.apache.hive.service.rpc.thrift.TGetPrimaryKeysResp;
import org.apache.hive.service.rpc.thrift.TGetSchemasReq;
import org.apache.hive.service.rpc.thrift.TGetSchemasResp;
import org.apache.hive.service.rpc.thrift.TGetTableTypesReq;
import org.apache.hive.service.rpc.thrift.TGetTableTypesResp;
import org.apache.hive.service.rpc.thrift.TGetTablesReq;
import org.apache.hive.service.rpc.thrift.TGetTablesResp;
import org.apache.hive.service.rpc.thrift.TGetTypeInfoReq;
import org.apache.hive.service.rpc.thrift.TGetTypeInfoResp;
import org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.rpc.thrift.TTypeDesc;
import org.apache.hive.service.rpc.thrift.TTypeEntry;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.jdbc.KyuubiHiveDriver;
import org.apache.kyuubi.jdbc.hive.JdbcColumn;
import org.apache.kyuubi.jdbc.hive.JdbcTable;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;
import org.apache.kyuubi.jdbc.hive.KyuubiMetaDataResultSet;
import org.apache.kyuubi.jdbc.hive.KyuubiQueryResultSet;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.jdbc.hive.adapter.SQLDatabaseMetaData;
import org.apache.thrift.TException;

public class KyuubiDatabaseMetaData
implements SQLDatabaseMetaData {
    private final KyuubiConnection connection;
    private final TCLIService.Iface client;
    private final TSessionHandle sessHandle;
    private static final String CATALOG_SEPARATOR = ".";
    private static final char SEARCH_STRING_ESCAPE = '\\';
    private static final int maxColumnNameLength = 128;
    private String dbVersion = null;

    public KyuubiDatabaseMetaData(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle) {
        this.connection = connection;
        this.client = client;
        this.sessHandle = sessHandle;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return CATALOG_SEPARATOR;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "catalog";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        TGetCatalogsResp catalogResp;
        try {
            catalogResp = this.client.GetCatalogs(new TGetCatalogsReq(this.sessHandle));
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(catalogResp.getStatus());
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(catalogResp.getOperationHandle()).build();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new ClientInfoPropertiesResultSet();
    }

    private String convertPattern(String pattern) {
        if (pattern == null) {
            return ".*";
        }
        StringBuilder result = new StringBuilder(pattern.length());
        boolean escaped = false;
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (escaped) {
                if (c != '\\') {
                    escaped = false;
                }
                result.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '%') {
                result.append(".*");
                continue;
            }
            if (c == '_') {
                result.append('.');
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        TGetColumnsResp colResp;
        TGetColumnsReq colReq = new TGetColumnsReq();
        colReq.setSessionHandle(this.sessHandle);
        colReq.setCatalogName(catalog);
        colReq.setSchemaName(schemaPattern);
        colReq.setTableName(tableNamePattern);
        colReq.setColumnName(columnNamePattern);
        try {
            colResp = this.client.GetColumns(colReq);
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(colResp.getStatus());
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(colResp.getOperationHandle()).build();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        TGetCrossReferenceResp getFKResp;
        TGetCrossReferenceReq getFKReq = new TGetCrossReferenceReq(this.sessHandle);
        getFKReq.setParentTableName(primaryTable);
        getFKReq.setParentSchemaName(primarySchema);
        getFKReq.setParentCatalogName(primaryCatalog);
        getFKReq.setForeignTableName(foreignTable);
        getFKReq.setForeignSchemaName(foreignSchema);
        getFKReq.setForeignCatalogName(foreignCatalog);
        try {
            getFKResp = this.client.GetCrossReference(getFKReq);
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(getFKResp.getStatus());
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(getFKResp.getOperationHandle()).build();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Utils.getVersionPart(this.getDatabaseProductVersion(), 0);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Utils.getVersionPart(this.getDatabaseProductVersion(), 1);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        TGetInfoResp resp = this.getServerInfo(TGetInfoType.CLI_DBMS_NAME);
        return resp.getInfoValue().getStringValue();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.dbVersion != null) {
            return this.dbVersion;
        }
        TGetInfoResp resp = this.getServerInfo(TGetInfoType.CLI_DBMS_VER);
        this.dbVersion = resp.getInfoValue().getStringValue();
        return this.dbVersion;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return KyuubiHiveDriver.getMajorDriverVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return KyuubiHiveDriver.getMinorDriverVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return KyuubiHiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return KyuubiHiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getFunctions(String catalogName, String schemaPattern, String functionNamePattern) throws SQLException {
        TGetFunctionsResp funcResp;
        TGetFunctionsReq getFunctionsReq = new TGetFunctionsReq();
        getFunctionsReq.setSessionHandle(this.sessHandle);
        getFunctionsReq.setCatalogName(catalogName);
        getFunctionsReq.setSchemaName(schemaPattern);
        getFunctionsReq.setFunctionName(functionNamePattern);
        try {
            funcResp = this.client.GetFunctions(getFunctionsReq);
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(funcResp.getStatus());
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(funcResp.getOperationHandle()).build();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"), Arrays.asList(TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE)).build();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"), Arrays.asList(TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.BOOLEAN_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.INT_TYPE, TTypeId.INT_TYPE, TTypeId.STRING_TYPE)).build();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        TGetPrimaryKeysResp getPKResp;
        TGetPrimaryKeysReq getPKReq = new TGetPrimaryKeysReq(this.sessHandle);
        getPKReq.setTableName(table);
        getPKReq.setSchemaName(schema);
        getPKReq.setCatalogName(catalog);
        try {
            getPKResp = this.client.GetPrimaryKeys(getPKReq);
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(getPKResp.getStatus());
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(getPKResp.getOperationHandle()).build();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"), Arrays.asList(TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.INT_TYPE, TTypeId.STRING_TYPE, TTypeId.INT_TYPE, TTypeId.INT_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.SMALLINT_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.INT_TYPE, TTypeId.INT_TYPE, TTypeId.INT_TYPE, TTypeId.INT_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE)).build();
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return new String("UDF");
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setEmptyResultSet(true).setSchema(Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "RESERVERD", "RESERVERD", "RESERVERD", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"), Arrays.asList(TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE)).build();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        TGetInfoResp resp = this.getServerInfo(TGetInfoType.CLI_ODBC_KEYWORDS);
        return resp.getInfoValue().getStringValue();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "database";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        TGetSchemasResp schemaResp;
        TGetSchemasReq schemaReq = new TGetSchemasReq();
        schemaReq.setSessionHandle(this.sessHandle);
        if (catalog != null) {
            schemaReq.setCatalogName(catalog);
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        schemaReq.setSchemaName(schemaPattern);
        try {
            schemaResp = this.client.GetSchemas(schemaReq);
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(schemaResp.getStatus());
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(schemaResp.getOperationHandle()).build();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return String.valueOf('\\');
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        TGetTableTypesResp tableTypeResp;
        try {
            tableTypeResp = this.client.GetTableTypes(new TGetTableTypesReq(this.sessHandle));
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(tableTypeResp.getStatus());
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(tableTypeResp.getOperationHandle()).build();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        TGetTablesResp getTableResp;
        TGetTablesReq getTableReq = new TGetTablesReq(this.sessHandle);
        getTableReq.setCatalogName(catalog);
        getTableReq.setSchemaName(schemaPattern == null ? "%" : schemaPattern);
        getTableReq.setTableName(tableNamePattern);
        if (types != null) {
            getTableReq.setTableTypes(Arrays.asList(types));
        }
        try {
            getTableResp = this.client.GetTables(getTableReq);
        }
        catch (TException rethrow) {
            throw new KyuubiSQLException(rethrow.getMessage(), "08S01", rethrow);
        }
        TStatus tStatus = getTableResp.getStatus();
        if (tStatus.getStatusCode() != TStatusCode.SUCCESS_STATUS) {
            throw new KyuubiSQLException(tStatus);
        }
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(getTableResp.getOperationHandle()).build();
    }

    public static String toJdbcTableType(String hivetabletype) {
        if (hivetabletype == null) {
            return null;
        }
        if (hivetabletype.equals("MANAGED_TABLE")) {
            return "TABLE";
        }
        if (hivetabletype.equals("VIRTUAL_VIEW")) {
            return "VIEW";
        }
        if (hivetabletype.equals("EXTERNAL_TABLE")) {
            return "EXTERNAL TABLE";
        }
        if (hivetabletype.equals("MATERIALIZED_VIEW")) {
            return "MATERIALIZED VIEW";
        }
        return hivetabletype;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        TGetTypeInfoResp getTypeInfoResp;
        TGetTypeInfoReq getTypeInfoReq = new TGetTypeInfoReq();
        getTypeInfoReq.setSessionHandle(this.sessHandle);
        try {
            getTypeInfoResp = this.client.GetTypeInfo(getTypeInfoReq);
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(getTypeInfoResp.getStatus());
        return new KyuubiQueryResultSet.Builder(this.connection).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(getTypeInfoResp.getOperationHandle()).build();
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new KyuubiMetaDataResultSet<Object>(Arrays.asList("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"), Arrays.asList(TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE, TTypeId.INT_TYPE, TTypeId.STRING_TYPE, TTypeId.INT_TYPE), null){

            @Override
            public boolean next() throws SQLException {
                return false;
            }
        };
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    private TGetInfoResp getServerInfo(TGetInfoType type) throws SQLException {
        TGetInfoResp resp;
        TGetInfoReq req = new TGetInfoReq(this.sessHandle, type);
        try {
            resp = this.client.GetInfo(req);
        }
        catch (TException e) {
            throw new KyuubiSQLException(e.getMessage(), "08S01", e);
        }
        Utils.verifySuccess(resp.getStatus());
        return resp;
    }

    private class GetTablesComparator
    implements Comparator<JdbcTable> {
        private GetTablesComparator() {
        }

        @Override
        public int compare(JdbcTable o1, JdbcTable o2) {
            int compareType = o1.getType().compareTo(o2.getType());
            if (compareType == 0) {
                return o1.getTableName().compareTo(o2.getTableName());
            }
            return compareType;
        }
    }

    private class GetColumnsComparator
    implements Comparator<JdbcColumn> {
        private GetColumnsComparator() {
        }

        @Override
        public int compare(JdbcColumn o1, JdbcColumn o2) {
            int compareName = o1.getTableName().compareTo(o2.getTableName());
            if (compareName == 0) {
                if (o1.getOrdinalPos() > o2.getOrdinalPos()) {
                    return 1;
                }
                if (o1.getOrdinalPos() < o2.getOrdinalPos()) {
                    return -1;
                }
                return 0;
            }
            return compareName;
        }
    }

    private static final class ClientInfoPropertiesResultSet
    extends KyuubiMetaDataResultSet<Object> {
        private static final String[] COLUMNS = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};
        private static final TTypeId[] COLUMN_TYPES = new TTypeId[]{TTypeId.STRING_TYPE, TTypeId.INT_TYPE, TTypeId.STRING_TYPE, TTypeId.STRING_TYPE};
        private static final Object[][] DATA = new Object[][]{{"ApplicationName", 1000, null, null}};
        private int index = -1;

        public ClientInfoPropertiesResultSet() throws SQLException {
            super(Arrays.asList(COLUMNS), Arrays.asList(COLUMN_TYPES), null);
            ArrayList<TColumnDesc> fieldSchemas = new ArrayList<TColumnDesc>(COLUMNS.length);
            for (int i = 0; i < COLUMNS.length; ++i) {
                TColumnDesc tColumnDesc = new TColumnDesc();
                tColumnDesc.setColumnName(COLUMNS[i]);
                TTypeDesc tTypeDesc = new TTypeDesc();
                tTypeDesc.addToTypes(TTypeEntry.primitiveEntry((TPrimitiveTypeEntry)new TPrimitiveTypeEntry(COLUMN_TYPES[i])));
                tColumnDesc.setTypeDesc(tTypeDesc);
                tColumnDesc.setPosition(i);
                fieldSchemas.add(tColumnDesc);
            }
            this.setSchema(new TTableSchema(fieldSchemas));
        }

        @Override
        public boolean next() throws SQLException {
            if (++this.index >= DATA.length) {
                return false;
            }
            this.row = Arrays.copyOf(DATA[this.index], DATA[this.index].length);
            return true;
        }

        @Override
        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            for (int i = 0; i < COLUMNS.length; ++i) {
                if (!COLUMNS[i].equalsIgnoreCase(columnLabel)) continue;
                return this.getObject(i, type);
            }
            throw new KyuubiSQLException("No column " + columnLabel);
        }

        @Override
        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            return (T)super.getObject(columnIndex);
        }
    }
}

