/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.plugin.PluginLoader$;
import org.apache.kyuubi.plugin.SessionConfAdvisor;
import org.apache.kyuubi.server.metadata.MetadataManager;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.session.KyuubiBatchSessionImpl;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.util.SignUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r=b\u0001B\u00193\u0001mB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u001d\u0002!Ia\u0014\u0005\u0006\u001d\u0002!\tA\u0015\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019q\u0006\u0001)A\u0005+\"9q\f\u0001b\u0001\n\u0003\u0001\u0007BB4\u0001A\u0003%\u0011\rC\u0004i\u0001\t\u0007I\u0011A5\t\rA\u0004\u0001\u0015!\u0003k\u0011\u001d\t\bA1A\u0005\u0002IDa!\u001f\u0001!\u0002\u0013\u0019\b\u0002\u0003>\u0001\u0011\u000b\u0007I\u0011B>\t\u0015\u0005=\u0001\u0001#b\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002 \u0001A)\u0019!C\u0001\u0003CA\u0011\"!\u000b\u0001\u0001\u0004%I!a\u000b\t\u0013\u0005U\u0002\u00011A\u0005\n\u0005]\u0002\u0002CA\"\u0001\u0001\u0006K!!\f\t\u0013\u0005\u0015\u0003\u00011A\u0005\n\u0005-\u0002\"CA$\u0001\u0001\u0007I\u0011BA%\u0011!\ti\u0005\u0001Q!\n\u00055\u0002\u0002DA!\u0001A\u0005\tr1Q\u0005\n\u0005=\u0003BCA7\u0001!\u0015\r\u0011\"\u0001\u0002p!Q\u0011\u0011\u000f\u0001\t\u0006\u0004%\t!a\u001d\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x!9\u0011\u0011\u0012\u0001\u0005R\u0005-\u0005bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\ty\u000e\u0001C\u0005\u0003CD\u0011B!\b\u0001#\u0003%IAa\b\t\u0011\tU\u0002\u0001\"\u00015\u0005oAqA!\u000e\u0001\t\u0003\u0011i\u0004C\u0004\u0003J\u0001!\tAa\u0013\t\u000f\t=\u0003\u0001\"\u0001\u0003R!9!Q\u000b\u0001\u0005\u0002\t]\u0003b\u0002B.\u0001\u0011\u0005!Q\f\u0005\b\u0005W\u0002A\u0011\u0001B7\u0011\u001d\u0011\t\b\u0001C\u0001\u0005gBqAa \u0001\t\u0003\u0011\t\tC\u0004\u0003>\u0002!\tAa0\t\u000f\t\r\u0007\u0001\"\u0001\u0003F\"9!1\u001d\u0001\u0005B\t\u0015\bb\u0002Bt\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005c\u0004A\u0011\u0001Bz\u0011\u001d\u0011I\u0010\u0001C)\u0005wDqaa\u0001\u0001\t\u0013\u0019)\u0001\u0003\u0005\u0004\n\u0001!\t\u0001NB\u0006\u0011!\u0019\u0019\u0002\u0001C\u0001i\rU\u0001bBB\r\u0001\u0011%11\u0004\u0002\u0015\u0017f,XOY5TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005M\"\u0014aB:fgNLwN\u001c\u0006\u0003kY\naa[=vk\nL'BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001yA\u0011QHP\u0007\u0002e%\u0011qH\r\u0002\u000f'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0003\u0011q\u0017-\\3\u0011\u0005\t[eBA\"J!\t!u)D\u0001F\u0015\t1%(\u0001\u0004=e>|GO\u0010\u0006\u0002\u0011\u0006)1oY1mC&\u0011!jR\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002K\u000f\u00061A(\u001b8jiz\"\"\u0001U)\u0011\u0005u\u0002\u0001\"\u0002!\u0003\u0001\u0004\tE#\u0001)\u0002\rA\f'o]3s+\u0005)\u0006C\u0001,]\u001b\u00059&B\u0001-Z\u0003\u0019\u0019XM\u001d<fe*\u00111K\u0017\u0006\u00037R\n1a]9m\u0013\tivK\u0001\u0007LsV,(-\u001b)beN,'/A\u0004qCJ\u001cXM\u001d\u0011\u0002!=\u0004XM]1uS>tW*\u00198bO\u0016\u0014X#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011$\u0014!C8qKJ\fG/[8o\u0013\t17M\u0001\fLsV,(-[(qKJ\fG/[8o\u001b\u0006t\u0017mZ3s\u0003Ey\u0007/\u001a:bi&|g.T1oC\u001e,'\u000fI\u0001\u0013GJ,G-\u001a8uS\u0006d7/T1oC\u001e,'/F\u0001k!\tYg.D\u0001m\u0015\tiG'A\u0006de\u0016$WM\u001c;jC2\u001c\u0018BA8m\u0005aA\u0015\rZ8pa\u000e\u0013X\rZ3oi&\fGn]'b]\u0006<WM]\u0001\u0014GJ,G-\u001a8uS\u0006d7/T1oC\u001e,'\u000fI\u0001\u0013CB\u0004H.[2bi&|g.T1oC\u001e,'/F\u0001t!\t!x/D\u0001v\u0015\t1H'\u0001\u0004f]\u001eLg.Z\u0005\u0003qV\u0014\u0001dS=vk\nL\u0017\t\u001d9mS\u000e\fG/[8o\u001b\u0006t\u0017mZ3s\u0003M\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8NC:\fw-\u001a:!\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014X#\u0001?\u0011\tut\u0018\u0011A\u0007\u0002\u000f&\u0011qp\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\u00111B\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002Yi%!\u0011QBA\u0003\u0005=iU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018AE:fgNLwN\\\"p]\u001a\fEM^5t_J,\"!a\u0005\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u00075\u0003\u0019\u0001H.^4j]&!\u0011QDA\f\u0005I\u0019Vm]:j_:\u001cuN\u001c4BIZL7o\u001c:\u0002\u001b\u001d\u0014x.\u001e9Qe>4\u0018\u000eZ3s+\t\t\u0019\u0003\u0005\u0003\u0002\u0016\u0005\u0015\u0012\u0002BA\u0014\u0003/\u0011Qb\u0012:pkB\u0004&o\u001c<jI\u0016\u0014\u0018a\u00027j[&$XM]\u000b\u0003\u0003[\u0001B! @\u00020A\u0019Q(!\r\n\u0007\u0005M\"G\u0001\bTKN\u001c\u0018n\u001c8MS6LG/\u001a:\u0002\u00171LW.\u001b;fe~#S-\u001d\u000b\u0005\u0003s\ty\u0004E\u0002~\u0003wI1!!\u0010H\u0005\u0011)f.\u001b;\t\u0013\u0005\u0005\u0003#!AA\u0002\u00055\u0012a\u0001=%c\u0005AA.[7ji\u0016\u0014\b%\u0001\u0007cCR\u001c\u0007\u000eT5nSR,'/\u0001\tcCR\u001c\u0007\u000eT5nSR,'o\u0018\u0013fcR!\u0011\u0011HA&\u0011%\t\teEA\u0001\u0002\u0004\ti#A\u0007cCR\u001c\u0007\u000eT5nSR,'\u000fI\u000b\u0003\u0003#\u0002r!`A*\u0003/\n9'C\u0002\u0002V\u001d\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\tg\u0016\u001cWO]5us*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002f\u0005m#A\u0003)sSZ\fG/Z&fsB!\u0011\u0011LA5\u0013\u0011\tY'a\u0017\u0003\u0013A+(\r\\5d\u0017\u0016L\u0018!E:jO:Lgn\u001a)sSZ\fG/Z&fsV\u0011\u0011qK\u0001\u0011g&<g.\u001b8h!V\u0014G.[2LKf,\"!a\u001a\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0003\u0002:\u0005e\u0004bBA>1\u0001\u0007\u0011QP\u0001\u0005G>tg\r\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019\tN\u0001\u0007G>tg-[4\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u000b\u0017f,XOY5D_:4\u0017!D2sK\u0006$XmU3tg&|g\u000e\u0006\u0007\u0002\u000e\u0006M\u0015qVAZ\u0003o\u000bY\fE\u0002>\u0003\u001fK1!!%3\u0005\u001d\u0019Vm]:j_:Dq!!&\u001a\u0001\u0004\t9*\u0001\u0005qe>$xnY8m!\u0011\tI*a+\u000e\u0005\u0005m%\u0002BAO\u0003?\u000ba\u0001\u001e5sS\u001a$(\u0002BAQ\u0003G\u000b1A\u001d9d\u0015\u0011\t)+a*\u0002\u000fM,'O^5dK*\u0019\u0011\u0011\u0016\u001c\u0002\t!Lg/Z\u0005\u0005\u0003[\u000bYJ\u0001\tU!J|Go\\2pYZ+'o]5p]\"1\u0011\u0011W\rA\u0002\u0005\u000bA!^:fe\"1\u0011QW\rA\u0002\u0005\u000b\u0001\u0002]1tg^|'\u000f\u001a\u0005\u0007\u0003sK\u0002\u0019A!\u0002\u0013%\u0004\u0018\t\u001a3sKN\u001c\bbBA>3\u0001\u0007\u0011Q\u0018\t\u0006\u0005\u0006}\u0016)Q\u0005\u0004\u0003\u0003l%aA'ba\u0006Yq\u000e]3o'\u0016\u001c8/[8o)1\t9-!4\u0002P\u0006E\u00171[Ak!\ri\u0014\u0011Z\u0005\u0004\u0003\u0017\u0014$!D*fgNLwN\u001c%b]\u0012dW\rC\u0004\u0002\u0016j\u0001\r!a&\t\r\u0005E&\u00041\u0001B\u0011\u0019\t)L\u0007a\u0001\u0003\"1\u0011\u0011\u0018\u000eA\u0002\u0005Cq!a\u001f\u001b\u0001\u0004\ti,\u0001\u0007dY>\u001cXmU3tg&|g\u000e\u0006\u0003\u0002:\u0005m\u0007bBAo7\u0001\u0007\u0011qY\u0001\u000eg\u0016\u001c8/[8o\u0011\u0006tG\r\\3\u0002%\r\u0014X-\u0019;f\u0005\u0006$8\r[*fgNLwN\u001c\u000b\u000f\u0003G\fI/a;\u0002n\u0006=\u0018\u0011\u001fB\u0007!\ri\u0014Q]\u0005\u0004\u0003O\u0014$AF&zkV\u0014\u0017NQ1uG\"\u001cVm]:j_:LU\u000e\u001d7\t\r\u0005EF\u00041\u0001B\u0011\u0019\t)\f\ba\u0001\u0003\"1\u0011\u0011\u0018\u000fA\u0002\u0005Cq!a\u001f\u001d\u0001\u0004\ti\fC\u0004\u0002tr\u0001\r!!>\u0002\u0019\t\fGo\u00195SKF,Xm\u001d;\u0011\t\u0005](\u0011B\u0007\u0003\u0003sTA!a?\u0002~\u0006\u0019A\r^8\u000b\t\u0005}(\u0011A\u0001\u0003mFRAAa\u0001\u0003\u0006\u0005\u0019\u0011\r]5\u000b\u0007\t\u001dA'\u0001\u0004dY&,g\u000e^\u0005\u0005\u0005\u0017\tIP\u0001\u0007CCR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0005\u0003\u0010q\u0001\n\u00111\u0001\u0003\u0012\u0005\u0001\"/Z2pm\u0016\u0014\u00180T3uC\u0012\fG/\u0019\t\u0005{z\u0014\u0019\u0002\u0005\u0003\u0003\u0016\teQB\u0001B\f\u0015\u0011\u0011\u0019!!\u0002\n\t\tm!q\u0003\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006a2M]3bi\u0016\u0014\u0015\r^2i'\u0016\u001c8/[8oI\u0011,g-Y;mi\u00122TC\u0001B\u0011U\u0011\u0011\tBa\t,\u0005\t\u0015\u0002\u0003\u0002B\u0014\u0005ci!A!\u000b\u000b\t\t-\"QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\fH\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005g\u0011ICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001c\u001c9f]\n\u000bGo\u00195TKN\u001c\u0018n\u001c8\u0015\t\u0005\u001d'\u0011\b\u0005\b\u0005wq\u0002\u0019AAr\u00031\u0011\u0017\r^2i'\u0016\u001c8/[8o)1\t9Ma\u0010\u0003B\t\r#Q\tB$\u0011\u0019\t\tl\ba\u0001\u0003\"1\u0011QW\u0010A\u0002\u0005Ca!!/ \u0001\u0004\t\u0005bBA>?\u0001\u0007\u0011Q\u0018\u0005\b\u0003g|\u0002\u0019AA{\u0003M9W\r\u001e\"bi\u000eD7+Z:tS>t\u0017*\u001c9m)\u0011\t\u0019O!\u0014\t\u000f\u0005u\u0007\u00051\u0001\u0002H\u0006q\u0011N\\:feRlU\r^1eCR\fG\u0003BA\u001d\u0005'Bq!a\u0002\"\u0001\u0004\u0011\u0019\"\u0001\bva\u0012\fG/Z'fi\u0006$\u0017\r^1\u0015\t\u0005e\"\u0011\f\u0005\b\u0003\u000f\u0011\u0003\u0019\u0001B\n\u0003m9W\r^'fi\u0006$\u0017\r^1SKF,Xm\u001d;t%\u0016$(/\u001f*fMR!!q\fB4!\u0011ihP!\u0019\u0011\t\u0005\r!1M\u0005\u0005\u0005K\n)A\u0001\rNKR\fG-\u0019;b%\u0016\fX/Z:ugJ+GO]=SK\u001aDaA!\u001b$\u0001\u0004\t\u0015AC5eK:$\u0018NZ5fe\u0006\u0011C-\u001a*fO&\u001cH/\u001a:NKR\fG-\u0019;b%\u0016\fX/Z:ugJ+GO]=SK\u001a$B!!\u000f\u0003p!1!\u0011\u000e\u0013A\u0002\u0005\u000b\u0011dZ3u\u0005\u0006$8\r\u001b$s_6lU\r^1eCR\f7\u000b^8sKR!!Q\u000fB>!\u0011\t9Pa\u001e\n\t\te\u0014\u0011 \u0002\u0006\u0005\u0006$8\r\u001b\u0005\u0007\u0005{*\u0003\u0019A!\u0002\u000f\t\fGo\u00195JI\u0006Yr-\u001a;CCR\u001c\u0007.Z:Ge>lW*\u001a;bI\u0006$\u0018m\u0015;pe\u0016$\u0002Ca!\u0003\u0016\ne%Q\u0014BQ\u0005W\u0013yK!/\u0011\r\t\u0015%q\u0012B;\u001d\u0011\u00119Ia#\u000f\u0007\u0011\u0013I)C\u0001I\u0013\r\u0011iiR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tJa%\u0003\u0007M+\u0017OC\u0002\u0003\u000e\u001eCaAa&'\u0001\u0004\t\u0015!\u00032bi\u000eDG+\u001f9f\u0011\u0019\u0011YJ\na\u0001\u0003\u0006I!-\u0019;dQV\u001bXM\u001d\u0005\u0007\u0005?3\u0003\u0019A!\u0002\u0015\t\fGo\u00195Ti\u0006$X\rC\u0004\u0003$\u001a\u0002\rA!*\u0002\u0015\r\u0014X-\u0019;f)&lW\rE\u0002~\u0005OK1A!+H\u0005\u0011auN\\4\t\u000f\t5f\u00051\u0001\u0003&\u00069QM\u001c3US6,\u0007b\u0002BYM\u0001\u0007!1W\u0001\u0005MJ|W\u000eE\u0002~\u0005kK1Aa.H\u0005\rIe\u000e\u001e\u0005\b\u0005w3\u0003\u0019\u0001BZ\u0003\u0011\u0019\u0018N_3\u0002!\u001d,GOQ1uG\"lU\r^1eCR\fG\u0003\u0002B\n\u0005\u0003DaA! (\u0001\u0004\t\u0015aD2mK\u0006tW\u000f]'fi\u0006$\u0017\r^1\u0015\t\u0005e\"q\u0019\u0005\u0007\u0005SB\u0003\u0019A!)\u0007!\u0012Y\r\u0005\u0003\u0003N\n}WB\u0001Bh\u0015\u0011\u0011\tNa5\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0005+\u00149.\u0001\u0004d_6lwN\u001c\u0006\u0005\u00053\u0014Y.\u0001\u0004h_><G.\u001a\u0006\u0003\u0005;\f1aY8n\u0013\u0011\u0011\tOa4\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw-A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002:\u0005Ir-\u001a;CCR\u001c\u0007nU3tg&|gn\u001d+p%\u0016\u001cwN^3s)\u0011\u0011YO!<\u0011\r\t\u0015%qRAr\u0011\u0019\u0011yO\u000ba\u0001\u0003\u0006q1._;vE&Len\u001d;b]\u000e,\u0017AI4fiB+WM]%ogR\fgnY3DY>\u001cX\r\u001a\"bi\u000eD7+Z:tS>t7\u000f\u0006\u0003\u0003v\n]\bC\u0002BC\u0005\u001f\u0013\u0019\u0002\u0003\u0004\u0003p.\u0002\r!Q\u0001\tSN\u001cVM\u001d<feV\u0011!Q \t\u0004{\n}\u0018bAB\u0001\u000f\n9!i\\8mK\u0006t\u0017AE5oSR\u001cVm]:j_:d\u0015.\\5uKJ$B!!\u000f\u0004\b!9\u00111P\u0017A\u0002\u0005u\u0014!E4fiVsG.[7ji\u0016$Wk]3sgR\u00111Q\u0002\t\u0005\u0005\u000e=\u0011)C\u0002\u0004\u00125\u00131aU3u\u0003U\u0011XM\u001a:fg\",f\u000e\\5nSR,G-V:feN$B!!\u000f\u0004\u0018!9\u00111P\u0018A\u0002\u0005u\u0014aE1qa2L8+Z:tS>tG*[7ji\u0016\u0014HCCA\u0017\u0007;\u0019\tc!\n\u0004*!91q\u0004\u0019A\u0002\tM\u0016!C;tKJd\u0015.\\5u\u0011\u001d\u0019\u0019\u0003\ra\u0001\u0005g\u000ba\"\u001b9BI\u0012\u0014Xm]:MS6LG\u000fC\u0004\u0004(A\u0002\rAa-\u0002%U\u001cXM]%q\u0003\u0012$'/Z:t\u0019&l\u0017\u000e\u001e\u0005\b\u0007W\u0001\u0004\u0019AB\u0017\u0003E)8/\u001a:V]2LW.\u001b;fI2K7\u000f\u001e\t\u0006\u0005\u000b\u0013y)\u0011")
public class KyuubiSessionManager
extends SessionManager {
    private Option<MetadataManager> metadataManager;
    private SessionConfAdvisor sessionConfAdvisor;
    private GroupProvider groupProvider;
    private Tuple2<PrivateKey, PublicKey> x$1;
    private PrivateKey signingPrivateKey;
    private PublicKey signingPublicKey;
    private final KyuubiParser parser = new KyuubiParser();
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();
    private final KyuubiApplicationManager applicationManager = new KyuubiApplicationManager();
    private Option<SessionLimiter> limiter = None$.MODULE$;
    private Option<SessionLimiter> batchLimiter = None$.MODULE$;
    private volatile byte bitmap$0;

    private KyuubiParser parser() {
        return this.parser;
    }

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    private Option<MetadataManager> metadataManager$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataManager = ((SeqLike)((TraversableLike)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_PROTOCOLS())).map((Function1 & Serializable & scala.Serializable)s -> KyuubiConf.FrontendProtocols$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom())).contains((Object)KyuubiConf.FrontendProtocols$.MODULE$.REST()) ? Option$.MODULE$.apply((Object)new MetadataManager()) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataManager;
    }

    private Option<MetadataManager> metadataManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metadataManager$lzycompute();
        }
        return this.metadataManager;
    }

    private SessionConfAdvisor sessionConfAdvisor$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sessionConfAdvisor = PluginLoader$.MODULE$.loadSessionConfAdvisor(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sessionConfAdvisor;
    }

    public SessionConfAdvisor sessionConfAdvisor() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sessionConfAdvisor$lzycompute();
        }
        return this.sessionConfAdvisor;
    }

    private GroupProvider groupProvider$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.groupProvider = PluginLoader$.MODULE$.loadGroupProvider(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.groupProvider;
    }

    public GroupProvider groupProvider() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.groupProvider$lzycompute();
        }
        return this.groupProvider;
    }

    private Option<SessionLimiter> limiter() {
        return this.limiter;
    }

    private void limiter_$eq(Option<SessionLimiter> x$1) {
        this.limiter = x$1;
    }

    private Option<SessionLimiter> batchLimiter() {
        return this.batchLimiter;
    }

    private void batchLimiter_$eq(Option<SessionLimiter> x$1) {
        this.batchLimiter = x$1;
    }

    private Tuple2<PrivateKey, PublicKey> x$1$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Tuple2 tuple2 = SignUtils$.MODULE$.generateKeyPair(SignUtils$.MODULE$.generateKeyPair$default$1());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PrivateKey signingPrivateKey = (PrivateKey)tuple2._1();
                PublicKey signingPublicKey = (PublicKey)tuple2._2();
                this.x$1 = new Tuple2((Object)signingPrivateKey, (Object)signingPublicKey);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private PrivateKey signingPrivateKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.signingPrivateKey = (PrivateKey)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.signingPrivateKey;
    }

    public PrivateKey signingPrivateKey() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.signingPrivateKey$lzycompute();
        }
        return this.signingPrivateKey;
    }

    private PublicKey signingPublicKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.signingPublicKey = (PublicKey)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.signingPublicKey;
    }

    public PublicKey signingPublicKey() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.signingPublicKey$lzycompute();
        }
        return this.signingPublicKey;
    }

    public void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService((Service)this.applicationManager());
        this.addService((Service)this.credentialsManager());
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        this.initSessionLimiter(conf);
        super.initialize(conf);
    }

    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf) {
        return new KyuubiSessionImpl(protocol, user, password, ipAddress, conf, this, this.getConf().getUserDefaults(user), this.parser());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.increment(new UserIpAddress(username, ipAddress));
            return BoxedUnit.UNIT;
        });
        try {
            sessionHandle = super.openSession(protocol, username, password, ipAddress, conf);
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.getSession(sessionHandle);
        try {
            super.closeSession(sessionHandle);
        }
        finally {
            Session session2 = session;
            if (session2 instanceof KyuubiBatchSessionImpl) {
                this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private KyuubiBatchSessionImpl createBatchSession(String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, BatchRequest batchRequest, Option<Metadata> recoveryMetadata) {
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$createBatchSession$1(x$6))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        return new KyuubiBatchSessionImpl(username, password, ipAddress, conf, this, this.getConf().getUserDefaults(user), batchRequest, recoveryMetadata);
    }

    private Option<Metadata> createBatchSession$default$6() {
        return None$.MODULE$;
    }

    public SessionHandle openBatchSession(KyuubiBatchSessionImpl batchSession) {
        SessionHandle sessionHandle;
        String user = batchSession.user();
        String ipAddress = batchSession.ipAddress();
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.increment(new UserIpAddress(user, ipAddress));
            return BoxedUnit.UNIT;
        });
        SessionHandle handle = batchSession.handle();
        try {
            this.setSession(handle, (Session)batchSession);
            batchSession.open();
            this.logSessionCountInfo((Session)batchSession, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                this.closeSession(handle);
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Error closing batch session[").append(handle).append("] for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openBatchSession$3(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(54).append("Error opening batch session[").append(handle).append("] for ").append(user).append(" client ip ").append(ipAddress).append(",").append(" due to ").append(e.getMessage()).toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public SessionHandle openBatchSession(String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, BatchRequest batchRequest) {
        KyuubiBatchSessionImpl batchSession = this.createBatchSession(user, password, ipAddress, conf, batchRequest, this.createBatchSession$default$6());
        return this.openBatchSession(batchSession);
    }

    public KyuubiBatchSessionImpl getBatchSessionImpl(SessionHandle sessionHandle) {
        return (KyuubiBatchSessionImpl)((Object)this.getSessionOption(sessionHandle).map((Function1 & Serializable & scala.Serializable)x$8 -> (KyuubiBatchSessionImpl)((Object)x$8)).orNull(Predef$.MODULE$.$conforms()));
    }

    public void insertMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.insertMetadata(metadata, x$9.insertMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void updateMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.updateMetadata(metadata, x$10.updateMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public Option<MetadataRequestsRetryRef> getMetadataRequestsRetryRef(String identifier) {
        return Option$.MODULE$.apply(this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.getMetadataRequestsRetryRef(identifier)).orNull(Predef$.MODULE$.$conforms()));
    }

    public void deRegisterMetadataRequestsRetryRef(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.deRegisterRequestsRetryRef(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public Batch getBatchFromMetadataStore(String batchId) {
        return (Batch)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.getBatch(batchId)).orNull(Predef$.MODULE$.$conforms());
    }

    public Seq<Batch> getBatchesFromMetadataStore(String batchType, String batchUser, String batchState, long createTime, long endTime, int from, int size) {
        return (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.getBatches(batchType, batchUser, batchState, createTime, endTime, from, size)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public Metadata getBatchMetadata(String batchId) {
        return (Metadata)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getBatchSessionMetadata(batchId)).orNull(Predef$.MODULE$.$conforms());
    }

    @VisibleForTesting
    public void cleanupMetadata(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            x$16.cleanupMetadataById(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
    }

    public Seq<KyuubiBatchSessionImpl> getBatchSessionsToRecover(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$17 -> (Seq)x$17.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> {
            BatchRequest batchRequest = new BatchRequest(metadata.engineType(), metadata.resource(), metadata.className(), metadata.requestName(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(metadata.requestConf()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(metadata.requestArgs()).asJava());
            return this.createBatchSession(metadata.username(), "anonymous", metadata.ipAddress(), metadata.requestConf(), batchRequest, (Option<Metadata>)new Some(metadata));
        }, Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Metadata> getPeerInstanceClosedBatchSessions(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToKill -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.getPeerInstanceClosedBatchesMetadata(stateToKill.toString(), kyuubiInstance, 0, Integer.MAX_VALUE)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isServer() {
        return true;
    }

    private void initSessionLimiter(KyuubiConf conf) {
        int userLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Seq userUnlimitedList = (Seq)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST());
        this.limiter_$eq(this.applySessionLimiter(userLimit, ipAddressLimit, userIpAddressLimit, (Seq<String>)userUnlimitedList));
        int userBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.batchLimiter_$eq(this.applySessionLimiter(userBatchLimit, ipAddressBatchLimit, userIpAddressBatchLimit, (Seq<String>)userUnlimitedList));
    }

    public Set<String> getUnlimitedUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getUnlimitedUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshUnlimitedUsers(KyuubiConf conf) {
        Set unlimitedUsers = ((TraversableOnce)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).toSet();
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$19, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$20 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$20, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
    }

    private Option<SessionLimiter> applySessionLimiter(int userLimit, int ipAddressLimit, int userIpAddressLimit, Seq<String> userUnlimitedList) {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{userLimit, ipAddressLimit, userIpAddressLimit}))).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$21 -> x$21 > 0).map((Function1 & Serializable & scala.Serializable)x$22 -> SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, (Set<String>)userUnlimitedList.toSet()));
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.INTERACTIVE().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$createBatchSession$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openBatchSession$3(String user$2, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$2}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.BATCH().toString()}));
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getOpenSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    private KyuubiSessionManager(String name) {
        super(name);
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

