/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.curator.framework.imps;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.shade.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.kyuubi.shade.org.apache.curator.framework.imps.NamespaceFacade;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.cache.CacheBuilder;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.cache.CacheLoader;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.cache.LoadingCache;

class NamespaceFacadeCache {
    private final CuratorFrameworkImpl client;
    private final NamespaceFacade nullNamespace;
    private final CacheLoader<String, NamespaceFacade> loader = new CacheLoader<String, NamespaceFacade>(){

        @Override
        public NamespaceFacade load(String namespace) throws Exception {
            return new NamespaceFacade(NamespaceFacadeCache.this.client, namespace);
        }
    };
    private final LoadingCache<String, NamespaceFacade> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(this.loader);

    NamespaceFacadeCache(CuratorFrameworkImpl client) {
        this.client = client;
        this.nullNamespace = new NamespaceFacade(client, null);
    }

    NamespaceFacade get(String namespace) {
        try {
            return namespace != null ? this.cache.get(namespace) : this.nullNamespace;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

