/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.net.jodah.failsafe.internal;

import java.time.Duration;
import org.apache.kyuubi.shade.net.jodah.failsafe.CircuitBreaker;
import org.apache.kyuubi.shade.net.jodah.failsafe.internal.CircuitState;

public class OpenState
extends CircuitState {
    private final long startTime = System.nanoTime();
    private final long delayNanos;

    public OpenState(CircuitBreaker breaker, CircuitState previousState, Duration delay) {
        super(breaker, previousState.stats);
        this.delayNanos = delay.toNanos();
    }

    @Override
    public boolean allowsExecution() {
        if (System.nanoTime() - this.startTime >= this.delayNanos) {
            this.breaker.halfOpen();
            return true;
        }
        return false;
    }

    @Override
    public Duration getRemainingDelay() {
        long elapsedTime = System.nanoTime() - this.startTime;
        long remainingDelay = this.delayNanos - elapsedTime;
        return Duration.ofNanos(Math.max(remainingDelay, 0L));
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.OPEN;
    }
}

