/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.EngineRef$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.chat.ChatProcessBuilder;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder;
import org.apache.kyuubi.engine.hive.HiveProcessBuilder;
import org.apache.kyuubi.engine.jdbc.JdbcProcessBuilder;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.trino.TrinoProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.server.KyuubiServer$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t5c!\u0002\u00192\u0001MJ\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t?\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003g\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u001da\bA1A\u0005\nuDaA \u0001!\u0002\u0013i\u0005\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u00055\u0002\u0001)A\u0005\u0003\u001fA\u0011\"a\f\u0001\u0005\u0004%I!!\r\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003gA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0012\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u000fB\u0001\"a\u0015\u0001\u0005\u0004%I! \u0005\b\u0003+\u0002\u0001\u0015!\u0003N\u0011%\t9\u0006\u0001b\u0001\n\u0013\tI\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA.\u0011!\t\u0019\u0007\u0001b\u0001\n\u0013i\bbBA3\u0001\u0001\u0006I!\u0014\u0005\n\u0003O\u0002!\u0019!C\u0005\u0003SB\u0001\"!\u001d\u0001A\u0003%\u00111\u000e\u0005\f\u0003g\u0002\u0001\u0019!a\u0001\n\u0013\t)\bC\u0006\u0002~\u0001\u0001\r\u00111A\u0005\n\u0005}\u0004bCAF\u0001\u0001\u0007\t\u0011)Q\u0005\u0003oB\u0001\"!$\u0001\t\u0003\u0019\u0014q\u0012\u0005\n\u0003#\u0003!\u0019!C\u0001guDq!a%\u0001A\u0003%Q\nC\u0005\u0002\u0016\u0002\u0011\r\u0011\"\u00014{\"9\u0011q\u0013\u0001!\u0002\u0013i\u0005\"CAZ\u0001\t\u0007I\u0011A\u001a~\u0011\u001d\t)\f\u0001Q\u0001\n5C!\"!/\u0001\u0011\u000b\u0007I\u0011A\u001a~\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!?\u0001\t\u0013\tY\u0010C\u0004\u0003\u001c\u0001!\tA!\b\t\u0013\t\r\u0002!%A\u0005\u0002\t\u0015\u0002b\u0002B\u001e\u0001\u0011\u0005!QH\u0004\u000b\u0005\u007f\t\u0014\u0011!E\u0001g\t\u0005c!\u0003\u00192\u0003\u0003E\ta\rB\"\u0011\u0019\u0019X\u0006\"\u0001\u0003F!I!qI\u0017\u0012\u0002\u0013\u0005!\u0011\n\u0002\n\u000b:<\u0017N\\3SK\u001aT!AM\u001a\u0002\r\u0015tw-\u001b8f\u0015\t!T'\u0001\u0004lsV,(-\u001b\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014xmE\u0002\u0001u\u0001\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!C\u001b\u0005\u0019\u0014BA\"4\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001CA$K\u001b\u0005A%BA%4\u0003\u0019\u0019wN\u001c4jO&\u00111\n\u0013\u0002\u000b\u0017f,XOY5D_:4\u0017\u0001B;tKJ\u0004\"AT+\u000f\u0005=\u001b\u0006C\u0001)=\u001b\u0005\t&B\u0001*F\u0003\u0019a$o\\8u}%\u0011A\u000bP\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002Uy\u0005iqM]8vaB\u0013xN^5eKJ\u0004\"AW/\u000e\u0003mS!\u0001X\u001a\u0002\rAdWoZ5o\u0013\tq6LA\u0007He>,\b\u000f\u0015:pm&$WM]\u0001\fK:<\u0017N\\3SK\u001aLE-A\u0007f]\u001eLg.Z'b]\u0006<WM\u001d\t\u0003E\u000el\u0011!M\u0005\u0003IF\u0012\u0001dS=vk\nL\u0017\t\u001d9mS\u000e\fG/[8o\u001b\u0006t\u0017mZ3s\u0003]\u0019H/\u0019:ukB\u0004&o\\2fgN\u001cV-\\1qQ>\u0014X\rE\u0002<O&L!\u0001\u001b\u001f\u0003\r=\u0003H/[8o!\tQ\u0017/D\u0001l\u0015\taW.\u0001\u0006d_:\u001cWO\u001d:f]RT!A\\8\u0002\tU$\u0018\u000e\u001c\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u00118NA\u0005TK6\f\u0007\u000f[8sK\u00061A(\u001b8jiz\"r!\u001e<xqfT8\u0010\u0005\u0002c\u0001!)Ai\u0002a\u0001\r\")Aj\u0002a\u0001\u001b\")\u0001l\u0002a\u00013\")ql\u0002a\u0001\u001b\")\u0001m\u0002a\u0001C\"9Qm\u0002I\u0001\u0002\u00041\u0017aC:feZ,'o\u00159bG\u0016,\u0012!T\u0001\rg\u0016\u0014h/\u001a:Ta\u0006\u001cW\rI\u0001\bi&lWm\\;u+\t\t\u0019\u0001E\u0002<\u0003\u000bI1!a\u0002=\u0005\u0011auN\\4\u0002\u0011QLW.Z8vi\u0002\n!b\u001d5be\u0016dUM^3m+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005\u001db\u0002BA\n\u0003GqA!!\u0006\u0002\"9!\u0011qCA\u0010\u001d\u0011\tI\"!\b\u000f\u0007A\u000bY\"C\u00019\u0013\t1t'\u0003\u00025k%\u0011!gM\u0005\u0004\u0003K\t\u0014AC*iCJ,G*\u001a<fY&!\u0011\u0011FA\u0016\u0005)\u0019\u0006.\u0019:f\u0019\u00164X\r\u001c\u0006\u0004\u0003K\t\u0014aC:iCJ,G*\u001a<fY\u0002\n!\"\u001a8hS:,G+\u001f9f+\t\t\u0019\u0004\u0005\u0003\u00026\u0005mb\u0002BA\n\u0003oI1!!\u000f2\u0003))enZ5oKRK\b/Z\u0005\u0005\u0003{\tyD\u0001\u0006F]\u001eLg.\u001a+za\u0016T1!!\u000f2\u0003-)gnZ5oKRK\b/\u001a\u0011\u0002\u001bA|w\u000e\u001c+ie\u0016\u001c\bn\u001c7e+\t\t9\u0005E\u0002<\u0003\u0013J1!a\u0013=\u0005\rIe\u000e^\u0001\u000fa>|G\u000e\u00165sKNDw\u000e\u001c3!\u00039\u0019G.[3oiB{w\u000e\\*ju\u0016\fqb\u00197jK:$\bk\\8m'&TX\rI\u0001\u000fG2LWM\u001c;Q_>dg*Y7f\u0003=\u0019G.[3oiB{w\u000e\u001c(b[\u0016\u0004\u0013!G3oO&tW\rU8pY&;gn\u001c:f'V\u0014Gm\\7bS:,\"!a\u0017\u0011\u0007m\ni&C\u0002\u0002`q\u0012qAQ8pY\u0016\fg.\u0001\u000ef]\u001eLg.\u001a)p_2LuM\\8sKN+(\rZ8nC&t\u0007%\u0001\ff]\u001eLg.\u001a)p_2\u001cV\r\\3diB{G.[2z\u0003])gnZ5oKB{w\u000e\\*fY\u0016\u001cG\u000fU8mS\u000eL\b%\u0001\rM\u001f\u000e[u\fV%N\u000b>+FkX*Q\u0003:{f)Q\"U\u001fJ+\"!a\u001b\u0011\u0007m\ni'C\u0002\u0002pq\u0012a\u0001R8vE2,\u0017!\u0007'P\u0007.{F+S'F\u001fV#vl\u0015)B\u001d~3\u0015i\u0011+P%\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002xA\u0019!-!\u001f\n\u0007\u0005m\u0014GA\u0006Qe>\u001c')^5mI\u0016\u0014\u0018a\u00032vS2$WM]0%KF$B!!!\u0002\bB\u00191(a!\n\u0007\u0005\u0015EH\u0001\u0003V]&$\b\"CAE;\u0005\u0005\t\u0019AA<\u0003\rAH%M\u0001\tEVLG\u000eZ3sA\u0005qq-\u001a;F]\u001eLg.\u001a*fM&#G#A'\u0002\u000f\u0005\u0004\b/V:fe\u0006A\u0011\r\u001d9Vg\u0016\u0014\b%A\u0005tk\n$w.\\1j]\u0006Q1/\u001e2e_6\f\u0017N\u001c\u0011)\u0007\r\nY\n\u0005\u0003\u0002\u001e\u0006=VBAAP\u0015\u0011\t\t+a)\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0003K\u000b9+\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003S\u000bY+\u0001\u0004h_><G.\u001a\u0006\u0003\u0003[\u000b1aY8n\u0013\u0011\t\t,a(\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw-A\teK\u001a\fW\u000f\u001c;F]\u001eLg.\u001a(b[\u0016\f!\u0003Z3gCVdG/\u00128hS:,g*Y7fA!\u001aQ%a'\u0002\u0017\u0015tw-\u001b8f'B\f7-\u001a\u0015\u0004M\u0005m\u0015a\u0003;ss^KG\u000f\u001b'pG.,B!!1\u0002JR!\u00111YAs)\u0011\t)-a7\u0011\t\u0005\u001d\u0017\u0011\u001a\u0007\u0001\t\u001d\tYm\nb\u0001\u0003\u001b\u0014\u0011\u0001V\t\u0005\u0003\u001f\f)\u000eE\u0002<\u0003#L1!a5=\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aOAl\u0013\r\tI\u000e\u0010\u0002\u0004\u0003:L\b\u0002CAoO\u0011\u0005\r!a8\u0002\u0003\u0019\u0004RaOAq\u0003\u000bL1!a9=\u0005!a$-\u001f8b[\u0016t\u0004bBAtO\u0001\u0007\u0011\u0011^\u0001\u0010I&\u001c8m\u001c<fef\u001cE.[3oiB!\u00111^A{\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018AB2mS\u0016tGOC\u0002\u0002tN\n!\u0001[1\n\t\u0005]\u0018Q\u001e\u0002\u0010\t&\u001c8m\u001c<fef\u001cE.[3oi\u000611M]3bi\u0016$b!!@\u0003\u0004\t\u0015\u0001CB\u001e\u0002\u00006\u000b9%C\u0002\u0003\u0002q\u0012a\u0001V;qY\u0016\u0014\u0004bBAtQ\u0001\u0007\u0011\u0011\u001e\u0005\b\u0005\u000fA\u0003\u0019\u0001B\u0005\u00039)\u0007\u0010\u001e:b\u000b:<\u0017N\\3M_\u001e\u0004BaO4\u0003\fA!!Q\u0002B\f\u001b\t\u0011yA\u0003\u0003\u0003\u0012\tM\u0011a\u00017pO*\u0019!QC\u001a\u0002\u0013=\u0004XM]1uS>t\u0017\u0002\u0002B\r\u0005\u001f\u0011Ab\u00149fe\u0006$\u0018n\u001c8M_\u001e\f1bZ3u\u001fJ\u001c%/Z1uKR1\u0011Q B\u0010\u0005CAq!a:*\u0001\u0004\tI\u000fC\u0005\u0003\b%\u0002\n\u00111\u0001\u0003\n\u0005)r-\u001a;Pe\u000e\u0013X-\u0019;fI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0014U\u0011\u0011IA!\u000b,\u0005\t-\u0002\u0003\u0002B\u0017\u0005oi!Aa\f\u000b\t\tE\"1G\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000e=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0011yCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQa\u00197pg\u0016$\"!!!\u0002\u0013\u0015sw-\u001b8f%\u00164\u0007C\u00012.'\ti#\b\u0006\u0002\u0003B\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"Aa\u0013+\u0007\u0019\u0014I\u0003")
public class EngineRef
implements Logging {
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final String engineRefId;
    private final KyuubiApplicationManager engineManager;
    private final Option<Semaphore> startupProcessSemaphore;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    private final String clientPoolName;
    private final boolean enginePoolIgnoreSubdomain;
    private final String enginePoolSelectPolicy;
    private final double LOCK_TIMEOUT_SPAN_FACTOR;
    private ProcBuilder builder;
    private final String appUser;
    @VisibleForTesting
    private final String subdomain;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Option<Semaphore> $lessinit$greater$default$6() {
        return EngineRef$.MODULE$.$lessinit$greater$default$6();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    private String clientPoolName() {
        return this.clientPoolName;
    }

    private boolean enginePoolIgnoreSubdomain() {
        return this.enginePoolIgnoreSubdomain;
    }

    private String enginePoolSelectPolicy() {
        return this.enginePoolSelectPolicy;
    }

    private double LOCK_TIMEOUT_SPAN_FACTOR() {
        return this.LOCK_TIMEOUT_SPAN_FACTOR;
    }

    private ProcBuilder builder() {
        return this.builder;
    }

    private void builder_$eq(ProcBuilder x$1) {
        this.builder = x$1;
    }

    public String getEngineRefId() {
        return this.engineRefId;
    }

    public String appUser() {
        return this.appUser;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if (!this.bitmap$0) {
                String commonParent = new StringBuilder(3).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                this.engineSpace = !(value2 != null ? !value2.equals(value3) : value3 != null) ? DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.engineRefId})) : DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
                this.bitmap$0 = true;
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        if (!this.bitmap$0) {
            return this.engineSpace$lzycompute();
        }
        return this.engineSpace;
    }

    private <T> T tryWithLock(DiscoveryClient discoveryClient, Function0<T> f) {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (T)f.apply();
        }
        String lockPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(8).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_lock").toString(), this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
        return (T)discoveryClient.tryWithLock(lockPath, this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), f);
    }

    private Tuple2<String, Object> create(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
                boolean waitCompletion;
                boolean destroyProcess;
                Tuple2 tuple2;
                Logging logging;
                Option engineRef = discoveryClient.getServerHost(this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID(), (Object)$this.engineRefId);
                long started = System.currentTimeMillis();
                $this.conf.set("kyuubi.engine.submit.time", String.valueOf(started));
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                    logging = new SparkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                } else {
                    Enumeration.Value value4 = EngineType$.MODULE$.FLINK_SQL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        $this.conf.setIfMissing("flink.app.name", this.defaultEngineName());
                        logging = new FlinkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                    } else {
                        Enumeration.Value value6 = EngineType$.MODULE$.TRINO();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logging = new TrinoProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                        } else {
                            Enumeration.Value value8 = EngineType$.MODULE$.HIVE_SQL();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                $this.conf.setIfMissing("hive.engine.name", this.defaultEngineName());
                                logging = new HiveProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                            } else {
                                Enumeration.Value value10 = EngineType$.MODULE$.JDBC();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    logging = new JdbcProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                                } else {
                                    Enumeration.Value value12 = EngineType$.MODULE$.CHAT();
                                    Enumeration.Value value13 = value;
                                    if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                        logging = new ChatProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                                    } else {
                                        throw new MatchError((Object)value);
                                    }
                                }
                            }
                        }
                    }
                }
                this.builder_$eq((ProcBuilder)logging);
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                boolean acquiredPermit = false;
                try {
                    if (!$this.startupProcessSemaphore.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.tryAcquire(this.timeout(), TimeUnit.MILLISECONDS)))) {
                        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                            x$4.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                            return BoxedUnit.UNIT;
                        });
                        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(94).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" acquires a permit from engine builder semaphore.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                    }
                    acquiredPermit = true;
                    String redactedCmd = this.builder().toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(redactedCmd).toString());
                    this.builder().validateConf();
                    Process process = this.builder().start();
                    None$ exitValue = None$.MODULE$;
                    ObjectRef lastApplicationInfo = ObjectRef.create((Object)None$.MODULE$);
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS)) {
                            None$ none$ = exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
                            Some some = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                            if (none$ == null ? some != null : !none$.equals(some)) {
                                Throwable error = this.builder().getError();
                                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                    EngineRef.$anonfun$create$6(this, error, ms);
                                    return BoxedUnit.UNIT;
                                });
                                throw error;
                            }
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            Tuple2<Object, String> killMessage = $this.engineManager.killApplication(this.builder().appMgrInfo(), $this.engineRefId, (Option<String>)new Some((Object)this.appUser()));
                            this.builder().close(true);
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$5 -> {
                                x$5.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(70).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" launched ").append(this.engineType()).append(" engine with ").append(redactedCmd).append(". ").append(killMessage).toString(), this.builder().getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = discoveryClient.getEngineByRefId(this.engineSpace(), $this.engineRefId);
                        if (!engineRef.isEmpty()) continue;
                        None$ none$ = exitValue;
                        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                        if (none$ != null ? !none$.equals(some) : some != null) continue;
                        Option$.MODULE$.apply((Object)$this.engineManager).foreach((Function1 & Serializable & scala.Serializable)engineMgr -> {
                            EngineRef.$anonfun$create$8(this, lastApplicationInfo, started, engineMgr);
                            return BoxedUnit.UNIT;
                        });
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                catch (Throwable throwable) {
                    boolean waitCompletion2;
                    boolean destroyProcess2;
                    if (acquiredPermit) {
                        $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                            x$6.release();
                            return BoxedUnit.UNIT;
                        });
                    }
                    boolean bl = destroyProcess2 = !(waitCompletion2 = BoxesRunTime.unboxToBoolean((Object)$this.conf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_STARTUP_WAIT_COMPLETION()))) && this.builder().isClusterMode();
                    if (destroyProcess2) {
                        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                    }
                    this.builder().close(destroyProcess2);
                    throw throwable;
                }
                if (acquiredPermit) {
                    $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                        x$6.release();
                        return BoxedUnit.UNIT;
                    });
                }
                boolean bl = destroyProcess = !(waitCompletion = BoxesRunTime.unboxToBoolean((Object)$this.conf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_STARTUP_WAIT_COMPLETION()))) && this.builder().isClusterMode();
                if (destroyProcess) {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                }
                this.builder().close(destroyProcess);
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)discoveryClient.getServerHost(this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(discoveryClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public void close() {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        if (!(value != null ? !value.equals(value2) : value2 != null) && this.builder() != null) {
            try {
                ApplicationManagerInfo appMgrInfo = this.builder().appMgrInfo();
                this.builder().close(true);
                this.engineManager.killApplication(appMgrInfo, this.engineRefId, (Option<String>)new Some((Object)this.appUser()));
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error closing engine builder, engineRefId: ").append($this.engineRefId).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$create$6(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public static final /* synthetic */ void $anonfun$create$10(EngineRef $this, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{"ENGINE_TERMINATE"}));
    }

    public static final /* synthetic */ void $anonfun$create$9(EngineRef $this, ApplicationInfo appInfo) {
        if (ApplicationState$.MODULE$.isTerminated(appInfo.state())) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                EngineRef.$anonfun$create$10($this, ms);
                return BoxedUnit.UNIT;
            });
            throw new KyuubiSQLException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n                     |The engine application has been terminated. Please check the engine log.\n                     |ApplicationInfo: ").append(appInfo.toMap().mkString("(\n", ",\n", "\n)")).append("\n                     |").toString())).stripMargin(), $this.builder().getError());
        }
    }

    public static final /* synthetic */ void $anonfun$create$8(EngineRef $this, ObjectRef lastApplicationInfo$1, long started$1, KyuubiApplicationManager engineMgr) {
        if (((Option)lastApplicationInfo$1.elem).isDefined()) {
            TimeUnit.SECONDS.sleep(1L);
        }
        Option<ApplicationInfo> applicationInfo = engineMgr.getApplicationInfo($this.builder().appMgrInfo(), $this.engineRefId, (Option<String>)new Some((Object)$this.appUser()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)started$1)));
        applicationInfo.foreach((Function1 & Serializable & scala.Serializable)appInfo -> {
            EngineRef.$anonfun$create$9($this, appInfo);
            return BoxedUnit.UNIT;
        });
        lastApplicationInfo$1.elem = applicationInfo;
    }

    public EngineRef(KyuubiConf conf, String user, GroupProvider groupProvider, String engineRefId, KyuubiApplicationManager engineManager, Option<Semaphore> startupProcessSemaphore) {
        String string;
        String string2;
        this.conf = conf;
        this.engineRefId = engineRefId;
        this.engineManager = engineManager;
        this.startupProcessSemaphore = startupProcessSemaphore;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)((KyuubiConf)Option$.MODULE$.apply((Object)KyuubiServer$.MODULE$.kyuubiServer()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getConf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()))).get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        this.clientPoolName = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_NAME());
        this.enginePoolIgnoreSubdomain = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_IGNORE_SUBDOMAIN()));
        this.enginePoolSelectPolicy = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SELECT_POLICY());
        this.LOCK_TIMEOUT_SPAN_FACTOR = Utils$.MODULE$.isTesting() ? 0.5 : 0.1;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string2 = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value5 = value;
            string2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? groupProvider.primaryGroup(user, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf.getAll()).asJava()) : user;
        }
        this.appUser = string2;
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (this.clientPoolSize() > 0 && (option.isEmpty() || this.enginePoolIgnoreSubdomain())) {
            int n;
            String string3;
            int poolSize = scala.math.package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            if ("POLLING".equals(string3 = this.enginePoolSelectPolicy())) {
                String snPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(10).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_seqNum").toString(), this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.clientPoolName()}));
                n = BoxesRunTime.unboxToInt((Object)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(conf, (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToInteger((int)client.getAndIncrement(snPath, client.getAndIncrement$default$2()))));
            } else if ("RANDOM".equals(string3)) {
                n = Random$.MODULE$.nextInt(poolSize);
            } else {
                throw new MatchError((Object)string3);
            }
            int seqNum = n;
            string = new StringBuilder(1).append(this.clientPoolName()).append("-").append(seqNum % poolSize).toString();
        } else if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string = _subdomain = (String)some.value();
        } else {
            string = "default";
        }
        this.subdomain = string;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.appUser()).toString();
        Enumeration.Value value6 = this.shareLevel();
        Enumeration.Value value7 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value8 = value6;
        this.defaultEngineName = !(value7 != null ? !value7.equals(value8) : value8 != null) ? new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
    }
}

