/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Informable;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationInfo$;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationOperation;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.KubernetesApplicationAuditLogger$;
import org.apache.kyuubi.engine.KubernetesApplicationOperation$;
import org.apache.kyuubi.engine.KubernetesInfo;
import org.apache.kyuubi.util.KubernetesUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001\u0002\u001b6\u0001yBQ!\u0014\u0001\u0005\u00029Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004l\u0001\u0001\u0006IA\u0015\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019i\b\u0001)A\u0005]\"Ia\u0010\u0001a\u0001\u0002\u0004%Ia \u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0001C\u0006\u0002\u0016\u0001\u0001\r\u0011!Q!\n\u0005\u0005\u0001bCA\f\u0001\u0001\u0007\t\u0019!C\u0005\u00033A1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*!Y\u0011Q\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000e\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!a\u0014\u0001\t\u0013\t\t\u0004C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u0011Q\f\u0001!\u0002\u0013\t)\u0006C\u0006\u0002`\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0004bCAM\u0001\u0001\u0007\t\u0019!C\u0005\u00037C1\"a(\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002d!9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006\u0002CAU\u0001\u0011\u0005Q'a+\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBA_\u0001\u0011\u0005\u0013q\u0018\u0005\b\u0003#\u0004A\u0011IAj\u0011%\t\u0019\u0010AI\u0001\n\u0003\t)\u0010C\u0004\u0003\f\u0001!\tE!\u0004\t\u0013\tm\u0001!%A\u0005\u0002\u0005U\b\"\u0003B\u000f\u0001E\u0005I\u0011\u0001B\u0010\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005K1aAa\n\u0001\t\t%\u0002\"CAT=\t\u0005\t\u0015!\u0003]\u0011\u0019ie\u0004\"\u0001\u0003>!9!Q\t\u0010\u0005B\t\u001d\u0003b\u0002B'=\u0011\u0005#q\n\u0005\b\u00053rB\u0011\tB.\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005KBqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0004\u0003p\u0001!IA!\u001d\b\u000f\tUT\u0007#\u0001\u0003x\u00191A'\u000eE\u0001\u0005sBa!\u0014\u0015\u0005\u0002\tm\u0004\"\u0003B?Q\t\u0007I\u0011\u0001B@\u0011!\u0011)\t\u000bQ\u0001\n\t\u0005\u0005\"\u0003BDQ\t\u0007I\u0011\u0001B@\u0011!\u0011I\t\u000bQ\u0001\n\t\u0005\u0005\"\u0003BFQ\t\u0007I\u0011\u0001B@\u0011!\u0011i\t\u000bQ\u0001\n\t\u0005\u0005\"\u0003BHQ\t\u0007I\u0011\u0001B@\u0011!\u0011\t\n\u000bQ\u0001\n\t\u0005\u0005b\u0002BJQ\u0011\u0005!Q\u0013\u0005\b\u00053CC\u0011\u0001BN\u0005yYUOY3s]\u0016$Xm]!qa2L7-\u0019;j_:|\u0005/\u001a:bi&|gN\u0003\u00027o\u00051QM\\4j]\u0016T!\u0001O\u001d\u0002\r-LX/\u001e2j\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\u0004\u0001M!\u0001aP#J!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fMB\u0011aiR\u0007\u0002k%\u0011\u0001*\u000e\u0002\u0015\u0003B\u0004H.[2bi&|gn\u00149fe\u0006$\u0018n\u001c8\u0011\u0005)[U\"A\u001c\n\u00051;$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0003\"A\u0012\u0001\u0002#-,(-\u001a:oKR,7o\u00117jK:$8/F\u0001S!\u0011\u0019&\fX0\u000e\u0003QS!!\u0016,\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002X1\u0006!Q\u000f^5m\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017+\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002G;&\u0011a,\u000e\u0002\u000f\u0017V\u0014WM\u001d8fi\u0016\u001c\u0018J\u001c4p!\t\u0001\u0017.D\u0001b\u0015\t\u00117-\u0001\u0004dY&,g\u000e\u001e\u0006\u0003I\u0016\f!b[;cKJtW\r^3t\u0015\t1w-A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003!\f!![8\n\u0005)\f'\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003IYWOY3s]\u0016$Xm]\"mS\u0016tGo\u001d\u0011\u0002%\u0015tw-\u001b8f!>$\u0017J\u001c4pe6,'o]\u000b\u0002]B!1K\u0017/p!\r\u00018/^\u0007\u0002c*\u0011!/Y\u0001\nS:4wN]7feNL!\u0001^9\u0003'MC\u0017M]3e\u0013:$W\r_%oM>\u0014X.\u001a:\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018!B7pI\u0016d'B\u0001>d\u0003\r\t\u0007/[\u0005\u0003y^\u00141\u0001U8e\u0003M)gnZ5oKB{G-\u00138g_JlWM]:!\u00035\u0019XOY7jiRKW.Z8viV\u0011\u0011\u0011\u0001\t\u0004\u0001\u0006\r\u0011bAA\u0003\u0003\n!Aj\u001c8h\u0003E\u0019XOY7jiRKW.Z8vi~#S-\u001d\u000b\u0005\u0003\u0017\t\t\u0002E\u0002A\u0003\u001bI1!a\u0004B\u0005\u0011)f.\u001b;\t\u0013\u0005Mq!!AA\u0002\u0005\u0005\u0011a\u0001=%c\u0005q1/\u001e2nSR$\u0016.\\3pkR\u0004\u0013AC6zkV\u0014\u0017nQ8oMV\u0011\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\u001c\u0002\r\r|gNZ5h\u0013\u0011\t)#a\b\u0003\u0015-KX/\u001e2j\u0007>tg-\u0001\blsV,(-[\"p]\u001a|F%Z9\u0015\t\u0005-\u00111\u0006\u0005\n\u0003'Q\u0011\u0011!a\u0001\u00037\t1b[=vk\nL7i\u001c8gA\u0005y\u0011\r\u001c7po\u0016$7i\u001c8uKb$8/\u0006\u0002\u00024A1\u0011QGA\"\u0003\u0013rA!a\u000e\u0002@A\u0019\u0011\u0011H!\u000e\u0005\u0005m\"bAA\u001f{\u00051AH]8pizJ1!!\u0011B\u0003\u0019\u0001&/\u001a3fM&!\u0011QIA$\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u0003\n\u0005\u0003BA\u001b\u0003\u0017JA!!\u0014\u0002H\t11\u000b\u001e:j]\u001e\f\u0011#\u00197m_^,GMT1nKN\u0004\u0018mY3t\u00031\t\u0007\u000f]%oM>\u001cFo\u001c:f+\t\t)\u0006\u0005\u0004T5\u0006%\u0013q\u000b\t\u0004\r\u0006e\u0013bAA.k\ty\u0011\t\u001d9mS\u000e\fG/[8o\u0013:4w.A\u0007baBLeNZ8Ti>\u0014X\rI\u0001 G2,\u0017M\\;q)\u0016\u0014X.\u001b8bi\u0016$\u0017\t\u001d9J]\u001a|GK]5hO\u0016\u0014XCAA2!!\t)'a\u001e\u0002J\u0005mTBAA4\u0015\u0011\tI'a\u001b\u0002\u000b\r\f7\r[3\u000b\t\u00055\u0014qN\u0001\u0007G>lWn\u001c8\u000b\t\u0005E\u00141O\u0001\u0007O>|w\r\\3\u000b\u0005\u0005U\u0014aA2p[&!\u0011\u0011PA4\u0005\u0015\u0019\u0015m\u00195f!\u0011\ti(a%\u000f\t\u0005}\u0014q\u0012\b\u0005\u0003\u0003\u000biI\u0004\u0003\u0002\u0004\u0006-e\u0002BAC\u0003\u0013sA!!\u000f\u0002\b&\tA(\u0003\u0002;w%\u0011\u0001(O\u0005\u0003m]J1!!%6\u0003A\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006$X-\u0003\u0003\u0002\u0016\u0006]%\u0001E!qa2L7-\u0019;j_:\u001cF/\u0019;f\u0015\r\t\t*N\u0001$G2,\u0017M\\;q)\u0016\u0014X.\u001b8bi\u0016$\u0017\t\u001d9J]\u001a|GK]5hO\u0016\u0014x\fJ3r)\u0011\tY!!(\t\u0013\u0005M\u0011#!AA\u0002\u0005\r\u0014\u0001I2mK\u0006tW\u000f\u001d+fe6Lg.\u0019;fI\u0006\u0003\b/\u00138g_R\u0013\u0018nZ4fe\u0002\n1dZ3u\u001fJ\u001c%/Z1uK.+(-\u001a:oKR,7o\u00117jK:$HcA0\u0002&\"1\u0011qU\nA\u0002q\u000bab[;cKJtW\r^3t\u0013:4w.A\ndQ\u0016\u001c7nS;cKJtW\r^3t\u0013:4w\u000e\u0006\u0003\u0002\f\u00055\u0006BBAT)\u0001\u0007A,A\u000bck&dGmS;cKJtW\r^3t\u00072LWM\u001c;\u0015\u0007}\u000b\u0019\f\u0003\u0004\u0002(V\u0001\r\u0001X\u0001\u000bS:LG/[1mSj,G\u0003BA\u0006\u0003sCq!a/\u0017\u0001\u0004\tY\"\u0001\u0003d_:4\u0017aC5t'V\u0004\bo\u001c:uK\u0012$B!!1\u0002HB\u0019\u0001)a1\n\u0007\u0005\u0015\u0017IA\u0004C_>dW-\u00198\t\u000f\u0005%w\u00031\u0001\u0002L\u0006Q\u0011\r\u001d9NOJLeNZ8\u0011\u0007\u0019\u000bi-C\u0002\u0002PV\u0012a#\u00119qY&\u001c\u0017\r^5p]6\u000bg.Y4fe&sgm\\\u0001\u0015W&dG.\u00119qY&\u001c\u0017\r^5p]\nKH+Y4\u0015\u0011\u0005U\u00171]As\u0003S\u0004B!a6\u0002^:\u0019a)!7\n\u0007\u0005mW'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0017\u0011\u001d\u0002\r\u0017&dGNU3ta>t7/\u001a\u0006\u0004\u00037,\u0004bBAe1\u0001\u0007\u00111\u001a\u0005\b\u0003OD\u0002\u0019AA%\u0003\r!\u0018m\u001a\u0005\n\u0003WD\u0002\u0013!a\u0001\u0003[\f\u0011\u0002\u001d:pqf,6/\u001a:\u0011\u000b\u0001\u000by/!\u0013\n\u0007\u0005E\u0018I\u0001\u0004PaRLwN\\\u0001\u001fW&dG.\u00119qY&\u001c\u0017\r^5p]\nKH+Y4%I\u00164\u0017-\u001e7uIM*\"!a>+\t\u00055\u0018\u0011`\u0016\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!A\u0005v]\u000eDWmY6fI*\u0019!QA!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\n\u0005}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069r-\u001a;BaBd\u0017nY1uS>t\u0017J\u001c4p\u0005f$\u0016m\u001a\u000b\u000b\u0003/\u0012yA!\u0005\u0003\u0014\tU\u0001bBAe5\u0001\u0007\u00111\u001a\u0005\b\u0003OT\u0002\u0019AA%\u0011%\tYO\u0007I\u0001\u0002\u0004\ti\u000fC\u0005\u0003\u0018i\u0001\n\u00111\u0001\u0003\u001a\u0005Q1/\u001e2nSR$\u0016.\\3\u0011\u000b\u0001\u000by/!\u0001\u0002C\u001d,G/\u00119qY&\u001c\u0017\r^5p]&sgm\u001c\"z)\u0006<G\u0005Z3gCVdG\u000fJ\u001a\u0002C\u001d,G/\u00119qY&\u001c\u0017\r^5p]&sgm\u001c\"z)\u0006<G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005\"\u0006\u0002B\r\u0003s\fAa\u001d;paR\u0011\u00111\u0002\u0002\u001b'B\f'o[#oO&tW\rU8e\u000bZ,g\u000e\u001e%b]\u0012dWM]\n\u0006=\t-\"q\u0007\t\u0005\u0005[\u0011\u0019$\u0004\u0002\u00030)\u0019!\u0011\u0007-\u0002\t1\fgnZ\u0005\u0005\u0005k\u0011yC\u0001\u0004PE*,7\r\u001e\t\u0005a\neR/C\u0002\u0003<E\u0014ACU3t_V\u00148-Z#wK:$\b*\u00198eY\u0016\u0014H\u0003\u0002B \u0005\u0007\u00022A!\u0011\u001f\u001b\u0005\u0001\u0001BBATA\u0001\u0007A,A\u0003p]\u0006#G\r\u0006\u0003\u0002\f\t%\u0003B\u0002B&C\u0001\u0007Q/A\u0002q_\u0012\f\u0001b\u001c8Va\u0012\fG/\u001a\u000b\u0007\u0003\u0017\u0011\tF!\u0016\t\r\tM#\u00051\u0001v\u0003\u0019yG\u000e\u001a)pI\"1!q\u000b\u0012A\u0002U\faA\\3x!>$\u0017\u0001C8o\t\u0016dW\r^3\u0015\r\u0005-!Q\fB0\u0011\u0019\u0011Ye\ta\u0001k\"9!\u0011M\u0012A\u0002\u0005\u0005\u0017\u0001\u00073fY\u0016$X\r\u001a$j]\u0006d7\u000b^1uKVs7N\\8x]\u0006\u0001\u0012n]*qCJ\\WI\\4j]\u0016\u0004v\u000e\u001a\u000b\u0005\u0003\u0003\u00149\u0007\u0003\u0004\u0003L\u0011\u0002\r!^\u0001\u0017kB$\u0017\r^3BaBd\u0017nY1uS>t7\u000b^1uKR!\u00111\u0002B7\u0011\u0019\u0011Y%\na\u0001k\u0006IR.\u0019:l\u0003B\u0004H.[2bi&|g\u000eV3s[&t\u0017\r^3e)\u0011\tYAa\u001d\t\r\t-c\u00051\u0001v\u0003yYUOY3s]\u0016$Xm]!qa2L7-\u0019;j_:|\u0005/\u001a:bi&|g\u000e\u0005\u0002GQM\u0019\u0001fP%\u0015\u0005\t]\u0014a\u0006'B\u0005\u0016culS-V+\nKu,\u0016(J#V+ulS#Z+\t\u0011\t\t\u0005\u0003\u0003.\t\r\u0015\u0002BA'\u0005_\t\u0001\u0004T!C\u000b2{6*W+V\u0005&{VKT%R+\u0016{6*R-!\u0003I\u0019\u0006+\u0011*L?\u0006\u0003\u0006kX%E?2\u000b%)\u0012'\u0002'M\u0003\u0016IU&`\u0003B\u0003v,\u0013#`\u0019\u0006\u0013U\t\u0014\u0011\u0002/-+&)\u0012*O\u000bR+5kX*F%ZK5)R0I\u001fN#\u0016\u0001G&V\u0005\u0016\u0013f*\u0012+F'~\u001bVI\u0015,J\u0007\u0016{\u0006jT*UA\u000592*\u0016\"F%:+E+R*`'\u0016\u0013f+S\"F?B{%\u000bV\u0001\u0019\u0017V\u0013UI\u0015(F)\u0016\u001bvlU#S-&\u001bUi\u0018)P%R\u0003\u0013a\u0002;p\u0019\u0006\u0014W\r\u001c\u000b\u0005\u0003\u0013\u00129\nC\u0004\u0002hJ\u0002\r!!\u0013\u0002%Q|\u0017\t\u001d9mS\u000e\fG/[8o'R\fG/\u001a\u000b\u0005\u0003w\u0012i\nC\u0004\u0003 N\u0002\r!!\u0013\u0002\u000bM$\u0018\r^3")
public class KubernetesApplicationOperation
implements ApplicationOperation,
Logging {
    private final ConcurrentHashMap<KubernetesInfo, KubernetesClient> kubernetesClients;
    private final ConcurrentHashMap<KubernetesInfo, SharedIndexInformer<Pod>> enginePodInformers;
    private long submitTimeout;
    private KyuubiConf kyuubiConf;
    private final ConcurrentHashMap<String, ApplicationInfo> appInfoStore;
    private Cache<String, Enumeration.Value> cleanupTerminatedAppInfoTrigger;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static Enumeration.Value toApplicationState(String string) {
        return KubernetesApplicationOperation$.MODULE$.toApplicationState(string);
    }

    public static String toLabel(String string) {
        return KubernetesApplicationOperation$.MODULE$.toLabel(string);
    }

    public static String KUBERNETES_SERVICE_PORT() {
        return KubernetesApplicationOperation$.MODULE$.KUBERNETES_SERVICE_PORT();
    }

    public static String KUBERNETES_SERVICE_HOST() {
        return KubernetesApplicationOperation$.MODULE$.KUBERNETES_SERVICE_HOST();
    }

    public static String SPARK_APP_ID_LABEL() {
        return KubernetesApplicationOperation$.MODULE$.SPARK_APP_ID_LABEL();
    }

    public static String LABEL_KYUUBI_UNIQUE_KEY() {
        return KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<KubernetesInfo, KubernetesClient> kubernetesClients() {
        return this.kubernetesClients;
    }

    private ConcurrentHashMap<KubernetesInfo, SharedIndexInformer<Pod>> enginePodInformers() {
        return this.enginePodInformers;
    }

    private long submitTimeout() {
        return this.submitTimeout;
    }

    private void submitTimeout_$eq(long x$1) {
        this.submitTimeout = x$1;
    }

    private KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    private void kyuubiConf_$eq(KyuubiConf x$1) {
        this.kyuubiConf = x$1;
    }

    private Set<String> allowedContexts() {
        return (Set)this.kyuubiConf().get(KyuubiConf$.MODULE$.KUBERNETES_CONTEXT_ALLOW_LIST());
    }

    private Set<String> allowedNamespaces() {
        return (Set)this.kyuubiConf().get(KyuubiConf$.MODULE$.KUBERNETES_NAMESPACE_ALLOW_LIST());
    }

    private ConcurrentHashMap<String, ApplicationInfo> appInfoStore() {
        return this.appInfoStore;
    }

    private Cache<String, Enumeration.Value> cleanupTerminatedAppInfoTrigger() {
        return this.cleanupTerminatedAppInfoTrigger;
    }

    private void cleanupTerminatedAppInfoTrigger_$eq(Cache<String, Enumeration.Value> x$1) {
        this.cleanupTerminatedAppInfoTrigger = x$1;
    }

    private KubernetesClient getOrCreateKubernetesClient(KubernetesInfo kubernetesInfo) {
        this.checkKubernetesInfo(kubernetesInfo);
        return this.kubernetesClients().computeIfAbsent(kubernetesInfo, kInfo -> this.buildKubernetesClient((KubernetesInfo)kInfo));
    }

    public void checkKubernetesInfo(KubernetesInfo kubernetesInfo) {
        Option<String> context = kubernetesInfo.context();
        Option<String> namespace = kubernetesInfo.namespace();
        if (this.allowedContexts().nonEmpty() && context.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesApplicationOperation.$anonfun$checkKubernetesInfo$1(this, x$1)))) {
            throw new KyuubiException(new StringBuilder(48).append("Kubernetes context ").append(context).append(" is not in the allowed list[").append(this.allowedContexts()).append("]").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        if (this.allowedNamespaces().nonEmpty() && namespace.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KubernetesApplicationOperation.$anonfun$checkKubernetesInfo$2(this, x$2)))) {
            throw new KyuubiException(new StringBuilder(50).append("Kubernetes namespace ").append(namespace).append(" is not in the allowed list[").append(this.allowedNamespaces()).append("]").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private KubernetesClient buildKubernetesClient(KubernetesInfo kubernetesInfo) {
        KyuubiConf kubernetesConf = this.kyuubiConf().getKubernetesConf(kubernetesInfo.context(), kubernetesInfo.namespace());
        Option<KubernetesClient> option = KubernetesUtils$.MODULE$.buildKubernetesClient(kubernetesConf);
        if (option instanceof Some) {
            Some some = (Some)option;
            KubernetesClient client = (KubernetesClient)some.value();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("[").append(kubernetesInfo).append("] Initialized Kubernetes Client connect to: ").append(client.getMasterUrl()).toString());
            SharedIndexInformer enginePodInformer = ((Informable)client.pods().withLabel(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY())).inform((ResourceEventHandler)new SparkEnginePodEventHandler(this, kubernetesInfo));
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("[").append(kubernetesInfo).append("] Start Kubernetes Client Informer.").toString());
            this.enginePodInformers().put(kubernetesInfo, (SharedIndexInformer<Pod>)enginePodInformer);
            return client;
        }
        if (None$.MODULE$.equals(option)) {
            throw new KyuubiException(new StringBuilder(36).append("Fail to build Kubernetes client for ").append(kubernetesInfo).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(option);
    }

    @Override
    public void initialize(KyuubiConf conf) {
        this.kyuubiConf_$eq(conf);
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Start initializing Kubernetes application operation.");
        this.submitTimeout_$eq(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_KUBERNETES_SUBMIT_TIMEOUT())));
        long retainPeriod = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.KUBERNETES_TERMINATED_APPLICATION_RETAIN_PERIOD()));
        this.cleanupTerminatedAppInfoTrigger_$eq((Cache<String, Enumeration.Value>)CacheBuilder.newBuilder().expireAfterWrite(retainPeriod, TimeUnit.MILLISECONDS).removalListener(notification -> Option$.MODULE$.apply((Object)this.appInfoStore().remove(notification.getKey())).foreach((Function1 & Serializable & scala.Serializable)removed -> {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Remove terminated application ").append(removed.id()).append(" with ").append("[").append(KubernetesApplicationOperation$.MODULE$.toLabel((String)notification$1.getKey())).append(", state: ").append(removed.state()).append("]").toString());
            return BoxedUnit.UNIT;
        })).build());
    }

    @Override
    public boolean isSupported(ApplicationManagerInfo appMgrInfo) {
        return this.kyuubiConf() != null && appMgrInfo.resourceManager().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KubernetesApplicationOperation.$anonfun$isSupported$1(x$3)));
    }

    @Override
    public Tuple2<Object, String> killApplicationByTag(ApplicationManagerInfo appMgrInfo, String tag, Option<String> proxyUser) {
        Tuple2 tuple2;
        block9: {
            if (this.kyuubiConf() == null) {
                throw new IllegalStateException("Methods initialize and isSupported must be called ahead");
            }
            KubernetesInfo kubernetesInfo = appMgrInfo.kubernetesInfo();
            KubernetesClient kubernetesClient = this.getOrCreateKubernetesClient(kubernetesInfo);
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("[").append(kubernetesInfo).append("] Deleting application[").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append("]'s info from Kubernetes cluster").toString());
            try {
                Option option = Option$.MODULE$.apply((Object)this.appInfoStore().get(tag));
                if (option instanceof Some) {
                    boolean bl;
                    Some some = (Some)option;
                    ApplicationInfo info = (ApplicationInfo)some.value();
                    this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Application[").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append("] is in ").append(info.state()).append(" state").toString());
                    Enumeration.Value value = info.state();
                    Enumeration.Value value2 = ApplicationState$.MODULE$.NOT_FOUND();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Value value4 = ApplicationState$.MODULE$.FAILED();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            bl = true;
                        } else {
                            Enumeration.Value value6 = ApplicationState$.MODULE$.UNKNOWN();
                            Enumeration.Value value7 = value;
                            bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
                        }
                    }
                    tuple2 = bl ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(36).append("[").append(kubernetesInfo).append("] Target application[").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append("] is in ").append(info.state()).append(" state").toString()) : new Tuple2((Object)BoxesRunTime.boxToBoolean((!((Deletable)kubernetesClient.pods().withName(info.name())).delete().isEmpty() ? 1 : 0) != 0), (Object)new StringBuilder(59).append("[").append(kubernetesInfo).append("] Operation of deleted").append(" application[appId: ").append(info.id()).append(", ").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append("] is completed").toString());
                    break block9;
                }
                if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("No application info found, trying to delete pod with ").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).toString());
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((!((Deletable)kubernetesClient.pods().withLabel(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY(), tag)).delete().isEmpty() ? 1 : 0) != 0), (Object)new StringBuilder(46).append("[").append(kubernetesInfo).append("] Operation of deleted pod with ").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append(" is completed").toString());
                    break block9;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(45).append("[").append(kubernetesInfo).append("] Failed to terminate application[").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append("], ").append("due to ").append(e.getMessage()).toString());
            }
        }
        return tuple2;
    }

    @Override
    public Option<String> killApplicationByTag$default$3() {
        return None$.MODULE$;
    }

    @Override
    public ApplicationInfo getApplicationInfoByTag(ApplicationManagerInfo appMgrInfo, String tag, Option<String> proxyUser, Option<Object> submitTime) {
        ApplicationInfo applicationInfo;
        block9: {
            if (this.kyuubiConf() == null) {
                throw new IllegalStateException("Methods initialize and isSupported must be called ahead");
            }
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Getting application[").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append("]'s info from Kubernetes cluster").toString());
            try {
                this.getOrCreateKubernetesClient(appMgrInfo.kubernetesInfo());
                ApplicationInfo appInfo = this.appInfoStore().getOrDefault(tag, ApplicationInfo$.MODULE$.NOT_FOUND());
                Tuple2 tuple2 = new Tuple2((Object)appInfo.state(), submitTime);
                if (tuple2 != null) {
                    Enumeration.Value value = (Enumeration.Value)tuple2._1();
                    Option option = (Option)tuple2._2();
                    Enumeration.Value value2 = ApplicationState$.MODULE$.NOT_FOUND();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null) && option instanceof Some) {
                        Some some = (Some)option;
                        long _submitTime = BoxesRunTime.unboxToLong((Object)some.value());
                        long elapsedTime = System.currentTimeMillis() - _submitTime;
                        if (elapsedTime > this.submitTimeout()) {
                            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Can't find target driver pod by ").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append(", ").append("elapsed time: ").append(elapsedTime).append("ms exceeds ").append(this.submitTimeout()).append("ms.").toString());
                            applicationInfo = ApplicationInfo$.MODULE$.NOT_FOUND();
                        } else {
                            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("Waiting for driver pod with ").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append(" to be created, ").append("elapsed time: ").append(elapsedTime).append("ms, return UNKNOWN status").toString());
                            applicationInfo = ApplicationInfo$.MODULE$.UNKNOWN();
                        }
                        break block9;
                    }
                }
                if (tuple2 != null) {
                    Enumeration.Value value = (Enumeration.Value)tuple2._1();
                    Option option = (Option)tuple2._2();
                    Enumeration.Value value4 = ApplicationState$.MODULE$.NOT_FOUND();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null) && None$.MODULE$.equals(option)) {
                        applicationInfo = ApplicationInfo$.MODULE$.NOT_FOUND();
                        break block9;
                    }
                }
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Successfully got application[").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append("]'s info: ").append(appInfo).toString());
                applicationInfo = appInfo;
            }
            catch (Exception e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Failed to get application by ").append(KubernetesApplicationOperation$.MODULE$.toLabel(tag)).append(", due to ").append(e.getMessage()).toString());
                applicationInfo = ApplicationInfo$.MODULE$.NOT_FOUND();
            }
        }
        return applicationInfo;
    }

    @Override
    public Option<String> getApplicationInfoByTag$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Option<Object> getApplicationInfoByTag$default$4() {
        return None$.MODULE$;
    }

    @Override
    public void stop() {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.enginePodInformers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KubernetesApplicationOperation.$anonfun$stop$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.enginePodInformers().clear();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.kubernetesClients()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            KubernetesApplicationOperation.$anonfun$stop$3(x0$2);
            return BoxedUnit.UNIT;
        });
        this.kubernetesClients().clear();
        if (this.cleanupTerminatedAppInfoTrigger() != null) {
            this.cleanupTerminatedAppInfoTrigger().cleanUp();
            this.cleanupTerminatedAppInfoTrigger_$eq(null);
            return;
        }
    }

    public boolean org$apache$kyuubi$engine$KubernetesApplicationOperation$$isSparkEnginePod(Pod pod) {
        Map labels = pod.getMetadata().getLabels();
        return labels.containsKey(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY()) && labels.containsKey(KubernetesApplicationOperation$.MODULE$.SPARK_APP_ID_LABEL());
    }

    public void org$apache$kyuubi$engine$KubernetesApplicationOperation$$updateApplicationState(Pod pod) {
        Enumeration.Value appState = KubernetesApplicationOperation$.MODULE$.toApplicationState(pod.getStatus().getPhase());
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Driver Informer changes pod: ").append(pod.getMetadata().getName()).append(" to state: ").append(appState).toString());
        String x$1 = (String)pod.getMetadata().getLabels().get(KubernetesApplicationOperation$.MODULE$.SPARK_APP_ID_LABEL());
        String x$2 = pod.getMetadata().getName();
        Enumeration.Value x$3 = appState;
        Option x$4 = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option<String> x$5 = ApplicationInfo$.MODULE$.apply$default$4();
        this.appInfoStore().put((String)pod.getMetadata().getLabels().get(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY()), new ApplicationInfo(x$1, x$2, x$3, x$5, (Option<String>)x$4));
    }

    public synchronized void org$apache$kyuubi$engine$KubernetesApplicationOperation$$markApplicationTerminated(Pod pod) {
        String key = (String)pod.getMetadata().getLabels().get(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY());
        if (this.cleanupTerminatedAppInfoTrigger().getIfPresent((Object)key) == null) {
            this.cleanupTerminatedAppInfoTrigger().put((Object)key, (Object)KubernetesApplicationOperation$.MODULE$.toApplicationState(pod.getStatus().getPhase()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkKubernetesInfo$1(KubernetesApplicationOperation $this, String x$1) {
        return !$this.allowedContexts().contains((Object)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$checkKubernetesInfo$2(KubernetesApplicationOperation $this, String x$2) {
        return !$this.allowedNamespaces().contains((Object)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$isSupported$1(String x$3) {
        return x$3.toLowerCase(Locale.ROOT).startsWith("k8s");
    }

    public static final /* synthetic */ void $anonfun$stop$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SharedIndexInformer informer = (SharedIndexInformer)tuple2._2();
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> informer.stop());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$stop$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            KubernetesClient client = (KubernetesClient)tuple2._2();
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> client.close());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public KubernetesApplicationOperation() {
        Logging.$init$((Logging)this);
        this.kubernetesClients = new ConcurrentHashMap();
        this.enginePodInformers = new ConcurrentHashMap();
        this.appInfoStore = new ConcurrentHashMap();
    }

    private class SparkEnginePodEventHandler
    implements ResourceEventHandler<Pod> {
        private final KubernetesInfo kubernetesInfo;
        public final /* synthetic */ KubernetesApplicationOperation $outer;

        public void onNothing() {
            super.onNothing();
        }

        public void onAdd(Pod pod) {
            if (this.org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer().org$apache$kyuubi$engine$KubernetesApplicationOperation$$isSparkEnginePod(pod)) {
                this.org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer().org$apache$kyuubi$engine$KubernetesApplicationOperation$$updateApplicationState(pod);
                KubernetesApplicationAuditLogger$.MODULE$.audit(this.kubernetesInfo, pod);
                return;
            }
        }

        public void onUpdate(Pod oldPod, Pod newPod) {
            if (this.org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer().org$apache$kyuubi$engine$KubernetesApplicationOperation$$isSparkEnginePod(newPod)) {
                this.org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer().org$apache$kyuubi$engine$KubernetesApplicationOperation$$updateApplicationState(newPod);
                Enumeration.Value appState = KubernetesApplicationOperation$.MODULE$.toApplicationState(newPod.getStatus().getPhase());
                if (ApplicationState$.MODULE$.isTerminated(appState)) {
                    this.org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer().org$apache$kyuubi$engine$KubernetesApplicationOperation$$markApplicationTerminated(newPod);
                }
                KubernetesApplicationAuditLogger$.MODULE$.audit(this.kubernetesInfo, newPod);
                return;
            }
        }

        public void onDelete(Pod pod, boolean deletedFinalStateUnknown) {
            if (this.org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer().org$apache$kyuubi$engine$KubernetesApplicationOperation$$isSparkEnginePod(pod)) {
                this.org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer().org$apache$kyuubi$engine$KubernetesApplicationOperation$$updateApplicationState(pod);
                this.org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer().org$apache$kyuubi$engine$KubernetesApplicationOperation$$markApplicationTerminated(pod);
                KubernetesApplicationAuditLogger$.MODULE$.audit(this.kubernetesInfo, pod);
                return;
            }
        }

        public /* synthetic */ KubernetesApplicationOperation org$apache$kyuubi$engine$KubernetesApplicationOperation$SparkEnginePodEventHandler$$$outer() {
            return this.$outer;
        }

        public SparkEnginePodEventHandler(KubernetesApplicationOperation $outer, KubernetesInfo kubernetesInfo) {
            this.kubernetesInfo = kubernetesInfo;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

