/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.hive.metastore;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.kyuubi.shaded.hive.metastore.IMetaStoreClient;
import org.apache.kyuubi.shaded.hive.metastore.MetaStorePlainSaslHelper;
import org.apache.kyuubi.shaded.hive.metastore.api.MetaException;
import org.apache.kyuubi.shaded.hive.metastore.api.ThriftHiveMetastore;
import org.apache.kyuubi.shaded.hive.metastore.conf.MetastoreConf;
import org.apache.kyuubi.shaded.hive.metastore.hooks.URIResolverHook;
import org.apache.kyuubi.shaded.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.kyuubi.shaded.hive.metastore.utils.JavaUtils;
import org.apache.kyuubi.shaded.hive.metastore.utils.MetaStoreUtils;
import org.apache.kyuubi.shaded.hive.metastore.utils.SecurityUtils;
import org.apache.kyuubi.shaded.thrift.TConfiguration;
import org.apache.kyuubi.shaded.thrift.TException;
import org.apache.kyuubi.shaded.thrift.protocol.TBinaryProtocol;
import org.apache.kyuubi.shaded.thrift.protocol.TCompactProtocol;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocol;
import org.apache.kyuubi.shaded.thrift.transport.THttpClient;
import org.apache.kyuubi.shaded.thrift.transport.TSocket;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.apache.kyuubi.shaded.thrift.transport.layered.TFramedTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HiveMetaStoreClient
implements IMetaStoreClient,
AutoCloseable {
    ThriftHiveMetastore.Iface client = null;
    private TTransport transport = null;
    private boolean isConnected = false;
    private URI[] metastoreUris;
    protected final Configuration conf;
    private String tokenStrForm;
    private final boolean localMetaStore;
    private final URIResolverHook uriResolverHook;
    private Map<String, String> currentMetaVars;
    private static final AtomicInteger connCount = new AtomicInteger(0);
    private int retries = 5;
    private long retryDelaySeconds = 0L;
    protected static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreClient.class);

    public HiveMetaStoreClient(Configuration conf) throws MetaException {
        this.conf = conf == null ? (conf = MetastoreConf.newMetastoreConf()) : new Configuration(conf);
        this.uriResolverHook = this.loadUriResolverHook();
        String msUri = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS);
        this.localMetaStore = MetastoreConf.isEmbeddedMetaStore(msUri);
        if (this.localMetaStore) {
            this.isConnected = true;
            return;
        }
        this.retries = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES);
        this.retryDelaySeconds = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
        if (MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS) == null) {
            LOG.error("NOT getting uris from conf");
            throw new MetaException("MetaStoreURIs not found in conf file");
        }
        this.resolveUris();
        this.open();
    }

    /*
     * WARNING - void declaration
     */
    private void resolveUris() throws MetaException {
        List<String> metastoreUrisString;
        String serviceDiscoveryMode;
        block14: {
            String thriftUris = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URIS);
            serviceDiscoveryMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_SERVICE_DISCOVERY_MODE);
            metastoreUrisString = null;
            try {
                if (serviceDiscoveryMode == null || serviceDiscoveryMode.trim().isEmpty()) {
                    metastoreUrisString = Arrays.asList(thriftUris.split(","));
                    break block14;
                }
                if (serviceDiscoveryMode.equalsIgnoreCase("zookeeper")) {
                    metastoreUrisString = new ArrayList<String>();
                    for (String string : MetastoreConf.getZKConfig(this.conf).getServerUris()) {
                        metastoreUrisString.add("thrift://" + string);
                    }
                    break block14;
                }
                throw new IllegalArgumentException("Invalid metastore dynamic service discovery mode " + serviceDiscoveryMode);
            }
            catch (Exception e) {
                MetaStoreUtils.throwMetaException(e);
            }
        }
        if (metastoreUrisString.isEmpty() && "zookeeper".equalsIgnoreCase(serviceDiscoveryMode)) {
            throw new MetaException("No metastore service discovered in ZooKeeper. Please ensure that at least one metastore server is online");
        }
        LOG.info("Resolved metastore uris: {}", metastoreUrisString);
        ArrayList<URI> metastoreURIArray = new ArrayList<URI>();
        try {
            void var5_9;
            for (String s : metastoreUrisString) {
                URI tmpUri = new URI(s);
                if (tmpUri.getScheme() == null) {
                    throw new IllegalArgumentException("URI: " + s + " does not have a scheme");
                }
                if (this.uriResolverHook != null) {
                    metastoreURIArray.addAll(this.uriResolverHook.resolveURI(tmpUri));
                    continue;
                }
                metastoreURIArray.add(tmpUri);
            }
            this.metastoreUris = new URI[metastoreURIArray.size()];
            boolean bl = false;
            while (var5_9 < metastoreURIArray.size()) {
                this.metastoreUris[var5_9] = (URI)metastoreURIArray.get((int)var5_9);
                ++var5_9;
            }
            if (MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URI_SELECTION).equalsIgnoreCase("RANDOM")) {
                List<URI> list = Arrays.asList(this.metastoreUris);
                Collections.shuffle(list);
                this.metastoreUris = list.toArray(new URI[list.size()]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            MetaStoreUtils.throwMetaException(exception);
        }
    }

    private synchronized URIResolverHook loadUriResolverHook() throws IllegalStateException {
        String uriResolverClassName = MetastoreConf.getAsString(this.conf, MetastoreConf.ConfVars.URI_RESOLVER);
        if (uriResolverClassName.equals("")) {
            return null;
        }
        LOG.info("Loading uri resolver : " + uriResolverClassName);
        try {
            Class<?> uriResolverClass = Class.forName(uriResolverClassName, true, JavaUtils.getClassLoader());
            return (URIResolverHook)ReflectionUtils.newInstance(uriResolverClass, null);
        }
        catch (Exception e) {
            LOG.error("Exception loading uri resolver hook", (Throwable)e);
            return null;
        }
    }

    private void promoteRandomMetaStoreURI() {
        if (this.metastoreUris.length <= 1) {
            return;
        }
        Random rng = new Random();
        int index = rng.nextInt(this.metastoreUris.length - 1) + 1;
        URI tmp = this.metastoreUris[0];
        this.metastoreUris[0] = this.metastoreUris[index];
        this.metastoreUris[index] = tmp;
    }

    public TTransport getTTransport() {
        return this.transport;
    }

    @Override
    public boolean isLocalMetaStore() {
        return this.localMetaStore;
    }

    @Override
    public void reconnect() throws MetaException {
        if (this.localMetaStore) {
            throw new MetaException("Retries for direct MetaStore DB connections are not supported by this client");
        }
        this.close();
        if (this.uriResolverHook != null) {
            this.resolveUris();
        }
        if (MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URI_SELECTION).equalsIgnoreCase("RANDOM")) {
            this.promoteRandomMetaStoreURI();
        }
        this.open();
    }

    private <T extends TTransport> T configureThriftMaxMessageSize(T transport) {
        int maxThriftMessageSize = (int)MetastoreConf.getSizeVar(this.conf, MetastoreConf.ConfVars.THRIFT_METASTORE_CLIENT_MAX_MESSAGE_SIZE);
        if (maxThriftMessageSize > 0) {
            if (transport.getConfiguration() == null) {
                LOG.warn("TTransport {} is returning a null Configuration, Thrift max message size is not getting configured", (Object)transport.getClass().getName());
                return transport;
            }
            transport.getConfiguration().setMaxMessageSize(maxThriftMessageSize);
        }
        return transport;
    }

    private Map<String, String> getAdditionalHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String keyValuePairs = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_ADDITIONAL_HEADERS);
        try {
            String[] headerKeyValues;
            for (String header : headerKeyValues = keyValuePairs.split(",")) {
                String[] parts = header.split("=");
                headers.put(parts[0].trim(), parts[1].trim());
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not parse the headers provided in " + (Object)((Object)MetastoreConf.ConfVars.METASTORE_CLIENT_ADDITIONAL_HEADERS), (Throwable)ex);
        }
        return headers;
    }

    private THttpClient createHttpClient(URI store, boolean useSSL) throws MetaException, TTransportException {
        THttpClient tHttpClient;
        String path = MetaStoreUtils.getHttpPath(MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_HTTP_PATH));
        String urlScheme = useSSL || Objects.equals(store.getScheme(), "https") ? "https://" : "http://";
        String httpUrl = urlScheme + store.getHost() + ":" + store.getPort() + path;
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder();
        try {
            if (useSSL) {
                String trustStorePath = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH).trim();
                if (trustStorePath.isEmpty()) {
                    throw new IllegalArgumentException((Object)((Object)MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH) + " Not configured for SSL connection");
                }
                String trustStorePassword = MetastoreConf.getPassword(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_PASSWORD);
                String trustStoreType = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_TYPE).trim();
                String trustStoreAlgorithm = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTMANAGERFACTORY_ALGORITHM).trim();
                tHttpClient = SecurityUtils.getThriftHttpsClient(httpUrl, trustStorePath, trustStorePassword, trustStoreAlgorithm, trustStoreType, httpClientBuilder);
            } else {
                tHttpClient = new THttpClient(httpUrl, (HttpClient)httpClientBuilder.build());
            }
        }
        catch (Exception e) {
            if (e instanceof TTransportException) {
                throw (TTransportException)e;
            }
            throw new MetaException("Failed to create http transport client to url: " + httpUrl + ". Error:" + e);
        }
        LOG.debug("Created thrift http client for URL: " + httpUrl);
        return this.configureThriftMaxMessageSize(tHttpClient);
    }

    protected HttpClientBuilder createHttpClientBuilder() throws MetaException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        String authType = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_AUTH_MODE);
        final Map<String, String> additionalHeaders = this.getAdditionalHeaders();
        if (authType.equalsIgnoreCase("jwt")) {
            final String jwtToken = System.getenv("HMS_JWT");
            if (jwtToken == null || jwtToken.isEmpty()) {
                LOG.debug("No jwt token set in environment variable: HMS_JWT");
                throw new MetaException("For auth mode JWT, valid signed jwt token must be provided in the environment variable HMS_JWT");
            }
            httpClientBuilder.addInterceptorFirst(new HttpRequestInterceptor(){

                public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                    httpRequest.addHeader("Authorization", "Bearer " + jwtToken);
                    for (Map.Entry entry : additionalHeaders.entrySet()) {
                        httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            });
        } else {
            String user = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_PLAIN_USERNAME);
            if (user == null || user.equals("")) {
                try {
                    user = UserGroupInformation.getCurrentUser().getShortUserName();
                }
                catch (IOException e) {
                    throw new MetaException("Failed to get client username from UGI");
                }
            }
            final String httpUser = user;
            httpClientBuilder.addInterceptorFirst(new HttpRequestInterceptor(){

                public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                    httpRequest.addHeader("x-actor-username", httpUser);
                    for (Map.Entry entry : additionalHeaders.entrySet()) {
                        httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            });
        }
        return httpClientBuilder;
    }

    private TTransport createBinaryClient(URI store, boolean useSSL) throws TTransportException, MetaException {
        TSocket binaryTransport = null;
        try {
            int clientSocketTimeout = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, TimeUnit.MILLISECONDS);
            int connectionTimeout = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.CLIENT_CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            if (useSSL) {
                String trustStorePath = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH).trim();
                if (trustStorePath.isEmpty()) {
                    throw new IllegalArgumentException((Object)((Object)MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH) + " Not configured for SSL connection");
                }
                String trustStorePassword = MetastoreConf.getPassword(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_PASSWORD);
                String trustStoreType = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_TYPE).trim();
                String trustStoreAlgorithm = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTMANAGERFACTORY_ALGORITHM).trim();
                binaryTransport = SecurityUtils.getSSLSocket(store.getHost(), store.getPort(), clientSocketTimeout, connectionTimeout, trustStorePath, trustStorePassword, trustStoreType, trustStoreAlgorithm);
            } else {
                binaryTransport = new TSocket(new TConfiguration(), store.getHost(), store.getPort(), clientSocketTimeout, connectionTimeout);
            }
            binaryTransport = this.createAuthBinaryTransport(store, (TTransport)binaryTransport);
        }
        catch (Exception e) {
            if (e instanceof TTransportException) {
                throw (TTransportException)e;
            }
            throw new MetaException("Failed to create binary transport client to url: " + store + ". Error: " + e);
        }
        LOG.debug("Created thrift binary client for URI: " + store);
        return this.configureThriftMaxMessageSize(binaryTransport);
    }

    private void open() throws MetaException {
        this.isConnected = false;
        TTransportException tte = null;
        MetaException recentME = null;
        boolean useSSL = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_SSL);
        boolean useCompactProtocol = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_COMPACT_PROTOCOL);
        String transportMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_THRIFT_TRANSPORT_MODE);
        boolean isHttpTransportMode = transportMode.equalsIgnoreCase("http");
        for (int attempt = 0; !this.isConnected && attempt < this.retries; ++attempt) {
            for (URI store : this.metastoreUris) {
                LOG.info("Trying to connect to metastore with URI ({}) in {} transport mode", (Object)store, (Object)transportMode);
                try {
                    try {
                        this.transport = isHttpTransportMode ? this.createHttpClient(store, useSSL) : this.createBinaryClient(store, useSSL);
                    }
                    catch (TTransportException te) {
                        tte = te;
                        throw new MetaException(te.toString());
                    }
                    Object protocol = useCompactProtocol ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
                    this.client = new ThriftHiveMetastore.Client((TProtocol)protocol);
                    try {
                        if (!this.transport.isOpen()) {
                            this.transport.open();
                            int newCount = connCount.incrementAndGet();
                            if (useSSL) {
                                LOG.info("Opened an SSL connection to metastore, current connections: {}", (Object)newCount);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("METASTORE SSL CONNECTION TRACE - open [{}]", (Object)System.identityHashCode(this), (Object)new Exception());
                                }
                            } else {
                                LOG.info("Opened a connection to metastore, URI ({}) current connections: {}", (Object)store, (Object)newCount);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("METASTORE CONNECTION TRACE - open [{}]", (Object)System.identityHashCode(this), (Object)new Exception());
                                }
                            }
                        }
                        this.isConnected = true;
                    }
                    catch (TTransportException e) {
                        tte = e;
                        String errMsg = String.format("Failed to connect to the MetaStore Server URI (%s) in %s transport mode", store, transportMode);
                        LOG.warn(errMsg);
                        LOG.debug(errMsg, (Throwable)e);
                    }
                }
                catch (MetaException e) {
                    recentME = e;
                    String errMsg = "Failed to connect to metastore with URI (" + store + ") transport mode:" + transportMode + " in attempt " + attempt;
                    LOG.error(errMsg, (Throwable)((Object)e));
                }
                if (this.isConnected) break;
            }
            if (this.isConnected || this.retryDelaySeconds <= 0L) continue;
            try {
                LOG.info("Waiting " + this.retryDelaySeconds + " seconds before next connection attempt.");
                Thread.sleep(this.retryDelaySeconds * 1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isConnected) {
            String exceptionString = "Unknown exception";
            if (tte != null) {
                exceptionString = StringUtils.stringifyException(tte);
            } else if (recentME != null) {
                exceptionString = StringUtils.stringifyException(recentME);
            }
            throw new MetaException("Could not connect to meta store using any of the URIs provided. Most recent failure: " + exceptionString);
        }
        this.snapshotActiveConf();
    }

    private TTransport createAuthBinaryTransport(URI store, TTransport underlyingTransport) throws MetaException {
        boolean isHttpTransportMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_THRIFT_TRANSPORT_MODE).equalsIgnoreCase("http");
        if (isHttpTransportMode) {
            throw new IllegalArgumentException("HTTP mode is not supported");
        }
        Objects.requireNonNull(underlyingTransport, "Underlying transport should not be null");
        TTransport transport = underlyingTransport;
        boolean useFramedTransport = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_FRAMED_TRANSPORT);
        boolean useSSL = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_SSL);
        boolean useSasl = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_SASL);
        String clientAuthMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_AUTH_MODE);
        boolean usePasswordAuth = false;
        if (clientAuthMode != null) {
            usePasswordAuth = "PLAIN".equalsIgnoreCase(clientAuthMode);
        }
        if (usePasswordAuth) {
            LOG.debug("HMSC::open(): Creating plain authentication thrift connection.");
            String userName = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_PLAIN_USERNAME);
            if (null == userName || userName.isEmpty()) {
                throw new MetaException("No user specified for plain transport.");
            }
            try {
                String passwd = null;
                char[] pwdCharArray = this.conf.getPassword(userName);
                if (null != pwdCharArray) {
                    passwd = new String(pwdCharArray);
                }
                if (null == passwd) {
                    throw new MetaException("No password found for user " + userName);
                }
                transport = MetaStorePlainSaslHelper.getPlainTransport(userName, passwd, underlyingTransport);
            }
            catch (IOException | TTransportException sasle) {
                LOG.error("Could not create client transport", sasle);
                throw new MetaException(sasle.toString());
            }
        }
        if (useSasl) {
            try {
                HadoopThriftAuthBridge.Client authBridge = HadoopThriftAuthBridge.getBridge().createClient();
                String tokenSig = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.TOKEN_SIGNATURE);
                this.tokenStrForm = SecurityUtils.getTokenStrForm(tokenSig);
                if (this.tokenStrForm != null) {
                    LOG.debug("HMSC::open(): Found delegation token. Creating DIGEST-based thrift connection.");
                    transport = authBridge.createClientTransport(null, store.getHost(), "DIGEST", this.tokenStrForm, underlyingTransport, MetaStoreUtils.getMetaStoreSaslProperties(this.conf, useSSL));
                }
                LOG.debug("HMSC::open(): Could not find delegation token. Creating KERBEROS-based thrift connection.");
                String principalConfig = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.KERBEROS_PRINCIPAL);
                transport = authBridge.createClientTransport(principalConfig, store.getHost(), "KERBEROS", null, underlyingTransport, MetaStoreUtils.getMetaStoreSaslProperties(this.conf, useSSL));
            }
            catch (IOException ioe) {
                LOG.error("Failed to create client transport", (Throwable)ioe);
                throw new MetaException(ioe.toString());
            }
        } else if (useFramedTransport) {
            try {
                transport = new TFramedTransport(transport);
            }
            catch (TTransportException e) {
                LOG.error("Failed to create client transport", (Throwable)e);
                throw new MetaException(e.toString());
            }
        }
        return transport;
    }

    private void snapshotActiveConf() {
        this.currentMetaVars = new HashMap<String, String>(MetastoreConf.metaVars.length);
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            this.currentMetaVars.put(oneVar.getVarname(), MetastoreConf.getAsString(this.conf, oneVar));
        }
    }

    @Override
    public void close() {
        int newCount;
        this.isConnected = false;
        this.currentMetaVars = null;
        try {
            if (null != this.client) {
                this.client.shutdown();
                if (this.transport == null || !this.transport.isOpen()) {
                    newCount = connCount.decrementAndGet();
                    LOG.info("Closed a connection to metastore, current connections: {}", (Object)newCount);
                }
            }
        }
        catch (TException e) {
            LOG.debug("Unable to shutdown metastore client. Will try closing transport directly.", (Throwable)e);
        }
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
            newCount = connCount.decrementAndGet();
            LOG.info("Closed a connection to metastore, current connections: {}", (Object)newCount);
            if (LOG.isTraceEnabled()) {
                LOG.trace("METASTORE CONNECTION TRACE - close [{}]", (Object)System.identityHashCode(this), (Object)new Exception());
            }
        }
    }

    @Override
    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        if (this.localMetaStore) {
            return null;
        }
        return this.client.get_delegation_token(owner, renewerKerberosPrincipalName);
    }
}

