/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.AbstractPreferencePanel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.BasicPrefPanel;
import org.apache.log4j.chainsaw.CheckListCellRenderer;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.ModifiableListModel;

public class LogPanelPreferencePanel
extends AbstractPreferencePanel {
    private final LogPanelPreferenceModel preferenceModel;
    private final ModifiableListModel columnListModel = new ModifiableListModel();
    private static final Logger logger = LogManager.getLogger(LogPanelPreferencePanel.class);
    private ApplicationPreferenceModel appPreferenceModel;

    public LogPanelPreferencePanel(LogPanelPreferenceModel model, ApplicationPreferenceModel appModel) {
        this.preferenceModel = model;
        this.appPreferenceModel = appModel;
        this.initComponents();
        this.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanelPreferencePanel.this.hidePanel();
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanelPreferencePanel.this.hidePanel();
            }
        });
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Preferences Panel Test Bed");
        LogPanelPreferenceModel model = new LogPanelPreferenceModel();
        ApplicationPreferenceModel appModel = new ApplicationPreferenceModel();
        LogPanelPreferencePanel panel = new LogPanelPreferencePanel(model, appModel);
        f.getContentPane().add(panel);
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                logger.warn(evt.toString());
            }
        });
        panel.setOkCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(1);
            }
        });
        f.setSize(640, 480);
        f.setVisible(true);
    }

    @Override
    protected TreeModel createTreeModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Preferences");
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        DefaultMutableTreeNode visuals = new DefaultMutableTreeNode(new VisualsPrefPanel());
        DefaultMutableTreeNode formatting = new DefaultMutableTreeNode(new FormattingPanel());
        DefaultMutableTreeNode columns = new DefaultMutableTreeNode(new ColumnSelectorPanel());
        rootNode.add(visuals);
        rootNode.add(formatting);
        rootNode.add(columns);
        return model;
    }

    private class VisualsPrefPanel
    extends BasicPrefPanel {
        private final JCheckBox detailPanelVisible;
        private final JCheckBox loggerTreePanel;
        private final JCheckBox wrapMessage;
        private final JCheckBox searchResultsVisible;
        private final JCheckBox highlightSearchMatchText;
        private final JCheckBox scrollToBottom;
        private final JCheckBox showMillisDeltaAsGap;
        private final JCheckBox toolTips;
        private final JCheckBox thumbnailBarToolTips;
        private final JEditorPane clearTableExpression;

        private VisualsPrefPanel() {
            super("Visuals");
            this.detailPanelVisible = new JCheckBox("Show Event Detail panel");
            this.loggerTreePanel = new JCheckBox("Show Logger Tree");
            this.wrapMessage = new JCheckBox("Wrap message field (display multi-line rows) ");
            this.searchResultsVisible = new JCheckBox("Display find results in details panel ");
            this.highlightSearchMatchText = new JCheckBox("Highlight find match text ");
            this.scrollToBottom = new JCheckBox("Scroll to bottom (view tracks with new events)");
            this.showMillisDeltaAsGap = new JCheckBox("Display timestamp delta between events as row gap");
            this.toolTips = new JCheckBox("Show Event Detail Tooltips");
            this.thumbnailBarToolTips = new JCheckBox("Show Thumbnail Bar Tooltips");
            this.clearTableExpression = new JEditorPane();
            this.initPanelComponents();
            this.setupListeners();
        }

        private void initPanelComponents() {
            JTextComponentFormatter.applySystemFontAndSize(this.clearTableExpression);
            this.setLayout(new BoxLayout(this, 1));
            this.toolTips.setAlignmentX(0.0f);
            this.thumbnailBarToolTips.setAlignmentX(0.0f);
            this.detailPanelVisible.setAlignmentX(0.0f);
            this.loggerTreePanel.setAlignmentX(0.0f);
            this.scrollToBottom.setAlignmentX(0.0f);
            this.showMillisDeltaAsGap.setAlignmentX(0.0f);
            this.add(this.toolTips);
            this.add(this.thumbnailBarToolTips);
            this.add(this.detailPanelVisible);
            this.add(this.loggerTreePanel);
            this.add(this.scrollToBottom);
            this.add(this.wrapMessage);
            this.add(this.highlightSearchMatchText);
            this.add(this.searchResultsVisible);
            this.add(this.showMillisDeltaAsGap);
            JPanel clearPanel = new JPanel(new BorderLayout());
            clearPanel.setAlignmentX(0.0f);
            clearPanel.add((Component)new JLabel("Clear all events if expression matches"), "North");
            this.clearTableExpression.setText(LogPanelPreferencePanel.this.preferenceModel.getClearTableExpression());
            this.clearTableExpression.setPreferredSize(new Dimension(300, 50));
            JPanel clearTableScrollPanel = new JPanel(new BorderLayout());
            clearTableScrollPanel.add((Component)new JScrollPane(this.clearTableExpression), "North");
            clearPanel.add((Component)clearTableScrollPanel, "Center");
            this.add(clearPanel);
            this.toolTips.setSelected(LogPanelPreferencePanel.this.preferenceModel.isToolTips());
            this.thumbnailBarToolTips.setSelected(LogPanelPreferencePanel.this.preferenceModel.isThumbnailBarToolTips());
            this.detailPanelVisible.setSelected(LogPanelPreferencePanel.this.preferenceModel.isDetailPaneVisible());
            this.searchResultsVisible.setSelected(LogPanelPreferencePanel.this.preferenceModel.isSearchResultsVisible());
            this.loggerTreePanel.setSelected(LogPanelPreferencePanel.this.preferenceModel.isLogTreePanelVisible());
        }

        private void setupListeners() {
            ActionListener wrapMessageListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setWrapMessage(VisualsPrefPanel.this.wrapMessage.isSelected());
                }
            };
            this.wrapMessage.addActionListener(wrapMessageListener);
            ActionListener searchResultsVisibleListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setSearchResultsVisible(VisualsPrefPanel.this.searchResultsVisible.isSelected());
                }
            };
            this.searchResultsVisible.addActionListener(searchResultsVisibleListener);
            ActionListener highlightSearchMatchTextListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setHighlightSearchMatchText(VisualsPrefPanel.this.highlightSearchMatchText.isSelected());
                }
            };
            this.highlightSearchMatchText.addActionListener(highlightSearchMatchTextListener);
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("wrapMessage", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.wrapMessage.setSelected(value);
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("searchResultsVisible", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.searchResultsVisible.setSelected(value);
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("highlightSearchMatchText", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.highlightSearchMatchText.setSelected(value);
                }
            });
            this.toolTips.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setToolTips(VisualsPrefPanel.this.toolTips.isSelected());
                }
            });
            this.thumbnailBarToolTips.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setThumbnailBarToolTips(VisualsPrefPanel.this.thumbnailBarToolTips.isSelected());
                }
            });
            LogPanelPreferencePanel.this.getOkButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setClearTableExpression(VisualsPrefPanel.this.clearTableExpression.getText().trim());
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("toolTips", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.toolTips.setSelected(value);
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("thumbnailBarToolTips", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.thumbnailBarToolTips.setSelected(value);
                }
            });
            this.detailPanelVisible.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setDetailPaneVisible(VisualsPrefPanel.this.detailPanelVisible.isSelected());
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("detailPaneVisible", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.detailPanelVisible.setSelected(value);
                }
            });
            this.scrollToBottom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setScrollToBottom(VisualsPrefPanel.this.scrollToBottom.isSelected());
                }
            });
            this.showMillisDeltaAsGap.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setShowMillisDeltaAsGap(VisualsPrefPanel.this.showMillisDeltaAsGap.isSelected());
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("showMillisDeltaAsGap", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.showMillisDeltaAsGap.setSelected(value);
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("scrollToBottom", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.scrollToBottom.setSelected(value);
                }
            });
            this.loggerTreePanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setLogTreePanelVisible(VisualsPrefPanel.this.loggerTreePanel.isSelected());
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    VisualsPrefPanel.this.loggerTreePanel.setSelected(value);
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("columns", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    List cols = (List)evt.getNewValue();
                    for (TableColumn col : cols) {
                        Enumeration enumeration = LogPanelPreferencePanel.this.columnListModel.elements();
                        boolean found = false;
                        while (enumeration.hasMoreElements()) {
                            TableColumn thisCol = (TableColumn)enumeration.nextElement();
                            if (!thisCol.getHeaderValue().equals(col.getHeaderValue())) continue;
                            found = true;
                        }
                        if (found) continue;
                        LogPanelPreferencePanel.this.columnListModel.addElement(col);
                        LogPanelPreferencePanel.this.columnListModel.fireContentsChanged();
                    }
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("visibleColumns", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LogPanelPreferencePanel.this.columnListModel.fireContentsChanged();
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("clearTableExpression", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    VisualsPrefPanel.this.clearTableExpression.setText(((LogPanelPreferenceModel)evt.getSource()).getClearTableExpression());
                }
            });
        }
    }

    private class FormattingPanel
    extends BasicPrefPanel {
        private JTextField customFormatText;
        private JTextField loggerPrecision;
        private JRadioButton rdCustom;
        private final JRadioButton rdISO;
        private final JTextField timeZone;
        private final JRadioButton rdLevelIcons;
        private final JRadioButton rdLevelText;
        private JRadioButton rdLast;

        private FormattingPanel() {
            super("Formatting");
            this.customFormatText = new JTextField("", 10);
            this.loggerPrecision = new JTextField(10);
            this.rdCustom = new JRadioButton("Custom Format ");
            this.rdISO = new JRadioButton("<html><b>Fast</b> ISO 8601 format (yyyy-MM-dd HH:mm:ss) </html>");
            this.timeZone = new JTextField(10);
            this.rdLevelIcons = new JRadioButton("Icons ");
            this.rdLevelText = new JRadioButton("Text ");
            this.initComponents();
            this.setupListeners();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel dateFormatPanel = new JPanel();
            dateFormatPanel.setLayout(new BoxLayout(dateFormatPanel, 1));
            dateFormatPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Timestamp"));
            ButtonGroup bgDateFormat = new ButtonGroup();
            this.rdISO.setSelected(LogPanelPreferencePanel.this.preferenceModel.isUseISO8601Format());
            this.rdISO.setHorizontalTextPosition(4);
            this.rdISO.setAlignmentX(0.0f);
            bgDateFormat.add(this.rdISO);
            dateFormatPanel.add(this.rdISO);
            for (final String format : LogPanelPreferenceModel.DATE_FORMATS) {
                final JRadioButton rdFormat = new JRadioButton(format);
                rdFormat.setHorizontalTextPosition(4);
                rdFormat.setAlignmentX(0.0f);
                rdFormat.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LogPanelPreferencePanel.this.preferenceModel.setDateFormatPattern(format);
                        FormattingPanel.this.customFormatText.setEnabled(FormattingPanel.this.rdCustom.isSelected());
                        FormattingPanel.this.rdLast = rdFormat;
                    }
                });
                LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("dateFormatPattern", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        rdFormat.setSelected(LogPanelPreferencePanel.this.preferenceModel.getDateFormatPattern().equals(format));
                        FormattingPanel.this.rdLast = rdFormat;
                    }
                });
                dateFormatPanel.add(rdFormat);
                bgDateFormat.add(rdFormat);
            }
            this.customFormatText.setPreferredSize(new Dimension(100, 20));
            this.customFormatText.setMaximumSize(this.customFormatText.getPreferredSize());
            this.customFormatText.setMinimumSize(this.customFormatText.getPreferredSize());
            this.customFormatText.setEnabled(false);
            bgDateFormat.add(this.rdCustom);
            this.rdCustom.setSelected(LogPanelPreferencePanel.this.preferenceModel.isCustomDateFormat());
            if (LogPanelPreferencePanel.this.preferenceModel.isCustomDateFormat()) {
                this.customFormatText.setText(LogPanelPreferencePanel.this.preferenceModel.getDateFormatPattern());
                this.customFormatText.setEnabled(true);
            }
            JPanel customPanel = new JPanel();
            customPanel.setLayout(new BoxLayout(customPanel, 0));
            customPanel.add(this.rdCustom);
            customPanel.add(this.customFormatText);
            customPanel.setAlignmentX(0.0f);
            dateFormatPanel.add(customPanel);
            dateFormatPanel.add(Box.createVerticalStrut(5));
            JLabel dateFormatLabel = new JLabel("Time zone of events (or blank for local time zone");
            dateFormatPanel.add(dateFormatLabel);
            this.timeZone.setMaximumSize(this.timeZone.getPreferredSize());
            dateFormatPanel.add(Box.createVerticalStrut(5));
            dateFormatPanel.add(this.timeZone);
            this.add(dateFormatPanel);
            JPanel levelFormatPanel = new JPanel();
            levelFormatPanel.setLayout(new BoxLayout(levelFormatPanel, 1));
            levelFormatPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Level"));
            levelFormatPanel.setAlignmentX(0.0f);
            ButtonGroup bgLevel = new ButtonGroup();
            bgLevel.add(this.rdLevelIcons);
            bgLevel.add(this.rdLevelText);
            this.rdLevelIcons.setSelected(LogPanelPreferencePanel.this.preferenceModel.isLevelIcons());
            levelFormatPanel.add(this.rdLevelIcons);
            levelFormatPanel.add(this.rdLevelText);
            this.add(levelFormatPanel);
            JPanel loggerFormatPanel = new JPanel();
            loggerFormatPanel.setLayout(new BoxLayout(loggerFormatPanel, 1));
            loggerFormatPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Logger"));
            loggerFormatPanel.setAlignmentX(0.0f);
            loggerFormatPanel.add(Box.createVerticalStrut(3));
            JLabel precisionLabel = new JLabel("Number of package levels to hide (or blank to display full logger)");
            loggerFormatPanel.add(precisionLabel);
            loggerFormatPanel.add(Box.createVerticalStrut(5));
            this.loggerPrecision.setMaximumSize(this.loggerPrecision.getPreferredSize());
            loggerFormatPanel.add(this.loggerPrecision);
            this.add(loggerFormatPanel);
        }

        private void reset() {
            if (LogPanelPreferencePanel.this.preferenceModel.isCustomDateFormat()) {
                this.customFormatText.setText(LogPanelPreferencePanel.this.preferenceModel.getDateFormatPattern());
            } else {
                if (this.rdLast != null) {
                    this.rdLast.setSelected(true);
                }
                this.customFormatText.setEnabled(false);
            }
            this.loggerPrecision.setText(LogPanelPreferencePanel.this.preferenceModel.getLoggerPrecision());
            this.timeZone.setText(LogPanelPreferencePanel.this.preferenceModel.getTimeZone());
        }

        private void commit() {
            if (this.rdCustom.isSelected()) {
                LogPanelPreferencePanel.this.preferenceModel.setDateFormatPattern(this.customFormatText.getText());
            }
            LogPanelPreferencePanel.this.preferenceModel.setLoggerPrecision(this.loggerPrecision.getText());
            LogPanelPreferencePanel.this.preferenceModel.setTimeZone(this.timeZone.getText());
        }

        private void setupListeners() {
            LogPanelPreferencePanel.this.getOkButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FormattingPanel.this.commit();
                }
            });
            LogPanelPreferencePanel.this.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FormattingPanel.this.reset();
                }
            });
            this.rdCustom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FormattingPanel.this.customFormatText.setEnabled(FormattingPanel.this.rdCustom.isSelected());
                    FormattingPanel.this.customFormatText.grabFocus();
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("dateFormatPattern", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (LogPanelPreferencePanel.this.preferenceModel.isCustomDateFormat() && !FormattingPanel.this.customFormatText.getText().equals(evt.getNewValue().toString())) {
                        FormattingPanel.this.customFormatText.setText(LogPanelPreferencePanel.this.preferenceModel.getDateFormatPattern());
                        FormattingPanel.this.rdCustom.setSelected(true);
                        FormattingPanel.this.customFormatText.setEnabled(true);
                    } else {
                        FormattingPanel.this.rdCustom.setSelected(false);
                    }
                }
            });
            this.rdISO.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setDateFormatPattern("ISO8601");
                    FormattingPanel.this.customFormatText.setEnabled(FormattingPanel.this.rdCustom.isSelected());
                    FormattingPanel.this.rdLast = FormattingPanel.this.rdISO;
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("dateFormatPattern", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FormattingPanel.this.rdISO.setSelected(LogPanelPreferencePanel.this.preferenceModel.isUseISO8601Format());
                    FormattingPanel.this.rdLast = FormattingPanel.this.rdISO;
                }
            });
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("dateFormatTimeZone", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FormattingPanel.this.timeZone.setText(LogPanelPreferencePanel.this.preferenceModel.getTimeZone());
                }
            });
            ActionListener levelIconListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanelPreferencePanel.this.preferenceModel.setLevelIcons(FormattingPanel.this.rdLevelIcons.isSelected());
                }
            };
            this.rdLevelIcons.addActionListener(levelIconListener);
            this.rdLevelText.addActionListener(levelIconListener);
            LogPanelPreferencePanel.this.preferenceModel.addPropertyChangeListener("levelIcons", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    FormattingPanel.this.rdLevelIcons.setSelected(value);
                    FormattingPanel.this.rdLevelText.setSelected(!value);
                }
            });
        }
    }

    public class ColumnSelectorPanel
    extends BasicPrefPanel {
        ColumnSelectorPanel() {
            super("Columns");
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 1));
            Box columnBox = new Box(1);
            final JList columnList = new JList();
            columnList.setVisibleRowCount(17);
            for (TableColumn col : LogPanelPreferencePanel.this.preferenceModel.getColumns()) {
                Enumeration enumeration = LogPanelPreferencePanel.this.columnListModel.elements();
                boolean found = false;
                while (enumeration.hasMoreElements()) {
                    TableColumn thisCol = (TableColumn)enumeration.nextElement();
                    if (!thisCol.getHeaderValue().equals(col.getHeaderValue())) continue;
                    found = true;
                }
                if (found) continue;
                LogPanelPreferencePanel.this.columnListModel.addElement(col);
            }
            columnList.setModel(LogPanelPreferencePanel.this.columnListModel);
            CheckListCellRenderer cellRenderer = new CheckListCellRenderer(){

                @Override
                protected boolean isSelected(Object value) {
                    return LogPanelPreferencePanel.this.preferenceModel.isColumnVisible((TableColumn)value);
                }
            };
            columnList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int i = columnList.locationToIndex(e.getPoint());
                    if (i >= 0) {
                        Object column = LogPanelPreferencePanel.this.columnListModel.get(i);
                        LogPanelPreferencePanel.this.preferenceModel.toggleColumn((TableColumn)column);
                    }
                }
            });
            JButton setAsDefaultsButton = new JButton("Use selected columns as default visible columns");
            setAsDefaultsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList<Object> selectedColumns = new ArrayList<Object>();
                    for (int i = 0; i < LogPanelPreferencePanel.this.columnListModel.getSize(); ++i) {
                        if (!LogPanelPreferencePanel.this.preferenceModel.isColumnVisible((TableColumn)LogPanelPreferencePanel.this.columnListModel.get(i))) continue;
                        selectedColumns.add(((TableColumn)LogPanelPreferencePanel.this.columnListModel.get(i)).getHeaderValue());
                    }
                    LogPanelPreferencePanel.this.appPreferenceModel.setDefaultColumnNames(selectedColumns);
                }
            });
            columnList.setCellRenderer(cellRenderer);
            columnBox.add(new JScrollPane(columnList));
            columnBox.add(Box.createVerticalStrut(5));
            columnBox.add(setAsDefaultsButton);
            this.add(columnBox);
            this.add(Box.createVerticalGlue());
        }
    }
}

