/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.util.Properties;
import org.apache.log4j.db.ConnectionSource;
import org.apache.log4j.db.DBReceiverJob;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.scheduler.Scheduler;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public class DBReceiver
extends Receiver
implements Pauseable,
UnrecognizedElementHandler {
    static int DEFAULT_REFRESH_MILLIS = 1000;
    ConnectionSource connectionSource;
    int refreshMillis = DEFAULT_REFRESH_MILLIS;
    DBReceiverJob receiverJob;
    boolean paused = false;

    @Override
    public void activateOptions() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("DBAppender cannot function without a connection source");
        }
        this.receiverJob = new DBReceiverJob(this);
        this.receiverJob.setLoggerRepository(this.repository);
        if (this.repository == null) {
            throw new IllegalStateException("DBAppender cannot function without a reference to its owning repository");
        }
        if (this.repository instanceof LoggerRepositoryEx) {
            Scheduler scheduler = ((LoggerRepositoryEx)this.repository).getScheduler();
            scheduler.schedule(this.receiverJob, System.currentTimeMillis() + 500L, this.refreshMillis);
        }
    }

    public void setRefreshMillis(int refreshMillis) {
        this.refreshMillis = refreshMillis;
    }

    public int getRefreshMillis() {
        return this.refreshMillis;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    @Override
    public void shutdown() {
        this.getLogger().info("removing receiverJob from the Scheduler.");
        if (this.repository instanceof LoggerRepositoryEx) {
            Scheduler scheduler = ((LoggerRepositoryEx)this.repository).getScheduler();
            scheduler.delete(this.receiverJob);
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        if ("connectionSource".equals(element.getNodeName())) {
            Object instance = DOMConfigurator.parseElement(element, props, ConnectionSource.class);
            if (instance instanceof ConnectionSource) {
                ConnectionSource source = (ConnectionSource)instance;
                source.activateOptions();
                this.setConnectionSource(source);
            }
            return true;
        }
        return false;
    }
}

