/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.config;

import com.mchange.v2.c3p0.DriverManagerDataSource;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.annotation.JdbcUrl;
import org.apache.logging.log4j.catalog.jpa.config.DataSourceConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@JdbcUrl(value="postgresql")
public class PostgresqlDataSourceConfig
implements DataSourceConfig {
    private static final Logger LOGGER = LogManager.getLogger(PostgresqlDataSourceConfig.class);
    @Value(value="${jdbcUrl}")
    private String url;
    @Value(value="${dbUserName}")
    private String userName;
    @Value(value="${dbPassword}")
    private String password;

    @Override
    @Bean
    public DataSource dataSource() {
        LOGGER.debug("Creating PostgresQL data source for {}", (Object)this.url);
        DriverManagerDataSource driver = new DriverManagerDataSource();
        driver.setDriverClass("org.postgresql.Driver");
        driver.setJdbcUrl(this.url);
        driver.setUser(this.userName);
        driver.setPassword(this.password);
        return driver;
    }
}

