/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.analysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.TokenAttributeDialogFactory;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.StepByStepAnalyzeResultPanelOperator;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.analysis.Analysis;

public class StepByStepAnalyzeResultPanelProvider
implements StepByStepAnalyzeResultPanelOperator {
    private final ComponentOperatorRegistry operatorRegistry;
    private final TokenAttributeDialogFactory tokenAttrDialogFactory;
    private final JTable charfilterTextsTable = new JTable();
    private final JTable charfilterTextsRowHeader = new JTable();
    private final JTable namedTokensTable = new JTable();
    private final JTable namedTokensRowHeader = new JTable();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private Analysis analysisModel;
    private Analysis.StepByStepResult result;

    public StepByStepAnalyzeResultPanelProvider(TokenAttributeDialogFactory tokenAttrDialogFactory) {
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.operatorRegistry.register(StepByStepAnalyzeResultPanelOperator.class, this);
        this.tokenAttrDialogFactory = tokenAttrDialogFactory;
    }

    public JPanel get() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel hint = new JPanel(new FlowLayout(3));
        hint.setOpaque(false);
        hint.add(new JLabel(MessageUtils.getLocalizedMessage("analysis.hint.show_attributes_step_by_step")));
        panel.add((Component)hint, "First");
        TableUtils.setupTable(this.charfilterTextsRowHeader, 0, new RowHeaderTableModel(), null, new int[0]);
        TableUtils.setupTable(this.charfilterTextsTable, 0, new CharfilterTextTableModel(), null, new int[0]);
        TableUtils.setupTable(this.namedTokensRowHeader, 0, new RowHeaderTableModel(), null, new int[0]);
        TableUtils.setupTable(this.namedTokensTable, 0, new NamedTokensTableModel(), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StepByStepAnalyzeResultPanelProvider.this.listeners.showAttributeValues(e);
            }
        }, new int[0]);
        this.namedTokensTable.setColumnSelectionAllowed(true);
        JSplitPane inner = new JSplitPane(0, this.initResultScroll(this.charfilterTextsTable, this.charfilterTextsRowHeader), this.initResultScroll(this.namedTokensTable, this.namedTokensRowHeader));
        inner.setDividerLocation(60);
        panel.add((Component)inner, "Center");
        return panel;
    }

    private JScrollPane initResultScroll(JTable table, JTable header) {
        JScrollPane scroll = new JScrollPane(table);
        scroll.setRowHeaderView(header);
        scroll.setCorner("UPPER_LEFT_CORNER", header.getTableHeader());
        Dimension tsz = new Dimension(200, header.getPreferredSize().height);
        scroll.getRowHeader().setPreferredSize(tsz);
        return scroll;
    }

    @Override
    public void setAnalysisModel(Analysis analysisModel) {
        this.analysisModel = analysisModel;
    }

    @Override
    public void executeAnalysisStepByStep(String text) {
        this.result = this.analysisModel.analyzeStepByStep(text);
        RowHeaderTableModel charfilterTextsHeaderModel = new RowHeaderTableModel(this.result.getCharfilteredTexts());
        this.charfilterTextsRowHeader.setModel(charfilterTextsHeaderModel);
        this.charfilterTextsRowHeader.setShowGrid(true);
        CharfilterTextTableModel charfilterTextTableModel = new CharfilterTextTableModel(this.result.getCharfilteredTexts());
        this.charfilterTextsTable.setModel(charfilterTextTableModel);
        this.charfilterTextsTable.setShowGrid(true);
        RowHeaderTableModel namedTokensHeaderModel = new RowHeaderTableModel(this.result.getNamedTokens());
        this.namedTokensRowHeader.setModel(namedTokensHeaderModel);
        this.namedTokensRowHeader.setShowGrid(true);
        NamedTokensTableModel tableModel = new NamedTokensTableModel(this.result.getNamedTokens());
        this.namedTokensTable.setModel(tableModel);
        this.namedTokensTable.setShowGrid(true);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            this.namedTokensTable.getColumnModel().getColumn(i).setPreferredWidth(tableModel.getColumnWidth(i));
        }
    }

    @Override
    public void clearTable() {
        TableUtils.setupTable(this.charfilterTextsRowHeader, 0, new RowHeaderTableModel(), null, new int[0]);
        TableUtils.setupTable(this.charfilterTextsTable, 0, new CharfilterTextTableModel(), null, new int[0]);
        TableUtils.setupTable(this.namedTokensRowHeader, 0, new RowHeaderTableModel(), null, new int[0]);
        TableUtils.setupTable(this.namedTokensTable, 0, new NamedTokensTableModel(), null, new int[0]);
    }

    private void showAttributeValues(int rowIndex, int columnIndex) {
        Analysis.NamedTokens namedTokens = this.result.getNamedTokens().get(rowIndex);
        List<Analysis.Token> tokens = namedTokens.getTokens();
        if (rowIndex <= tokens.size()) {
            String term = "\"" + tokens.get(columnIndex).getTerm() + "\" BY " + namedTokens.getName();
            List<Analysis.TokenAttribute> attributes = tokens.get(columnIndex).getAttributes();
            new DialogOpener<TokenAttributeDialogFactory>(this.tokenAttrDialogFactory).open("Token Attributes", 650, 400, factory -> {
                factory.setTerm(term);
                factory.setAttributes(attributes);
            }, new String[0]);
        }
    }

    private static String shortenName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static class NamedTokensTableModel
    extends AbstractTableModel {
        private final Map<Integer, Column> columnMap = new TreeMap<Integer, Column>();
        private final Object[][] data;

        NamedTokensTableModel() {
            this.data = new Object[0][0];
        }

        NamedTokensTableModel(List<Analysis.NamedTokens> namedTokens) {
            Analysis.NamedTokens namedToken;
            int maxColumnSize = 0;
            for (Analysis.NamedTokens tokens : namedTokens) {
                namedToken = tokens;
                if (maxColumnSize >= namedToken.getTokens().size()) continue;
                maxColumnSize = namedToken.getTokens().size();
            }
            int rowSize = namedTokens.size();
            this.data = new Object[rowSize][maxColumnSize];
            for (int i = 0; i < namedTokens.size(); ++i) {
                namedToken = namedTokens.get(i);
                this.data[i][0] = StepByStepAnalyzeResultPanelProvider.shortenName(namedToken.getName());
                for (int j = 0; j < namedToken.getTokens().size(); ++j) {
                    Analysis.Token token = namedToken.getTokens().get(j);
                    this.data[i][j] = token.getTerm();
                    if (maxColumnSize != namedToken.getTokens().size()) continue;
                    this.columnMap.put(j, new Column(String.valueOf(j), j, String.class, 200));
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnMap.size();
        }

        @Override
        public String getColumnName(int colIndex) {
            if (this.columnMap.containsKey(colIndex)) {
                return this.columnMap.get(colIndex).getColName();
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int colIndex) {
            if (this.columnMap.containsKey(colIndex)) {
                return this.columnMap.get(colIndex).getType();
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        public int getColumnWidth(int columnIndex) {
            return this.columnMap.get(columnIndex).getColumnWidth();
        }

        class Column
        implements TableColumnInfo {
            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    private static class CharfilterTextTableModel
    extends TableModelBase<Column> {
        CharfilterTextTableModel() {
        }

        CharfilterTextTableModel(List<Analysis.CharfilteredText> charfilteredTexts) {
            super(charfilteredTexts.size());
            for (int i = 0; i < charfilteredTexts.size(); ++i) {
                this.data[i][Column.TEXT.getIndex()] = charfilteredTexts.get(i).getText();
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            TEXT("Text", 0, String.class, 1000);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    private static class RowHeaderTableModel
    extends TableModelBase<Column> {
        RowHeaderTableModel() {
        }

        RowHeaderTableModel(List<? extends Analysis.NamedObject> namedObjects) {
            super(namedObjects.size());
            for (int i = 0; i < namedObjects.size(); ++i) {
                this.data[i][0] = StepByStepAnalyzeResultPanelProvider.shortenName(namedObjects.get(i).getName());
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            NAME("Name", 0, String.class, 200);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void showAttributeValues(MouseEvent e) {
            if (e.getClickCount() != 2 || e.isConsumed()) {
                return;
            }
            int rowIndex = StepByStepAnalyzeResultPanelProvider.this.namedTokensTable.rowAtPoint(e.getPoint());
            int columnIndex = StepByStepAnalyzeResultPanelProvider.this.namedTokensTable.columnAtPoint(e.getPoint());
            if (rowIndex < 0 || rowIndex >= StepByStepAnalyzeResultPanelProvider.this.namedTokensTable.getRowCount()) {
                return;
            }
            if (columnIndex < 0 || columnIndex >= StepByStepAnalyzeResultPanelProvider.this.namedTokensTable.getColumnCount()) {
                return;
            }
            StepByStepAnalyzeResultPanelProvider.this.showAttributeValues(rowIndex, columnIndex);
        }
    }
}

