/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.ComparisonFunction;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.common.SolrException;

class CompareDateStreamFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final DateValue baseExpr;
    private final DateValueStream compExpr;
    private final ComparisonFunction.CompResultFunction comp;
    private final String name;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public CompareDateStreamFunction(String name, DateValue baseExpr, DateValueStream compExpr, ComparisonFunction.CompResultFunction comp) throws SolrException {
        this.name = name;
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.comp = comp;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        long baseValue = this.baseExpr.getLong();
        if (this.baseExpr.exists()) {
            this.compExpr.streamLongs(compValue -> cons.accept(this.comp.apply(Long.compare(baseValue, compValue))));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

