/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Util;
import org.rrd4j.core.jrrd.RRDatabase;

class RrdToolReader
extends DataImporter {
    private RRDatabase rrd;

    RrdToolReader(String rrdPath) throws IOException {
        this.rrd = new RRDatabase(rrdPath);
    }

    @Override
    public String getVersion() {
        return this.rrd.getHeader().getVersion();
    }

    @Override
    public long getLastUpdateTime() {
        return Util.getTimestamp(this.rrd.getLastUpdate());
    }

    @Override
    public long getStep() {
        return this.rrd.getHeader().getPDPStep();
    }

    @Override
    public int getDsCount() {
        return this.rrd.getHeader().getDSCount();
    }

    @Override
    public int getArcCount() throws IOException {
        return this.rrd.getNumArchives();
    }

    @Override
    public String getDsName(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getName();
    }

    @Override
    public DsType getDsType(int dsIndex) throws IOException {
        return this.rrd.getDataSource(dsIndex).getType().getDsType();
    }

    @Override
    public long getHeartbeat(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMinimumHeartbeat();
    }

    @Override
    public double getMinValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMinimum();
    }

    @Override
    public double getMaxValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMaximum();
    }

    @Override
    public double getLastValue(int dsIndex) {
        String valueStr = this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getLastReading();
        return Util.parseDouble(valueStr);
    }

    @Override
    public double getAccumValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getValue();
    }

    @Override
    public long getNanSeconds(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getUnknownSeconds();
    }

    @Override
    public ConsolFun getConsolFun(int arcIndex) {
        return this.rrd.getArchive(arcIndex).getType().getConsolFun();
    }

    @Override
    public double getXff(int arcIndex) {
        return this.rrd.getArchive(arcIndex).getXff();
    }

    @Override
    public int getSteps(int arcIndex) {
        return this.rrd.getArchive(arcIndex).getPdpCount();
    }

    @Override
    public int getRows(int arcIndex) throws IOException {
        return this.rrd.getArchive(arcIndex).getRowCount();
    }

    @Override
    public double getStateAccumValue(int arcIndex, int dsIndex) throws IOException {
        return this.rrd.getArchive(arcIndex).getCDPStatusBlock(dsIndex).getValue();
    }

    @Override
    public int getStateNanSteps(int arcIndex, int dsIndex) throws IOException {
        return this.rrd.getArchive(arcIndex).getCDPStatusBlock(dsIndex).getUnknownDatapoints();
    }

    @Override
    public double[] getValues(int arcIndex, int dsIndex) throws IOException {
        return this.rrd.getArchive(arcIndex).getValues()[dsIndex];
    }

    @Override
    void release() throws IOException {
        if (this.rrd != null) {
            this.rrd.close();
            this.rrd = null;
        }
    }
}

