/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.function.ObjectShortProcedure;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractObjectShortMap<T>
extends AbstractSet {
    public boolean containsKey(final T key) {
        return !this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final short value) {
        return !this.forEachPair(new ObjectShortProcedure<T>(){

            @Override
            public boolean apply(T iterKey, short iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractObjectShortMap<T> copy() {
        return (AbstractObjectShortMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractObjectShortMap)) {
            return false;
        }
        final AbstractObjectShortMap other = (AbstractObjectShortMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ObjectShortProcedure<T>(){

            @Override
            public boolean apply(T key, short value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ObjectShortProcedure<T>(){

            @Override
            public boolean apply(T key, short value) {
                return AbstractObjectShortMap.this.containsKey(key) && AbstractObjectShortMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new ObjectShortProcedure<T>(){
            int i = 0;

            @Override
            public boolean apply(Object key, short value) {
                buf[this.i++] = key.hashCode() ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ObjectProcedure<T> var1);

    public boolean forEachPair(final ObjectShortProcedure<T> procedure) {
        return this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                return procedure.apply(key, AbstractObjectShortMap.this.get(key));
            }
        });
    }

    public abstract short get(T var1);

    public List<T> keys() {
        ArrayList list = new ArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final List<T> list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(List<T> keyList) {
        this.pairsSortedByValue(keyList, new ShortArrayList(this.size()));
    }

    public void pairsMatching(final ObjectShortProcedure<T> condition, final List<T> keyList, final ShortArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ObjectShortProcedure<T>(){

            @Override
            public boolean apply(T key, short value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(List<T> keyList, ShortArrayList valueList) {
        this.keys(keyList);
        if (keyList.isEmpty()) {
            return;
        }
        T k = keyList.get(0);
        if (!(k instanceof Comparable)) {
            throw new UnsupportedOperationException("The key type for this map does not implement comparable");
        }
        Collections.sort(keyList);
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.get(i)));
        }
    }

    public void pairsSortedByValue(final List<T> keyList, ShortArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final short[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                short t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                Object t2 = keyList.get(a);
                keyList.set(a, keyList.get(b));
                keyList.set(b, t2);
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : 0);
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(T var1, short var2);

    public abstract boolean removeKey(T var1);

    public String toString() {
        List<T> theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            T key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ArrayList theKeys = new ArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            Object key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ShortArrayList values() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(AbstractObjectShortMap.this.get(key));
                return true;
            }
        });
    }

    public short adjustOrPutValue(T key, short newValue, short incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (short)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

