/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.RepositoryTypesRegistry;
import org.elasticsearch.repositories.fs.FsRepositoryModule;
import org.elasticsearch.repositories.uri.URLRepositoryModule;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotsService;

public class RepositoriesModule
extends AbstractModule {
    private Map<String, Class<? extends Module>> repositoryTypes = Maps.newHashMap();

    public RepositoriesModule() {
        this.registerRepository("fs", FsRepositoryModule.class);
        this.registerRepository("url", URLRepositoryModule.class);
    }

    public void registerRepository(String type, Class<? extends Module> module) {
        this.repositoryTypes.put(type, module);
    }

    @Override
    protected void configure() {
        this.bind(RepositoriesService.class).asEagerSingleton();
        this.bind(SnapshotsService.class).asEagerSingleton();
        this.bind(RestoreService.class).asEagerSingleton();
        this.bind(RepositoryTypesRegistry.class).toInstance(new RepositoryTypesRegistry(ImmutableMap.copyOf(this.repositoryTypes)));
    }
}

