/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class CompletionStats
implements Streamable,
ToXContent {
    private long sizeInBytes;
    @Nullable
    private ObjectLongOpenHashMap<String> fields;

    public CompletionStats() {
    }

    public CompletionStats(long size, @Nullable ObjectLongOpenHashMap<String> fields) {
        this.sizeInBytes = size;
        this.fields = fields;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue getSize() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public ObjectLongOpenHashMap<String> getFields() {
        return this.fields;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.fields = new ObjectLongOpenHashMap(size);
            for (int i = 0; i < size; ++i) {
                this.fields.put(in.readString(), in.readVLong());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        if (this.fields == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.fields.size());
            boolean[] states = this.fields.allocated;
            KType[] keys = this.fields.keys;
            long[] values = this.fields.values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                out.writeString((String)keys[i]);
                out.writeVLong(values[i]);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.COMPLETION);
        builder.byteSizeField(Fields.SIZE_IN_BYTES, Fields.SIZE, this.sizeInBytes);
        if (this.fields != null) {
            builder.startObject(Fields.FIELDS);
            boolean[] states = this.fields.allocated;
            KType[] keys = this.fields.keys;
            long[] values = this.fields.values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                builder.startObject((String)keys[i], XContentBuilder.FieldCaseConversion.NONE);
                builder.byteSizeField(Fields.SIZE_IN_BYTES, Fields.SIZE, values[i]);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static CompletionStats readCompletionStats(StreamInput in) throws IOException {
        CompletionStats stats = new CompletionStats();
        stats.readFrom(in);
        return stats;
    }

    public void add(CompletionStats completion) {
        if (completion == null) {
            return;
        }
        this.sizeInBytes += completion.getSizeInBytes();
        if (completion.fields != null) {
            if (this.fields == null) {
                this.fields = new ObjectLongOpenHashMap();
            }
            boolean[] states = completion.fields.allocated;
            KType[] keys = completion.fields.keys;
            long[] values = completion.fields.values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                this.fields.addTo((String)keys[i], values[i]);
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString COMPLETION = new XContentBuilderString("completion");
        static final XContentBuilderString SIZE_IN_BYTES = new XContentBuilderString("size_in_bytes");
        static final XContentBuilderString SIZE = new XContentBuilderString("size");
        static final XContentBuilderString FIELDS = new XContentBuilderString("fields");

        Fields() {
        }
    }
}

