/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.CoverageQuery;
import org.apache.sis.storage.DataSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.util.ArgumentChecks;

public interface GridCoverageResource
extends DataSet {
    public GridGeometry getGridGeometry() throws DataStoreException;

    public List<SampleDimension> getSampleDimensions() throws DataStoreException;

    default public GridCoverageResource subset(Query query) throws UnsupportedQueryException, DataStoreException {
        ArgumentChecks.ensureNonNull("query", query);
        if (query instanceof CoverageQuery) {
            return ((CoverageQuery)query).execute(this);
        }
        throw new UnsupportedQueryException();
    }

    public GridCoverage read(GridGeometry var1, int ... var2) throws DataStoreException;

    default public RasterLoadingStrategy getLoadingStrategy() {
        return RasterLoadingStrategy.AT_READ_TIME;
    }

    default public boolean setLoadingStrategy(RasterLoadingStrategy rasterLoadingStrategy) {
        ArgumentChecks.ensureNonNull("strategy", (Object)rasterLoadingStrategy);
        return rasterLoadingStrategy == this.getLoadingStrategy();
    }
}

