/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.constant.Constable;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeGroup;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner scanner) {
        super(session, scanner);
    }

    Statement compileStatement(int n) {
        Statement statement = this.compilePart(n);
        if (this.token.tokenType == 872) {
            if (statement.getSchemaName() == null) {
                statement.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return statement;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList compileStatements(String string, Result result) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Statement statement = null;
        this.reset(string);
        while (this.token.tokenType != 872) {
            try {
                this.lastError = null;
                statement = this.compilePart(result.getExecuteProperties());
            }
            catch (HsqlException hsqlException) {
                if (this.lastError != null && this.lastError.getLevel() > hsqlException.getLevel()) {
                    throw this.lastError;
                }
                throw hsqlException;
            }
            if (!statement.isExplain && statement.getParametersMetaData().getColumnCount() > 0) {
                throw Error.error(5575);
            }
            statement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            hsqlArrayList.add(statement);
        }
        int n = result.getStatementType();
        if (n != 0) {
            int n2 = statement.getGroup();
            if (n2 == 2003) {
                if (n == 1) {
                    throw Error.error(1253);
                }
            } else if (n == 2) {
                // empty if block
            }
        }
        return hsqlArrayList;
    }

    private Statement compilePart(int n) {
        Statement statement;
        this.compileContext.reset();
        this.setParsePosition(this.getPosition());
        if (this.token.tokenType == 873) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 319: 
            case 816: {
                statement = this.compileCursorSpecification(RangeGroup.emptyArray, n, false);
                break;
            }
            case 308: {
                RangeGroup[] rangeGroupArray = this.session.sessionContext.sessionVariableRangeGroups;
                this.compileContext.setOuterRanges(rangeGroupArray);
                statement = this.compileShortCursorSpecification(n);
                break;
            }
            case 135: {
                statement = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 303: {
                statement = this.compileUpdateStatement(RangeGroup.emptyArray);
                break;
            }
            case 166: {
                statement = this.compileMergeStatement(RangeGroup.emptyArray);
                break;
            }
            case 79: {
                statement = this.compileDeleteStatement(RangeGroup.emptyArray);
                break;
            }
            case 295: {
                statement = this.compileTruncateStatement();
                break;
            }
            case 25: {
                statement = this.compileCallStatement(this.session.sessionContext.sessionVariableRangeGroups, false);
                break;
            }
            case 254: {
                statement = this.compileSet();
                break;
            }
            case 119: {
                statement = this.compileGetStatement(this.session.sessionContext.sessionVariableRangeGroups);
                break;
            }
            case 267: {
                statement = this.compileStartTransaction();
                break;
            }
            case 44: {
                statement = this.compileCommit();
                break;
            }
            case 241: {
                statement = this.compileRollback();
                break;
            }
            case 246: {
                statement = this.compileSavepoint();
                break;
            }
            case 233: {
                statement = this.compileReleaseSavepoint();
                break;
            }
            case 55: {
                statement = this.compileCreate();
                break;
            }
            case 4: {
                statement = this.compileAlter();
                break;
            }
            case 88: {
                statement = this.compileDrop();
                break;
            }
            case 121: 
            case 239: {
                statement = this.compileGrantOrRevoke();
                break;
            }
            case 576: {
                statement = this.compileComment();
                break;
            }
            case 601: {
                statement = this.compileLock();
                break;
            }
            case 47: {
                statement = this.compileConnect();
                break;
            }
            case 84: {
                statement = this.compileDisconnect();
                break;
            }
            case 626: {
                statement = this.compileScript();
                break;
            }
            case 628: {
                statement = this.compileShutdown();
                break;
            }
            case 562: {
                statement = this.compileBackup();
                break;
            }
            case 572: {
                statement = this.compileCheckpoint();
                break;
            }
            case 588: {
                int n2 = this.getPosition();
                statement = this.compileExplainPlan();
                statement.setSQL(this.getLastPart(n2));
                break;
            }
            case 77: {
                statement = this.compileDeclare();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (statement.type) {
            case 11: 
            case 62: 
            case 1062: 
            case 1191: {
                break;
            }
            default: {
                statement.setSQL(this.getLastPart());
            }
        }
        if (this.token.tokenType == 821) {
            this.read();
        } else if (this.token.tokenType == 872) {
            // empty if block
        }
        return statement;
    }

    private Statement compileDeclare() {
        Statement statement = this.compileDeclareLocalTableOrNull();
        if (statement != null) {
            return statement;
        }
        ColumnSchema[] columnSchemaArray = this.readLocalVariableDeclarationOrNull();
        if (columnSchemaArray != null) {
            Object[] objectArray = new Object[]{columnSchemaArray};
            statement = new StatementSession(1075, objectArray);
            return statement;
        }
        statement = this.compileDeclareCursor(RangeGroup.emptyArray, false);
        if (statement == null) {
            throw this.lastError == null ? this.unexpectedToken() : this.lastError;
        }
        return statement;
    }

    private Statement compileScript() {
        String string = null;
        this.read();
        if (this.token.tokenType == 869) {
            string = this.readQuotedString();
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{string};
        return new StatementCommand(1004, objectArray, null, hsqlNameArray);
    }

    private Statement compileConnect() {
        String string = null;
        this.read();
        this.readThis(305);
        this.checkIsSimpleName();
        String string2 = this.token.tokenString;
        this.read();
        if (!this.session.isProcessingLog()) {
            this.readThis(615);
            string = this.readPassword();
        }
        Expression[] expressionArray = new Expression[]{new ExpressionValue(string2, Type.SQL_VARCHAR), new ExpressionValue(string, Type.SQL_VARCHAR)};
        StatementSession statementSession = new StatementSession(76, expressionArray);
        return statementSession;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 598: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{hsqlName};
                return new StatementCommand(1034, objectArray);
            }
            case 236: {
                this.read();
                this.readThis(607);
                this.readThis(245);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1046, objectArray);
            }
            case 278: {
                this.read();
                this.readThis(535);
                int n = 4;
                switch (this.token.tokenType) {
                    case 607: {
                        break;
                    }
                    case 570: {
                        n = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1035, objectArray);
            }
            case 424: {
                int n;
                this.read();
                this.readThis(432);
                switch (this.token.tokenType) {
                    case 480: {
                        this.read();
                        this.readThis(365);
                        n = 2;
                        break;
                    }
                    case 506: {
                        this.read();
                        n = 8;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1053, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object object;
        this.read();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String string = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 294) {
            object = Boolean.TRUE;
        } else if (this.token.tokenType == 106) {
            object = Boolean.FALSE;
        } else {
            this.checkIsValue();
            object = this.token.tokenValue;
        }
        this.read();
        Object[] objectArray = new Object[]{string, object};
        return new StatementCommand(1039, objectArray);
    }

    private Statement compileSet() {
        int n = super.getPosition();
        this.read();
        switch (this.token.tokenType) {
            case 348: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(66, objectArray);
                }
                if (!expression.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new StatementSession(66, expressionArray);
            }
            case 497: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(74, objectArray);
                }
                if (!expression.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new StatementSession(74, expressionArray);
            }
            case 180: {
                Object[] objectArray;
                this.read();
                this.readThis(358);
                HsqlArrayList hsqlArrayList = null;
                if (this.readIfThis(112)) {
                    hsqlArrayList = new HsqlArrayList();
                    while (true) {
                        objectArray = this.readSchemaObjectName(14);
                        hsqlArrayList.add(objectArray);
                        if (this.token.tokenType != 804) break;
                        this.read();
                    }
                }
                objectArray = new Object[]{null, Boolean.FALSE, hsqlArrayList};
                return new StatementSession(136, objectArray);
            }
            case 358: {
                Object[] objectArray;
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null || !expression.getDataType().isCharacterType()) {
                    throw Error.error(4650);
                }
                HsqlArrayList hsqlArrayList = null;
                if (this.readIfThis(112)) {
                    hsqlArrayList = new HsqlArrayList();
                    while (true) {
                        objectArray = this.readSchemaObjectName(14);
                        hsqlArrayList.add(objectArray);
                        if (this.token.tokenType != 804) break;
                        this.read();
                    }
                }
                objectArray = new Object[]{expression, Boolean.TRUE, hsqlArrayList};
                return new StatementSession(136, objectArray);
            }
            case 281: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 490: {
                this.read();
                return this.compileSetRole();
            }
            case 508: {
                this.read();
                return this.compileSessionSettings();
            }
            case 526: {
                this.read();
                Object[] objectArray = this.processTransactionCharacteristics();
                if (objectArray[0] == null && objectArray[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(75, objectArray);
            }
            case 560: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1064, objectArray);
            }
            case 620: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(109, objectArray);
            }
            case 594: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1048, objectArray);
            }
            case 605: {
                this.read();
                Integer n2 = this.readIntegerObject();
                Object[] objectArray = new Object[]{n2};
                return new StatementSession(1065, objectArray);
            }
            case 78: {
                this.read();
                this.readThis(278);
                this.readThis(535);
                int n3 = 4;
                switch (this.token.tokenType) {
                    case 607: {
                        break;
                    }
                    case 570: {
                        n3 = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n3)};
                return new StatementCommand(1035, objectArray);
            }
            case 278: {
                return this.compileSetTable();
            }
            case 636: {
                this.read();
                int n4 = 0;
                if (this.token.tokenType == 294) {
                    n4 = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 106) {
                    n4 = 0;
                    this.read();
                } else {
                    n4 = this.readInteger();
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (this.token.tokenType == 608) {
                        this.read();
                    } else {
                        n4 *= 1000;
                    }
                }
                Object[] objectArray = new Object[]{new Integer(n4)};
                return new StatementCommand(1033, objectArray, null, null);
            }
            case 615: {
                boolean bl = false;
                this.read();
                if (this.readIfThis(586)) {
                    bl = true;
                }
                String string = this.readPassword();
                Object[] objectArray = new Object[]{null, string, bl};
                StatementCommand statementCommand = new StatementCommand(1062, objectArray);
                String string2 = User.getSetCurrentPasswordDigestSQL(this.database.granteeManager, string, bl);
                statementCommand.setSQL(string2);
                return statementCommand;
            }
            case 598: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName hsqlName = this.token.tokenType == 78 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{null, hsqlName};
                return new StatementCommand(1061, objectArray);
            }
            case 590: {
                return this.compileSetFilesProperty();
            }
            case 582: {
                return this.compileSetDatabaseProperty();
            }
            case 618: {
                return this.compileSetProperty();
            }
        }
        this.rewind(n);
        return this.compileSetStatement(this.session.sessionContext.sessionVariableRangeGroups, this.session.sessionContext.sessionVariablesRange);
    }

    StatementCommand compileSetTable() {
        this.read();
        Table table = this.readTableName();
        Object[] objectArray = new Object[]{table.getName(), null};
        switch (this.token.tokenType) {
            default: {
                throw this.unexpectedToken();
            }
            case 513: {
                this.read();
                return this.compileTableSource(table);
            }
            case 480: {
                this.read();
                boolean bl = false;
                if (this.token.tokenType == 547) {
                    this.read();
                } else {
                    this.readThis(195);
                    bl = true;
                }
                objectArray[1] = bl;
                return new StatementCommand(1194, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 620: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                objectArray[1] = bl;
                return new StatementCommand(1194, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 597: {
                this.read();
                this.checkIsValue();
                String string = this.token.tokenString;
                this.read();
                objectArray[1] = string;
                return new StatementCommand(1193, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 535: {
                int n;
                this.read();
                if (this.token.tokenType == 570) {
                    n = 5;
                } else if (this.token.tokenType == 607) {
                    n = 4;
                } else {
                    throw this.unexpectedToken();
                }
                this.read();
                objectArray[1] = new Integer(n);
                return new StatementCommand(1197, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 575: {
                this.read();
                this.readThis(194);
                OrderedHashSet orderedHashSet = new OrderedHashSet();
                this.readThis(816);
                this.readSimpleColumnNames(orderedHashSet, table, false);
                this.readThis(802);
                int[] nArray = table.getColumnIndexes(orderedHashSet);
                objectArray[1] = nArray;
                return new StatementCommand(1198, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 179: {
                this.read();
                this.readThis(514);
                objectArray = new Object[]{table.getName()};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
                return new StatementCommand(1199, objectArray, null, hsqlNameArray);
            }
            case 514: 
        }
        this.read();
        Integer n = super.readIntegerObject();
        objectArray = new Object[]{table.getName(), n};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementCommand(1200, objectArray, null, hsqlNameArray);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 561: {
                this.read();
                this.readThis(117);
                Routine routine = this.readCreateDatabaseAuthenticationFunction();
                Object[] objectArray = new Object[]{routine};
                return new StatementCommand(1036, objectArray, null, null);
            }
            case 358: {
                Boolean bl = null;
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.read();
                if (this.readIfThis(180)) {
                    this.readThis(463);
                    bl = Boolean.FALSE;
                } else if (this.readIfThis(463)) {
                    this.readThis(514);
                    bl = Boolean.TRUE;
                }
                if (bl == null) {
                    bl = this.session.isProcessingScript() && this.database.getProperties().isVersion18() ? Boolean.FALSE : Boolean.TRUE;
                }
                Object[] objectArray = new Object[]{string, bl};
                return new StatementCommand(1047, objectArray, null, null);
            }
            case 78: {
                return this.compileSetDefault();
            }
            case 587: {
                this.read();
                this.readThis(703);
                boolean bl = this.readIfThis(261);
                this.readThis(432);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n, bl};
                return new StatementCommand(1016, objectArray, null, null);
            }
            case 592: {
                this.read();
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1037, objectArray, null, null);
            }
            case 615: {
                this.read();
                switch (this.token.tokenType) {
                    case 37: {
                        this.read();
                        this.readThis(117);
                        Routine routine = this.readCreatePasswordCheckFunction();
                        Object[] objectArray = new Object[]{routine};
                        return new StatementCommand(1040, objectArray, null, null);
                    }
                    case 586: {
                        this.read();
                        String string = this.readQuotedString();
                        Object[] objectArray = new Object[]{string};
                        return new StatementCommand(1056, objectArray, null, null);
                    }
                }
                throw this.unexpectedToken();
            }
            case 621: {
                this.read();
                this.readThis(596);
                boolean bl = this.processTrueOrFalse();
                Object[] objectArray = new Object[]{bl};
                return new StatementCommand(1049, objectArray, null, null);
            }
            case 261: {
                this.read();
                int n = 1050;
                Boolean bl = Boolean.TRUE;
                Integer n2 = 0;
                String string = null;
                switch (this.token.tokenType) {
                    case 446: {
                        this.read();
                        string = "sql.enforce_names";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 622: {
                        this.read();
                        this.readThis(446);
                        string = "sql.regular_names";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 222: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_refs";
                        break;
                    }
                    case 512: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_size";
                        break;
                    }
                    case 634: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_types";
                        break;
                    }
                    case 630: {
                        this.read();
                        if (this.readIfThis(79)) {
                            string = "sql.enforce_tdc_delete";
                        } else {
                            this.readThis(303);
                            string = "sql.enforce_tdc_update";
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 287: {
                        this.read();
                        this.readThis(633);
                        this.readThis(634);
                        bl = this.processTrueOrFalseObject();
                        string = "jdbc.translate_tti_types";
                        break;
                    }
                    case 656: {
                        this.read();
                        this.readThis(451);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.concat_nulls";
                        break;
                    }
                    case 451: {
                        this.read();
                        if (this.readIfThis(401)) {
                            string = "sql.nulls_first";
                        } else {
                            this.readThis(198);
                            string = "sql.nulls_order";
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 299: {
                        this.read();
                        this.readThis(451);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.unique_nulls";
                        break;
                    }
                    case 49: {
                        this.read();
                        this.readThis(295);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.convert_trunc";
                        break;
                    }
                    case 16: {
                        this.read();
                        this.readThis(496);
                        n2 = this.readIntegerObject();
                        string = "sql.avg_scale";
                        break;
                    }
                    case 87: {
                        this.read();
                        this.readThis(610);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.double_nan";
                        break;
                    }
                    case 604: {
                        this.read();
                        this.readThis(142);
                        this.readThis(702);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.longvar_is_lob";
                        break;
                    }
                    case 594: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.ignore_case";
                        break;
                    }
                    case 629: {
                        this.read();
                        if (this.token.tokenString.equals("DB2")) {
                            this.read();
                            string = "sql.syntax_db2";
                        } else if (this.token.tokenString.equals("MSS")) {
                            this.read();
                            string = "sql.syntax_mss";
                        } else if (this.token.tokenString.equals("MYS")) {
                            this.read();
                            string = "sql.syntax_mys";
                        } else if (this.token.tokenString.equals("ORA")) {
                            this.read();
                            string = "sql.syntax_ora";
                        } else if (this.token.tokenString.equals("PGS")) {
                            this.read();
                            string = "sql.syntax_pgs";
                        } else {
                            throw this.unexpectedToken();
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] objectArray = new Object[]{string, bl, n2};
                return new StatementCommand(n, objectArray, null, null);
            }
            case 632: {
                this.read();
                this.readThis(278);
                this.readThis(381);
                String string = this.readQuotedString();
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1051, objectArray, null, null);
            }
            case 526: {
                this.read();
                if (this.readIfThis(241)) {
                    this.readThis(194);
                    if (!this.readIfThis(583)) {
                        this.readThis(579);
                    }
                    Boolean bl = this.processTrueOrFalseObject();
                    StatementCommand statementCommand = new StatementCommand(1054, new Object[]{bl}, null, null);
                    return statementCommand;
                }
                this.readThis(580);
                int n = 0;
                switch (this.token.tokenType) {
                    case 711: {
                        this.read();
                        n = 2;
                        break;
                    }
                    case 712: {
                        this.read();
                        n = 1;
                        break;
                    }
                    case 602: {
                        this.read();
                        n = 0;
                    }
                }
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                StatementCommand statementCommand = new StatementCommand(1052, objectArray, null, hsqlNameArray);
                return statementCommand;
            }
            case 299: {
                this.read();
                this.readThis(445);
                this.isUndelimitedSimpleName();
                String string = this.token.tokenString;
                this.read();
                if (string.length() != 16) {
                    throw Error.error(5555);
                }
                if (!Charset.isInSet(string, Charset.unquotedIdentifier) || !Charset.startsWith(string, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1055, objectArray, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int n = 0;
        Boolean bl = null;
        Integer n2 = null;
        Boolean bl2 = null;
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 569: {
                this.read();
                if (this.readIfThis(512)) {
                    n2 = this.readIntegerObject();
                    n = 1013;
                } else {
                    this.readThis(245);
                    n2 = this.readIntegerObject();
                    n = 1012;
                }
                if (!this.readIfThis(180)) break;
                this.readThis(37);
                bl2 = Boolean.TRUE;
                break;
            }
            case 37: {
                this.read();
                n2 = this.readIntegerObject();
                n = 1014;
                hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
                break;
            }
            case 496: {
                this.read();
                n2 = this.readIntegerObject();
                n = 1025;
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 514: {
                this.read();
                if (this.token.tokenType == 294) {
                    bl = Boolean.TRUE;
                    this.read();
                } else if (this.token.tokenType == 106) {
                    bl = Boolean.FALSE;
                    this.read();
                } else {
                    n2 = this.readIntegerObject();
                }
                n = 1031;
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 702: {
                this.read();
                if (this.readIfThis(496)) {
                    n2 = this.readIntegerObject();
                    n = 1017;
                } else {
                    this.readThis(578);
                    n = 1018;
                    bl = this.processTrueOrFalseObject();
                }
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 584: {
                this.read();
                n = 1015;
                n2 = this.readIntegerObject();
                break;
            }
            case 715: {
                this.read();
                if (this.readIfThis(512)) {
                    n2 = this.readIntegerObject();
                } else {
                    bl = this.processTrueOrFalseObject();
                }
                n = 1022;
                break;
            }
            case 562: {
                this.read();
                n = 1011;
                this.readThis(417);
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 703: {
                this.read();
                if (this.readIfThis(512)) {
                    n = 1021;
                    n2 = this.readIntegerObject();
                    break;
                }
                n = 1020;
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 631: {
                this.read();
                this.readThis(472);
                n = 1032;
                n2 = this.readIntegerObject();
                break;
            }
            case 547: {
                this.read();
                this.readThis(585);
                n = 1033;
                int n3 = 0;
                if (this.token.tokenType == 294) {
                    n3 = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 106) {
                    n3 = 0;
                    this.read();
                } else {
                    n3 = this.readInteger();
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (this.token.tokenType == 608) {
                        this.read();
                    } else {
                        n3 *= 1000;
                    }
                }
                n2 = new Integer(n3);
                break;
            }
            case 626: {
                this.read();
                this.readThis(591);
                if (this.token.tokenType == 632) {
                    this.read();
                    n2 = new Integer(0);
                } else {
                    this.readThis(578);
                    n2 = new Integer(3);
                }
                n = 1026;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{bl == null ? (Constable)n2 : (Constable)bl, bl2};
        return new StatementCommand(n, objectArray, null, hsqlNameArray);
    }

    Object[] processTransactionCharacteristics() {
        int n = 0;
        boolean bl = false;
        Object[] objectArray = new Object[2];
        block10: while (true) {
            switch (this.token.tokenType) {
                case 480: {
                    if (objectArray[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 195) {
                        this.read();
                        bl = true;
                    } else {
                        this.readThis(547);
                        bl = false;
                    }
                    objectArray[0] = bl;
                    continue block10;
                }
                case 424: {
                    if (objectArray[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(432);
                    switch (this.token.tokenType) {
                        case 506: {
                            this.read();
                            n = 8;
                            break;
                        }
                        case 480: {
                            this.read();
                            if (this.token.tokenType == 365) {
                                this.read();
                                n = 2;
                                break;
                            }
                            if (this.token.tokenType == 537) {
                                this.read();
                                n = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 482: {
                            this.read();
                            this.readThis(480);
                            n = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    objectArray[1] = new Integer(n);
                    continue block10;
                }
                case 804: {
                    if (objectArray[0] == null && objectArray[1] == null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block10;
                }
            }
            break;
        }
        if (!bl && n == 1) {
            throw this.unexpectedToken("WRITE");
        }
        return objectArray;
    }

    private Statement compileCommit() {
        boolean bl = false;
        this.read();
        this.readIfThis(546);
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 180) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(350);
        }
        String string = bl ? StatementSession.commitAndChainStatement.sql : StatementSession.commitNoChainStatement.sql;
        StatementSession statementSession = new StatementSession(11, new Object[]{bl});
        statementSession.setSQL(string);
        return statementSession;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(526);
        Object[] objectArray = this.processTransactionCharacteristics();
        StatementSession statementSession = new StatementSession(111, objectArray);
        return statementSession;
    }

    private Statement compileLock() {
        Object[] objectArray;
        this.read();
        this.readThis(278);
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        while (true) {
            objectArray = this.readTableName();
            switch (this.token.tokenType) {
                case 480: {
                    this.read();
                    orderedHashSet.add(objectArray.getName());
                    break;
                }
                case 547: {
                    this.read();
                    orderedHashSet2.add(objectArray.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 804) break;
            this.read();
        }
        objectArray = new HsqlNameManager.HsqlName[orderedHashSet2.size()];
        orderedHashSet2.toArray(objectArray);
        orderedHashSet.removeAll(objectArray);
        Object[] objectArray2 = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray2);
        StatementSession statementSession = new StatementSession(1063, (HsqlNameManager.HsqlName[])objectArray2, (HsqlNameManager.HsqlName[])objectArray);
        return statementSession;
    }

    private Statement compileRollback() {
        boolean bl = false;
        String string = null;
        this.read();
        if (this.token.tokenType == 546) {
            this.read();
        }
        if (this.token.tokenType == 285) {
            this.read();
            this.readThis(246);
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            String string2 = this.getLastPart();
            Object[] objectArray = new Object[]{string};
            StatementSession statementSession = new StatementSession(1067, objectArray);
            return statementSession;
        }
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 180) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(350);
        }
        String string3 = bl ? StatementSession.rollbackAndChainStatement.sql : StatementSession.rollbackNoChainStatement.sql;
        StatementSession statementSession = new StatementSession(62, new Object[]{bl});
        statementSession.setSQL(string3);
        return statementSession;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        this.read();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{string};
        return new StatementSession(63, objectArray);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(246);
        String string = this.token.tokenString;
        this.read();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{string};
        return new StatementSession(57, objectArray);
    }

    private Statement compileSessionSettings() {
        switch (this.token.tokenType) {
            case 354: {
                this.read();
                this.readThis(10);
                this.readThis(526);
                Object[] objectArray = this.processTransactionCharacteristics();
                return new StatementSession(109, objectArray);
            }
            case 15: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    throw Error.error(5584);
                }
                expression.resolveTypes(this.session, null);
                if (expression.isUnresolvedParam()) {
                    expression.dataType = Type.SQL_VARCHAR;
                }
                if (expression.dataType == null || !expression.dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                Expression[] expressionArray = new Expression[]{expression, null};
                return new StatementSession(76, expressionArray);
            }
            case 236: {
                this.read();
                this.readThis(607);
                this.readThis(245);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementSession(1066, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression expression;
        if (this.token.tokenType == 181) {
            this.read();
            expression = new ExpressionValue(null, Type.SQL_VARCHAR);
        } else {
            expression = this.XreadValueSpecificationOrNull();
            if (expression == null) {
                throw Error.error(4100);
            }
            if (!expression.getDataType().isCharacterType()) {
                throw Error.error(2200);
            }
            if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                throw Error.error(2200);
            }
        }
        String string = this.getLastPart();
        return new StatementSession(73, new Expression[]{expression});
    }

    private Statement compileSetTimeZone() {
        Object object;
        Expression expression;
        this.readThis(549);
        if (this.token.tokenType == 157) {
            this.read();
            expression = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
        } else {
            expression = this.XreadIntervalValueExpression();
            object = expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
            ExpressionColumn.checkColumnsResolved((HsqlList)object);
            expression.resolveTypes(this.session, null);
            if (expression.dataType == null) {
                throw Error.error(5563);
            }
            if (expression.dataType.typeCode != 111) {
                throw Error.error(5563);
            }
        }
        object = this.getLastPart();
        return new StatementSession(71, new Expression[]{expression});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int n = 2;
        this.read();
        switch (this.token.tokenType) {
            case 595: {
                n = 1;
                this.read();
                break;
            }
            case 577: {
                n = 3;
                this.read();
                break;
            }
            case 626: {
                n = 4;
                this.read();
            }
        }
        if (this.token.tokenType == 821) {
            this.read();
        }
        if (this.token.tokenType != 872) {
            throw this.unexpectedToken();
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{new Integer(n)};
        StatementCommand statementCommand = new StatementCommand(1003, objectArray, null, null);
        return statementCommand;
    }

    private Statement compileBackup() {
        Boolean bl = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        Boolean bl4 = null;
        this.read();
        this.readThis(582);
        this.readThis(285);
        String string = this.readQuotedString();
        string = string.trim();
        if (string.length() == 0) {
            throw this.unexpectedToken(string);
        }
        block7: while (true) {
            switch (this.token.tokenType) {
                case 566: {
                    if (bl != null) {
                        throw this.unexpectedToken();
                    }
                    bl = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 626: {
                    if (bl2 != null) {
                        throw this.unexpectedToken();
                    }
                    bl2 = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 578: {
                    if (bl3 != null) {
                        throw this.unexpectedToken();
                    }
                    bl3 = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 183: {
                    this.read();
                    if (this.token.tokenType == 578) {
                        if (bl3 != null) {
                            throw this.unexpectedToken();
                        }
                        bl3 = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    if (this.token.tokenType == 566) {
                        if (bl != null) {
                            throw this.unexpectedToken();
                        }
                        bl = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    throw this.unexpectedToken();
                }
                case 10: {
                    if (bl4 != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(590);
                    bl4 = Boolean.TRUE;
                    continue block7;
                }
            }
            break;
        }
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        if (bl3 == null) {
            bl3 = Boolean.TRUE;
        }
        if (bl4 == null) {
            bl4 = Boolean.FALSE;
        }
        if (bl2.booleanValue() && !bl.booleanValue()) {
            throw this.unexpectedToken("NOT");
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = bl != false ? this.database.schemaManager.getCatalogAndBaseTableNames() : HsqlNameManager.HsqlName.emptyArray;
        Object[] objectArray = new Object[]{string, bl, bl2, bl3, bl4};
        StatementCommand statementCommand = new StatementCommand(1001, objectArray, null, hsqlNameArray);
        return statementCommand;
    }

    private Statement compileCheckpoint() {
        boolean bl = false;
        this.read();
        if (this.token.tokenType == 584) {
            bl = true;
            this.read();
        } else if (this.token.tokenType == 821) {
            this.read();
        }
        if (this.token.tokenType != 872) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{bl};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray, null, hsqlNameArray);
        return statementCommand;
    }

    public static Statement getAutoCheckpointStatement(Database database) {
        HsqlNameManager.HsqlName[] hsqlNameArray = database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{Boolean.FALSE};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray, null, hsqlNameArray);
        statementCommand.setCompileTimestamp(database.txManager.getGlobalChangeTimestamp());
        statementCommand.setSQL("CHECKPOINT");
        return statementCommand;
    }

    private Statement compileDisconnect() {
        this.read();
        String string = "DISCONNECT";
        StatementSession statementSession = new StatementSession(22, (Object[])null);
        return statementSession;
    }

    private Statement compileExplainPlan() {
        this.read();
        this.readThis(616);
        this.readThis(112);
        Statement statement = this.compilePart(0);
        statement.setDescribe();
        return new StatementCommand(1191, new Object[]{statement});
    }

    private StatementCommand compileTableSource(Table table) {
        String string;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = new Object[5];
        objectArray[0] = table.getName();
        if (!table.isText()) {
            object = Error.error(321);
        }
        if (this.token.tokenType == 194) {
            this.read();
            object = this.getLastPart();
            objectArray[1] = Boolean.TRUE;
            return new StatementCommand(1195, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
        }
        if (this.token.tokenType == 614) {
            this.read();
            object = this.getLastPart();
            objectArray[1] = Boolean.FALSE;
            return new StatementCommand(1195, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
        }
        if (this.token.tokenType == 593) {
            this.read();
            bl = true;
        }
        if (this.token.tokenType == 871) {
            string = this.token.tokenString;
            this.read();
        } else {
            string = this.readQuotedString();
        }
        if (!bl && this.token.tokenType == 389) {
            bl2 = true;
            this.read();
        }
        object = this.getLastPart();
        objectArray[2] = string;
        objectArray[3] = bl2;
        objectArray[4] = bl;
        int n = bl ? 1196 : 1195;
        return new StatementCommand(n, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
    }
}

