/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import org.apache.sis.internal.util.AutoMessageFormat;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.Loader;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public class IndexedResourceBundle
extends ResourceBundle
implements Localized {
    public static final String LOCALE_KEY = "locale";
    private static final int MAX_STRING_LENGTH = 200;
    static final int FIRST = 1;
    private URL resources;
    private volatile String[] values;
    private transient AutoMessageFormat format;
    private transient short lastKey;

    protected IndexedResourceBundle(URL uRL) {
        this.resources = uRL;
    }

    protected static <T extends IndexedResourceBundle> T getBundle(Class<T> clazz, Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (T)((IndexedResourceBundle)clazz.cast(IndexedResourceBundle.getBundle(clazz.getName(), locale, clazz.getClassLoader(), Loader.INSTANCE)));
    }

    protected KeyConstants getKeyConstants() {
        Class clazz = KeyConstants.class;
        for (Class<?> clazz2 : this.getClass().getClasses()) {
            if (!"Keys".equals(clazz2.getSimpleName())) continue;
            clazz = clazz2;
            break;
        }
        return new KeyConstants(clazz);
    }

    @Override
    public final Enumeration<String> getKeys() {
        return new KeyEnum(this.getKeyConstants().getKeyNames());
    }

    public final void list(Appendable appendable) throws IOException {
        String string;
        int n;
        String[] stringArray;
        int n2 = 0;
        String[] object = stringArray = this.getKeyConstants().getKeyNames();
        int stringArray2 = object.length;
        for (n = 0; n < stringArray2; ++n) {
            string = object[n];
            if (string == null) continue;
            n2 = Math.max(n2, string.length());
        }
        String string2 = System.lineSeparator();
        String[] stringArray3 = this.ensureLoaded(null);
        for (n = 0; n < stringArray3.length; ++n) {
            int n3;
            string = stringArray[n];
            String string3 = stringArray3[n];
            if (string == null || string3 == null) continue;
            int n4 = string3.indexOf(13);
            if (n4 < 0) {
                n4 = string3.length();
            }
            if ((n3 = string3.indexOf(10)) < 0) {
                n3 = string3.length();
            }
            String string4 = String.valueOf(n);
            appendable.append(CharSequences.spaces(5 - string4.length())).append(string4).append(": ").append(string).append(CharSequences.spaces(n2 - string.length())).append(" = ").append(string3, 0, Math.min(n4, n3)).append(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] ensureLoaded(String string) throws MissingResourceException {
        String[] stringArray = this.values;
        if (stringArray == null) {
            IndexedResourceBundle indexedResourceBundle = this;
            synchronized (indexedResourceBundle) {
                stringArray = this.values;
                if (stringArray == null) {
                    if (this.resources == null) {
                        stringArray = ((IndexedResourceBundle)this.parent).ensureLoaded(string);
                    } else {
                        Object object;
                        Locale locale = this.getLocale();
                        String string2 = this.getClass().getCanonicalName();
                        String string3 = string != null ? "getObject" : "getKeys";
                        LogRecord logRecord = new LogRecord(Level.FINER, "Loaded resources for {0} from bundle \"{1}\".");
                        logRecord.setLoggerName("org.apache.sis.util.resources");
                        try {
                            object = new DataInputStream(new BufferedInputStream(this.resources.openStream()));
                            try {
                                stringArray = new String[((DataInputStream)object).readInt()];
                                for (int i = 0; i < stringArray.length; ++i) {
                                    stringArray[i] = ((DataInputStream)object).readUTF();
                                    if (!stringArray[i].isEmpty()) continue;
                                    stringArray[i] = null;
                                }
                            }
                            finally {
                                ((FilterInputStream)object).close();
                            }
                        }
                        catch (IOException iOException) {
                            logRecord.setLevel(Level.WARNING);
                            logRecord.setMessage(iOException.getMessage());
                            logRecord.setThrown(iOException);
                            Logging.log(IndexedResourceBundle.class, string3, logRecord);
                            throw (MissingResourceException)new MissingResourceException(Exceptions.getLocalizedMessage(iOException, locale), string2, string).initCause(iOException);
                        }
                        object = null;
                        if (locale != null) {
                            object = locale.getDisplayName(Locale.US);
                        }
                        if (object == null || ((String)object).isEmpty()) {
                            object = "<root>";
                        }
                        logRecord.setParameters(new String[]{object, string2});
                        Logging.log(IndexedResourceBundle.class, string3, logRecord);
                        this.resources = null;
                    }
                    this.values = stringArray;
                }
            }
        }
        return stringArray;
    }

    @Override
    protected final Object handleGetObject(String string) {
        int n;
        String[] stringArray = this.ensureLoaded(string);
        try {
            n = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                n = this.getKeyConstants().getKeyValue(string);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                reflectiveOperationException.addSuppressed(numberFormatException);
                Logging.recoverableException(Logging.getLogger("org.apache.sis.util.resources"), this.getClass(), "handleGetObject", reflectiveOperationException);
                return null;
            }
        }
        return --n >= 0 && n < stringArray.length ? stringArray[n] : null;
    }

    final Object[] toArray(Object object) {
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2;
            Object object3 = objectArray[i];
            if (object3 == null) continue;
            Object object4 = object3;
            if (object3 instanceof CharSequence) {
                object2 = (CharSequence)object3;
                if (object2 instanceof InternationalString) {
                    object2 = ((InternationalString)object3).toString(this.getLocale());
                }
                object4 = CharSequences.shortSentence((CharSequence)object2, 200);
            } else if (object3 instanceof Throwable) {
                object2 = Exceptions.getLocalizedMessage((Throwable)object3, this.getLocale());
                if (object2 == null) {
                    object2 = Classes.getShortClassName(object3);
                }
                object4 = object2;
            } else if (object3 instanceof Class) {
                object4 = Classes.getShortName(IndexedResourceBundle.getPublicType((Class)object3));
            } else if (object3 instanceof CodeList) {
                object4 = MetadataServices.getInstance().getCodeTitle((CodeList)object3, this.getLocale());
            } else if (object3 instanceof Range) {
                object2 = (Range)object3;
                object4 = new RangeFormat(this.getLocale(), ((Range)object2).getElementType()).format(object2);
            } else if (object3 instanceof Unit) {
                object2 = object3.toString();
                if (((String)object2).isEmpty()) {
                    object2 = "1";
                }
                object4 = object2;
            } else if (object3.getClass().isArray()) {
                object4 = Utilities.deepToString(object3);
            }
            if (object4 == object3) continue;
            if (objectArray == object) {
                objectArray = (Object[])objectArray.clone();
            }
            objectArray[i] = object4;
        }
        return objectArray;
    }

    private static Class<?> getPublicType(Class<?> clazz) {
        while (!Modifier.isPublic(clazz.getModifiers())) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!Modifier.isPublic(clazz2.getModifiers()) || clazz2.getName().startsWith("java")) continue;
                return clazz2;
            }
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public final void appendLabel(short s, Appendable appendable) throws IOException {
        appendable.append(this.getString(s));
        String string = this.colon();
        if (string != null) {
            appendable.append(string);
        } else {
            appendable.append(':');
        }
    }

    public final String getLabel(short s) {
        String string = this.getString(s);
        String string2 = this.colon();
        return string2 != null ? string + string2 : string + ':';
    }

    private String colon() {
        return Locale.FRENCH.getLanguage().equals(this.getLocale().getLanguage()) ? "\u00a0:" : null;
    }

    public final String getString(short s) throws MissingResourceException {
        return this.getString(String.valueOf(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(short s, Object object) throws MissingResourceException {
        String string = this.getString(s);
        Object[] objectArray = this.toArray(object);
        IndexedResourceBundle indexedResourceBundle = this;
        synchronized (indexedResourceBundle) {
            if (this.format == null) {
                this.format = new AutoMessageFormat(string, this.getLocale());
                this.lastKey = s;
            } else if (s != this.lastKey) {
                this.format.applyPattern(string);
                this.lastKey = s;
            }
            try {
                this.format.configure(objectArray);
                return this.format.format(objectArray);
            }
            catch (RuntimeException runtimeException) {
                return "[Unformattable message: " + runtimeException + ']';
            }
        }
    }

    public final String getString(short s, Object object, Object object2) throws MissingResourceException {
        return this.getString(s, new Object[]{object, object2});
    }

    public final String getString(short s, Object object, Object object2, Object object3) throws MissingResourceException {
        return this.getString(s, new Object[]{object, object2, object3});
    }

    public final String getString(short s, Object object, Object object2, Object object3, Object object4) throws MissingResourceException {
        return this.getString(s, new Object[]{object, object2, object3, object4});
    }

    public final String getString(short s, Object object, Object object2, Object object3, Object object4, Object object5) throws MissingResourceException {
        return this.getString(s, new Object[]{object, object2, object3, object4, object5});
    }

    public final LogRecord getLogRecord(Level level, short s) {
        LogRecord logRecord = new LogRecord(level, this.getKeyConstants().getKeyName(s));
        logRecord.setResourceBundleName(this.getClass().getName());
        logRecord.setResourceBundle(this);
        return logRecord;
    }

    public final LogRecord getLogRecord(Level level, short s, Object object) {
        LogRecord logRecord = this.getLogRecord(level, s);
        logRecord.setParameters(this.toArray(object));
        return logRecord;
    }

    public final LogRecord getLogRecord(Level level, short s, Object object, Object object2) {
        return this.getLogRecord(level, s, new Object[]{object, object2});
    }

    public final LogRecord getLogRecord(Level level, short s, Object object, Object object2, Object object3) {
        return this.getLogRecord(level, s, new Object[]{object, object2, object3});
    }

    public final LogRecord getLogRecord(Level level, short s, Object object, Object object2, Object object3, Object object4) {
        return this.getLogRecord(level, s, new Object[]{object, object2, object3, object4});
    }

    protected static Locale getLocale(Map<?, ?> map) {
        Object obj;
        if (map != null && (obj = map.get(LOCALE_KEY)) instanceof Locale) {
            return (Locale)obj;
        }
        return null;
    }

    public synchronized String toString() {
        return Strings.bracket(this.getClass(), (Object)this.getLocale());
    }

    private static final class KeyEnum
    implements Enumeration<String> {
        private final String[] keys;
        private int next;

        KeyEnum(String[] stringArray) {
            this.keys = stringArray;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.next < this.keys.length) {
                if (this.keys[this.next] != null) {
                    return true;
                }
                ++this.next;
            }
            return false;
        }

        @Override
        public String nextElement() {
            while (this.next < this.keys.length) {
                String string;
                if ((string = this.keys[this.next++]) == null) continue;
                return string;
            }
            throw new NoSuchElementException();
        }
    }
}

