/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.DataSource;
import org.apache.sis.internal.geoapi.evolution.Interim;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.sql.CacheKey;
import org.apache.sis.metadata.sql.CachedStatement;
import org.apache.sis.metadata.sql.Dispatcher;
import org.apache.sis.metadata.sql.Installer;
import org.apache.sis.metadata.sql.LookupInfo;
import org.apache.sis.metadata.sql.MetadataFallback;
import org.apache.sis.metadata.sql.MetadataProxy;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.metadata.sql.TableHierarchy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.annotation.UML;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public class MetadataSource
implements AutoCloseable {
    static final KeyNamePolicy NAME_POLICY = KeyNamePolicy.UML_IDENTIFIER;
    static final String ID_COLUMN = "ID";
    private static final long TIMEOUT = 2000000000L;
    private static final int EXTRA_DELAY = 500000000;
    protected final MetadataStandard standard;
    private final DataSource dataSource;
    private Connection connection;
    private final CachedStatement[] statements;
    final String catalog;
    private String schema;
    private boolean quoteSchema;
    private transient SQLBuilder helper;
    private final Map<String, Set<String>> tableColumns;
    private final ClassLoader classloader;
    private final WeakValueHashMap<CacheKey, Object> pool;
    private final ThreadLocal<LookupInfo> lastUsed;
    private volatile Filter logFilter;
    private boolean isCloseScheduled;
    private static MetadataSource instance;

    public static synchronized MetadataSource getProvided() {
        MetadataSource metadataSource = instance;
        if (metadataSource == null) {
            LogRecord logRecord = null;
            boolean bl = false;
            try {
                DataSource dataSource = Initializer.getDataSource();
                if (dataSource != null) {
                    metadataSource = new MetadataSource(MetadataStandard.ISO_19115, dataSource, "metadata", null);
                    metadataSource.install();
                } else {
                    logRecord = (LogRecord)Initializer.unspecified(null, true);
                    metadataSource = MetadataFallback.INSTANCE;
                }
            }
            catch (Exception exception) {
                metadataSource = MetadataFallback.INSTANCE;
                logRecord = Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)6, "jdbc/SpatialMetadata");
                logRecord.setThrown(Exceptions.unwrap(exception));
                if (exception instanceof ClassNotFoundException) {
                    logRecord.setLevel(Level.CONFIG);
                }
                for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
                    if (!(throwable instanceof SQLTransientException)) continue;
                    bl = true;
                    break;
                }
            }
            if (logRecord != null) {
                logRecord.setLoggerName("org.apache.sis.system");
                Logging.log(MetadataSource.class, "getProvided", logRecord);
            }
            if (!bl) {
                instance = metadataSource;
            }
        }
        return metadataSource;
    }

    public MetadataSource(MetadataStandard metadataStandard, DataSource dataSource, String string, Map<String, ?> map) {
        ArgumentChecks.ensureNonNull("standard", metadataStandard);
        ArgumentChecks.ensureNonNull("dataSource", dataSource);
        this.catalog = Containers.property(map, "catalog", String.class);
        ClassLoader classLoader = Containers.property(map, "classloader", ClassLoader.class);
        Integer n = Containers.property(map, "maxStatements", Integer.class);
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (n == null) {
            n = 10;
        } else {
            ArgumentChecks.ensureBetween("maxStatements", 2, 255, n);
        }
        this.standard = metadataStandard;
        this.dataSource = dataSource;
        this.schema = string;
        this.quoteSchema = true;
        this.classloader = classLoader;
        this.statements = new CachedStatement[n - 1];
        this.tableColumns = new HashMap<String, Set<String>>();
        this.pool = new WeakValueHashMap(CacheKey.class);
        this.lastUsed = ThreadLocal.withInitial(LookupInfo::new);
    }

    public MetadataSource(MetadataSource metadataSource) {
        ArgumentChecks.ensureNonNull("source", metadataSource);
        this.standard = metadataSource.standard;
        this.dataSource = metadataSource.dataSource;
        this.catalog = metadataSource.catalog;
        this.schema = metadataSource.schema;
        this.quoteSchema = metadataSource.quoteSchema;
        this.statements = new CachedStatement[metadataSource.statements.length];
        this.tableColumns = new HashMap<String, Set<String>>();
        this.classloader = metadataSource.classloader;
        this.pool = metadataSource.pool;
        this.lastUsed = metadataSource.lastUsed;
        this.logFilter = metadataSource.logFilter;
    }

    MetadataSource() {
        this.standard = MetadataStandard.ISO_19115;
        this.dataSource = null;
        this.catalog = null;
        this.statements = null;
        this.tableColumns = null;
        this.classloader = this.getClass().getClassLoader();
        this.pool = null;
        this.lastUsed = null;
    }

    final synchronized void install() throws IOException, SQLException {
        Connection connection = this.connection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData.storesUpperCaseIdentifiers()) {
            this.schema = this.schema.toUpperCase(Locale.US);
        } else if (databaseMetaData.storesLowerCaseIdentifiers()) {
            this.schema = this.schema.toLowerCase(Locale.US);
        }
        this.quoteSchema = false;
        try (AutoCloseable autoCloseable = databaseMetaData.getTables(this.catalog, this.schema, "Citation", null);){
            if (autoCloseable.next()) {
                return;
            }
        }
        autoCloseable = new Installer(connection);
        ((Installer)autoCloseable).run();
    }

    final Connection connection() throws SQLException {
        assert (Thread.holdsLock(this));
        Connection connection = this.connection;
        if (connection == null) {
            this.connection = connection = this.dataSource.getConnection();
            Logging.log(MetadataSource.class, "lookup", Initializer.connected(connection.getMetaData()));
            this.scheduleCloseTask();
        }
        return connection;
    }

    final String schema() {
        return this.schema;
    }

    final SQLBuilder helper() throws SQLException {
        assert (Thread.holdsLock(this));
        if (this.helper == null) {
            this.helper = new SQLBuilder(this.connection().getMetaData(), this.quoteSchema);
        }
        return this.helper;
    }

    private CachedStatement take(Class<?> clazz, int n) {
        CachedStatement cachedStatement;
        assert (Thread.holdsLock(this));
        if (n >= 0 && n < this.statements.length && (cachedStatement = this.statements[n]) != null && cachedStatement.type == clazz) {
            this.statements[n] = null;
            return cachedStatement;
        }
        for (int i = 0; i < this.statements.length; ++i) {
            CachedStatement cachedStatement2 = this.statements[i];
            if (cachedStatement2 == null || cachedStatement2.type != clazz) continue;
            this.statements[i] = null;
            return cachedStatement2;
        }
        return null;
    }

    private int recycle(CachedStatement cachedStatement, int n) throws SQLException {
        assert (Thread.holdsLock(this));
        long l = System.nanoTime();
        if (n < 0 || n >= this.statements.length || this.statements[n] != null) {
            n = 0;
            while (this.statements[n] != null) {
                if (++n < this.statements.length) continue;
                long l2 = Long.MIN_VALUE;
                for (int i = 0; i < this.statements.length; ++i) {
                    long l3 = l - this.statements[i].expireTime;
                    if (l3 < l2) continue;
                    l2 = l3;
                    n = i;
                }
                this.statements[n].close();
                break;
            }
        }
        this.statements[n] = cachedStatement;
        cachedStatement.expireTime = l + 2000000000L;
        this.scheduleCloseTask();
        return n;
    }

    static String getTableName(Class<?> clazz) {
        UML uML = clazz.getAnnotation(UML.class);
        if (uML == null) {
            return clazz.getSimpleName();
        }
        String string = uML.identifier();
        int n = string.lastIndexOf(46) + 1;
        if (string.length() > n + 3 && string.charAt(n + 2) == '_' && Character.isUpperCase(string.charAt(1))) {
            n += 3;
        }
        return string.substring(n);
    }

    final String proxy(Object object) {
        return object instanceof MetadataProxy ? ((MetadataProxy)object).identifier(this) : null;
    }

    final Map<String, Object> asValueMap(Object object) throws ClassCastException {
        return this.standard.asValueMap(object, null, NAME_POLICY, ValueExistencePolicy.ALL);
    }

    static Object extractFromCollection(Object object) {
        while (object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            if (object != (object = iterator.next())) continue;
            break;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String search(Object object) throws MetadataStoreException {
        ArgumentChecks.ensureNonNull("metadata", object);
        String string = this.proxy(object);
        if (string == null) {
            if (object instanceof CodeList) {
                string = Types.getCodeName((CodeList)object);
            } else if (object instanceof Enum) {
                string = ((Enum)object).name();
            } else {
                Map<String, Object> map;
                String string2;
                try {
                    string2 = MetadataSource.getTableName(this.standard.getInterface(object.getClass()));
                    map = this.asValueMap(object);
                }
                catch (ClassCastException classCastException) {
                    throw new MetadataStoreException(Errors.format((short)42, "metadata", object.getClass()));
                }
                MetadataSource metadataSource = this;
                synchronized (metadataSource) {
                    try (Statement statement = this.connection().createStatement();){
                        string = this.search(string2, null, map, statement, this.helper());
                    }
                    catch (SQLException sQLException) {
                        throw new MetadataStoreException(sQLException.getLocalizedMessage(), Exceptions.unwrap(sQLException));
                    }
                    catch (FactoryException factoryException) {
                        throw new MetadataStoreException(factoryException.getLocalizedMessage(), (Exception)((Object)factoryException));
                    }
                }
            }
        }
        return string;
    }

    final String search(String string, Set<String> set, Map<String, Object> map, Statement statement, SQLBuilder sQLBuilder) throws SQLException, FactoryException {
        Object object;
        assert (Thread.holdsLock(this));
        sQLBuilder.clear();
        for (Map.Entry<String, Object> object22 : map.entrySet()) {
            object = MetadataSource.extractFromCollection(object22.getValue());
            String string2 = object22.getKey();
            if (set == null) {
                set = this.getExistingColumns(string);
            }
            if (!set.contains(string2)) {
                if (object == null) continue;
                return null;
            }
            if (object != null) {
                if (object instanceof CodeList) {
                    object = Types.getCodeName((CodeList)object);
                } else if (object instanceof Enum) {
                    object = ((Enum)object).name();
                } else {
                    String string3 = this.proxy(object);
                    if (string3 != null) {
                        object = string3;
                    } else {
                        Class<?> clazz = object.getClass();
                        if (this.standard.isMetadata(clazz)) {
                            string3 = this.search(MetadataSource.getTableName(this.standard.getInterface(clazz)), null, this.asValueMap(object), statement, new SQLBuilder(sQLBuilder));
                            if (string3 == null) {
                                return null;
                            }
                            object = string3;
                        }
                    }
                }
            }
            if (sQLBuilder.isEmpty()) {
                sQLBuilder.append("SELECT ").appendIdentifier(ID_COLUMN).append(" FROM ").appendIdentifier(this.schema, string).append(" WHERE ");
            } else {
                sQLBuilder.append(" AND ");
            }
            sQLBuilder.appendIdentifier(string2).appendEqualsValue(MetadataSource.toStorableValue(object));
        }
        Object object3 = null;
        try (ResultSet resultSet = statement.executeQuery(sQLBuilder.toString());){
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (object == null) continue;
                if (object3 == null) {
                    object3 = object;
                    continue;
                }
                if (((String)object3).equals(object)) continue;
                this.warning(MetadataSource.class, "search", Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)24, object));
                break;
            }
        }
        return object3;
    }

    static Object toStorableValue(Object object) throws FactoryException {
        if (object instanceof IdentifiedObject) {
            object = ReferencingServices.getInstance().getPreferredIdentifier((IdentifiedObject)object);
        }
        return object;
    }

    final Set<String> getExistingColumns(String string) throws SQLException {
        assert (Thread.holdsLock(this));
        Set<String> set = this.tableColumns.get(string);
        if (set == null) {
            set = new HashSet<String>();
            DatabaseMetaData databaseMetaData = this.connection().getMetaData();
            try (ResultSet resultSet = databaseMetaData.getColumns(this.catalog, this.schema, string, null);){
                while (resultSet.next()) {
                    if (set.add(resultSet.getString("COLUMN_NAME"))) continue;
                    throw new SQLNonTransientException(string);
                }
            }
            this.tableColumns.put(string, set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lookup(Class<T> clazz, String string) throws MetadataStoreException {
        Object object;
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonEmpty("identifier", string);
        if (CodeList.class.isAssignableFrom(clazz)) {
            object = MetadataSource.getCodeList(clazz, string);
        } else {
            CacheKey cacheKey = new CacheKey(clazz, string);
            Object object2 = this.pool;
            synchronized (object2) {
                object = this.pool.get(cacheKey);
                if (object == null && clazz.isInterface()) {
                    object = Proxy.newProxyInstance(this.classloader, new Class[]{clazz, MetadataProxy.class}, (InvocationHandler)new Dispatcher(string, this));
                    this.pool.put(cacheKey, object);
                }
            }
            if (object == null) {
                object2 = null;
                Class<?> clazz2 = TableHierarchy.subType(clazz, string);
                Dispatcher dispatcher = new Dispatcher(string, this);
                try {
                    object = clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
                    LookupInfo lookupInfo = this.getLookupInfo(clazz2);
                    Map<String, Object> map = this.asValueMap(object);
                    Map<String, String> map2 = this.standard.asNameMap(clazz2, NAME_POLICY, KeyNamePolicy.METHOD_NAME);
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        object2 = clazz2.getMethod(map2.get(entry.getKey()), new Class[0]);
                        lookupInfo.setMetadataType(clazz2);
                        Object object3 = this.readColumn(lookupInfo, (Method)object2, dispatcher);
                        if (object3 == null) continue;
                        entry.setValue(object3);
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new MetadataStoreException(Errors.format((short)160, clazz2), reflectiveOperationException);
                }
                catch (SQLException sQLException) {
                    throw new MetadataStoreException(dispatcher.error((Method)object2), sQLException);
                }
            }
        }
        return clazz.cast(object);
    }

    final LookupInfo getLookupInfo(Class<?> clazz) {
        LookupInfo lookupInfo = this.lastUsed.get();
        lookupInfo.setMetadataType(clazz);
        return lookupInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object readColumn(LookupInfo lookupInfo, Method method, Dispatcher dispatcher) throws SQLException, MetadataStoreException {
        Class<?> clazz = TableHierarchy.subType(lookupInfo.getMetadataType(), dispatcher.identifier);
        Class<?> clazz2 = Interim.getReturnType(method);
        boolean bl = Collection.class.isAssignableFrom(clazz2);
        Class<?> clazz3 = bl ? Classes.boundOfParameterizedProperty(method) : clazz2;
        boolean bl2 = this.standard.isMetadata(clazz3);
        String string = MetadataSource.getTableName(clazz);
        String string2 = lookupInfo.asNameMap(this.standard).get(method.getName());
        Object[] objectArray = this;
        synchronized (this) {
            Object object;
            boolean bl3;
            Object object2;
            if (!this.getExistingColumns(string).contains(string2)) {
                object2 = null;
                bl3 = false;
            } else {
                CachedStatement cachedStatement = this.take(clazz, Byte.toUnsignedInt(dispatcher.preferredIndex));
                if (cachedStatement == null) {
                    object = this.helper();
                    String string3 = ((SQLBuilder)object).clear().append("SELECT * FROM ").appendIdentifier(this.schema, string).append(" WHERE ").appendIdentifier(ID_COLUMN).append("=?").toString();
                    cachedStatement = new CachedStatement(clazz, this.connection().prepareStatement(string3), this.logFilter);
                }
                if (bl3 = (object2 = cachedStatement.getValue(dispatcher.identifier, string2)) instanceof java.sql.Array) {
                    object = (java.sql.Array)object2;
                    object2 = object.getArray();
                    object.free();
                }
                dispatcher.preferredIndex = (byte)super.recycle(cachedStatement, Byte.toUnsignedInt(dispatcher.preferredIndex));
            }
            // ** MonitorExit[var13_11] (shouldn't be in output)
            if (bl3 && (bl || !clazz3.isPrimitive())) {
                objectArray = new Object[Array.getLength(object2)];
                for (int i = 0; i < objectArray.length; ++i) {
                    object = Array.get(object2, i);
                    if (object != null) {
                        if (bl2) {
                            object = this.lookup(clazz3, object.toString());
                        } else {
                            try {
                                object = lookupInfo.convert(clazz3, object);
                            }
                            catch (UnconvertibleObjectException unconvertibleObjectException) {
                                throw new MetadataStoreException(Errors.format((short)59, Strings.toIndexed(string2, i), clazz3, object.getClass()), unconvertibleObjectException);
                            }
                        }
                    }
                    objectArray[i] = object;
                }
                object2 = objectArray;
                if (bl) {
                    object2 = MetadataSource.specialize(UnmodifiableArrayList.wrap(objectArray), clazz2, clazz3);
                }
            }
            if (object2 != null) {
                if (bl2) {
                    object2 = this.lookup(clazz3, object2.toString());
                } else {
                    try {
                        object2 = lookupInfo.convert(clazz3, object2);
                    }
                    catch (UnconvertibleObjectException unconvertibleObjectException) {
                        throw new MetadataStoreException(Errors.format((short)59, string2, clazz3, object2.getClass()), unconvertibleObjectException);
                    }
                }
                if (bl) {
                    if (Set.class.isAssignableFrom(clazz2)) {
                        return Collections.singleton(object2);
                    }
                    return Collections.singletonList(object2);
                }
            }
            return object2;
        }
    }

    static CodeList<?> getCodeList(Class<?> clazz, String string) {
        return Types.forCodeName(clazz.asSubclass(CodeList.class), string, true);
    }

    private static <E> Collection<?> specialize(Collection<?> collection, Class<?> clazz, Class<E> clazz2) {
        AbstractSet abstractSet;
        if (!clazz.isAssignableFrom(Set.class)) {
            return collection;
        }
        if (CodeList.class.isAssignableFrom(clazz2)) {
            abstractSet = new CodeListSet<E>(clazz2);
        } else if (Enum.class.isAssignableFrom(clazz2)) {
            abstractSet = EnumSet.noneOf(clazz2);
        } else {
            if (Set.class.isAssignableFrom(clazz)) {
                if (SortedSet.class.isAssignableFrom(clazz)) {
                    collection = collection.isEmpty() ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet(collection));
                } else {
                    switch (collection.size()) {
                        case 0: {
                            collection = Collections.emptySet();
                            break;
                        }
                        case 1: {
                            collection = Collections.singleton(CollectionsExt.first(collection));
                            break;
                        }
                        default: {
                            collection = Collections.unmodifiableSet(new LinkedHashSet(collection));
                        }
                    }
                }
            }
            return collection;
        }
        for (Object obj : collection) {
            abstractSet.add(clazz2.cast(obj));
        }
        return Collections.unmodifiableSet(abstractSet);
    }

    final void warning(Class<? extends MetadataSource> clazz, String string, LogRecord logRecord) {
        logRecord.setSourceClassName(clazz.getCanonicalName());
        logRecord.setSourceMethodName(string);
        logRecord.setLoggerName("org.apache.sis.sql");
        Filter filter = this.logFilter;
        if (filter == null || filter.isLoggable(logRecord)) {
            CachedStatement.LOGGER.log(logRecord);
        }
    }

    public Filter setWarningFilter(Filter filter) {
        Filter filter2 = this.logFilter;
        this.logFilter = filter;
        return filter2;
    }

    public Filter getWarningFilter() {
        return this.logFilter;
    }

    private void scheduleCloseTask() {
        if (!this.isCloseScheduled) {
            DelayedExecutor.schedule(new CloseTask(System.nanoTime() + 2500000000L));
            this.isCloseScheduled = true;
        }
    }

    final synchronized void closeExpired() {
        this.isCloseScheduled = false;
        long l = 0L;
        long l2 = System.nanoTime();
        for (int i = 0; i < this.statements.length; ++i) {
            CachedStatement cachedStatement = this.statements[i];
            if (cachedStatement == null) continue;
            long l3 = cachedStatement.expireTime - l2;
            if (l3 > l) {
                l = l3;
                continue;
            }
            this.statements[i] = null;
            this.closeQuietly(cachedStatement);
        }
        if (l > 0L) {
            DelayedExecutor.schedule(new CloseTask(l2 + l + 500000000L));
            this.isCloseScheduled = true;
        } else {
            Connection connection = this.connection;
            this.connection = null;
            this.helper = null;
            this.closeQuietly(connection);
        }
    }

    private void closeQuietly(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                LogRecord logRecord = new LogRecord(Level.WARNING, exception.toString());
                logRecord.setThrown(exception);
                this.warning(MetadataSource.class, "closeExpired", logRecord);
            }
        }
    }

    @Override
    public synchronized void close() throws MetadataStoreException {
        try {
            for (int i = 0; i < this.statements.length; ++i) {
                CachedStatement cachedStatement = this.statements[i];
                if (cachedStatement == null) continue;
                cachedStatement.close();
                this.statements[i] = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            this.helper = null;
        }
        catch (SQLException sQLException) {
            throw new MetadataStoreException(sQLException.getLocalizedMessage(), Exceptions.unwrap(sQLException));
        }
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.metadata"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void classpathChanged() {
                Class<MetadataSource> clazz = MetadataSource.class;
                synchronized (MetadataSource.class) {
                    instance = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    private final class CloseTask
    extends DelayedRunnable {
        CloseTask(long l) {
            super(l);
        }

        @Override
        public void run() {
            MetadataSource.this.closeExpired();
        }
    }
}

