/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dft.dma.pom.enforcer;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class HasDevelopers
implements EnforcerRule {
    MavenProject project = null;
    Log log = null;
    List developers = null;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.log = helper.getLog();
        try {
            this.project = this.setup(helper, this.log);
            String packaging = this.project.getPackaging();
            if (packaging != null && packaging.toLowerCase().equals("pom")) {
                return;
            }
            this.projectHasALead(this.project);
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private boolean projectHasALead(MavenProject project) throws EnforcerRuleException {
        this.developers = project.getDevelopers();
        if (this.developers.isEmpty()) {
            throw new EnforcerRuleException(project.getGroupId() + ":" + project.getArtifactId() + " pom.xml is missing Developers");
        }
        Iterator iterator = this.developers.iterator();
        while (iterator.hasNext()) {
            Developer developer = (Developer)iterator.next();
            List roles = developer.getRoles();
            Iterator iterator2 = roles.iterator();
            while (iterator2.hasNext()) {
                String role = (String)iterator2.next();
                if (role == null || !role.toLowerCase().equals("lead")) continue;
                return true;
            }
        }
        throw new EnforcerRuleException(project.getGroupId() + ":" + project.getArtifactId() + "'s pom.xml is missing a Developer with the lead role.");
    }

    private MavenProject setup(EnforcerRuleHelper helper, Log log) throws ExpressionEvaluationException, ComponentLookupException {
        MavenProject project = (MavenProject)helper.evaluate("${project}");
        MavenSession session = (MavenSession)helper.evaluate("${session}");
        String target = (String)helper.evaluate("${project.build.directory}");
        String artifactId = (String)helper.evaluate("${project.artifactId}");
        ArtifactResolver resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
        RuntimeInformation rti = (RuntimeInformation)helper.getComponent(RuntimeInformation.class);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Project Packaging: " + project.getPackaging()));
            log.debug((CharSequence)("Project SCM Content: " + project.getScm()));
            log.debug((CharSequence)("Retrieved Target Folder: " + target));
            log.debug((CharSequence)("Retrieved ArtifactId: " + artifactId));
            log.debug((CharSequence)("Retrieved Project: " + project));
            log.debug((CharSequence)("Retrieved RuntimeInfo: " + rti));
            log.debug((CharSequence)("Retrieved Session: " + session));
            log.debug((CharSequence)("Retrieved Resolver: " + resolver));
        }
        return project;
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }
}

