/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.exception.ComponentImplementationNotFoundException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultComponentRepository
extends AbstractLogEnabled
implements ComponentRepository {
    private static String COMPONENTS = "components";
    private static String COMPONENT = "component";
    private PlexusConfiguration configuration;
    private ComponentRealmDescriptorMaps componentRealmDescriptorMaps = new ComponentRealmDescriptorMaps();
    private CompositionResolver compositionResolver;
    private ClassRealm classRealm;

    protected PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean hasComponent(String role, ClassRealm realm) {
        return this.componentRealmDescriptorMaps.containsKey(role, "default", realm);
    }

    public boolean hasComponent(String role, String roleHint, ClassRealm realm) {
        return this.componentRealmDescriptorMaps.containsKey(role, roleHint, realm);
    }

    public Map getComponentDescriptorMap(String role, ClassRealm realm) {
        return this.componentRealmDescriptorMaps.getComponentDescriptorMap(role, realm);
    }

    public ComponentDescriptor getComponentDescriptor(String role, ClassRealm realm) {
        return this.getComponentDescriptor(role, "default", realm);
    }

    public ComponentDescriptor getComponentDescriptor(String role, String roleHint, ClassRealm realm) {
        return this.componentRealmDescriptorMaps.getComponentDescriptor(role, roleHint, realm);
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public void configure(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    public void initialize() throws ComponentRepositoryException {
        this.initializeComponentDescriptors();
    }

    public void initializeComponentDescriptors() throws ComponentRepositoryException {
        this.initializeComponentDescriptorsFromUserConfiguration();
    }

    private void initializeComponentDescriptorsFromUserConfiguration() throws ComponentRepositoryException {
        PlexusConfiguration[] componentConfigurations = this.configuration.getChild(COMPONENTS).getChildren(COMPONENT);
        for (int i = 0; i < componentConfigurations.length; ++i) {
            this.addComponentDescriptor(componentConfigurations[i]);
        }
    }

    public void addComponentDescriptor(PlexusConfiguration configuration) throws ComponentRepositoryException {
        ComponentDescriptor componentDescriptor = null;
        try {
            componentDescriptor = PlexusTools.buildComponentDescriptor(configuration);
        }
        catch (PlexusConfigurationException e) {
            throw new ComponentRepositoryException("Cannot unmarshall component descriptor:", e);
        }
        componentDescriptor.setRealmId(this.classRealm.getId());
        this.addComponentDescriptor(componentDescriptor);
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        try {
            this.validateComponentDescriptor(componentDescriptor);
        }
        catch (ComponentImplementationNotFoundException e) {
            throw new ComponentRepositoryException("Component descriptor validation failed: ", e);
        }
        Map maps = this.componentRealmDescriptorMaps.getRealmMap(componentDescriptor.getRealmId());
        String role = componentDescriptor.getRole();
        String roleHint = componentDescriptor.getRoleHint();
        HashMap<String, ComponentDescriptor> map = (HashMap<String, ComponentDescriptor>)maps.get(role);
        if (map == null) {
            map = new HashMap<String, ComponentDescriptor>();
            maps.put(role, map);
        }
        map.put(roleHint, componentDescriptor);
        try {
            this.compositionResolver.addComponentDescriptor(componentDescriptor);
        }
        catch (CompositionException e) {
            throw new ComponentRepositoryException(e.getMessage(), e);
        }
    }

    public void validateComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentImplementationNotFoundException {
        if (componentDescriptor.getRealmId() == null) {
            componentDescriptor.setRealmId(this.classRealm.getId());
        }
    }

    public List getComponentDependencies(ComponentDescriptor componentDescriptor) {
        return this.compositionResolver.getRequirements(componentDescriptor.getRole(), componentDescriptor.getRoleHint());
    }

    private class ComponentRealmDescriptorMaps {
        private Map realmMaps = new HashMap();

        private ComponentRealmDescriptorMaps() {
        }

        public boolean containsKey(String role, String roleHint, ClassRealm realm) {
            if (realm == null) {
                return false;
            }
            Map maps = (Map)this.realmMaps.get(realm.getId());
            if (maps != null && maps.containsKey(role)) {
                Map hints = (Map)maps.get(role);
                return hints.containsKey(roleHint);
            }
            return this.containsKey(role, roleHint, realm.getParentRealm());
        }

        public Map getComponentDescriptorMap(String role, ClassRealm realm) {
            if (realm == null) {
                return null;
            }
            Map maps = (Map)this.realmMaps.get(realm.getId());
            if (maps != null && maps.containsKey(role)) {
                return (Map)maps.get(role);
            }
            return this.getComponentDescriptorMap(role, realm.getParentRealm());
        }

        public ComponentDescriptor getComponentDescriptor(String role, String roleHint, ClassRealm realm) {
            ComponentDescriptor desc;
            Map roleMap;
            if (realm == null) {
                return null;
            }
            if (roleHint == null) {
                roleHint = "default";
            }
            if ((roleMap = this.getComponentDescriptorMap(role, realm)) != null && (desc = (ComponentDescriptor)roleMap.get(roleHint)) != null) {
                return desc;
            }
            return this.getComponentDescriptor(role, roleHint, realm.getParentRealm());
        }

        public Map getRealmMap(String realmId) {
            HashMap rm = (HashMap)this.realmMaps.get(realmId);
            if (rm == null) {
                rm = new HashMap();
                this.realmMaps.put(realmId, rm);
            }
            return rm;
        }
    }
}

