/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.myfaces.commons.converter.ConverterBase;
import org.apache.myfaces.commons.util.MessageUtils;
import org.apache.myfaces.commons.util.TagUtils;

public abstract class AbstractTypedNumberConverter
extends ConverterBase {
    public static final String CONVERTER_ID = "org.apache.myfaces.custom.convertNumber.TypedNumberConverter";
    public static final String STRING_ID = "javax.faces.converter.STRING";
    public static final String CURRENCY_ID = "javax.faces.converter.NumberConverter.CURRENCY";
    public static final String NUMBER_ID = "javax.faces.converter.NumberConverter.NUMBER";
    public static final String PATTERN_ID = "javax.faces.converter.NumberConverter.PATTERN";
    public static final String PERCENT_ID = "javax.faces.converter.NumberConverter.PERCENT";
    private static final boolean JAVA_VERSION_14 = AbstractTypedNumberConverter.checkJavaVersion14();
    private boolean _transient;

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        ValueExpression valueBinding;
        Object convertedValue = this._getAsObject(facesContext, uiComponent, value);
        if (convertedValue == null) {
            return null;
        }
        Class destType = this.getDestType();
        if (destType == null && (valueBinding = uiComponent.getValueExpression("value")) != null) {
            destType = valueBinding.getType(facesContext.getELContext());
        }
        if (destType != null) {
            Converter converter = ConvertUtils.lookup((Class)destType);
            if (converter == null) {
                throw new UnsupportedOperationException("cant deal with " + destType);
            }
            convertedValue = converter.convert(null, convertedValue);
        }
        return convertedValue;
    }

    public Class getDestType() {
        return (Class)this.getStateHelper().get((Serializable)((Object)PropertyKeys.destType));
    }

    public void setDestType(Class destType) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.destType), (Object)destType);
    }

    public Object _getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        block14: {
            if (facesContext == null) {
                throw new NullPointerException("facesContext");
            }
            if (uiComponent == null) {
                throw new NullPointerException("uiComponent");
            }
            if (value != null && (value = value.trim()).length() > 0) {
                ValueExpression valueBinding;
                NumberFormat format = this.getNumberFormat(facesContext);
                format.setParseIntegerOnly(this.isIntegerOnly());
                DecimalFormat df = (DecimalFormat)format;
                Class destType = this.getDestType();
                if (destType == null && (valueBinding = uiComponent.getValueExpression("value")) != null) {
                    destType = valueBinding.getType(facesContext.getELContext());
                }
                if (destType != null && BigDecimal.class.isAssignableFrom(destType)) {
                    df.setParseBigDecimal(true);
                }
                DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
                boolean changed = false;
                if (dfs.getGroupingSeparator() == '\u00a0') {
                    dfs.setGroupingSeparator(' ');
                    df.setDecimalFormatSymbols(dfs);
                    changed = true;
                }
                this.formatCurrency(format);
                try {
                    return format.parse(value);
                }
                catch (ParseException e) {
                    if (changed) {
                        dfs.setGroupingSeparator('\u00a0');
                        df.setDecimalFormatSymbols(dfs);
                    }
                    try {
                        return format.parse(value);
                    }
                    catch (ParseException pe) {
                        if (this.getPattern() != null) {
                            throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)PATTERN_ID, (Object[])new Object[]{value, "$###,###", MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)}, (FacesContext)facesContext));
                        }
                        if (this.getType().equals("number")) {
                            throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)NUMBER_ID, (Object[])new Object[]{value, format.format(21L), MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)}, (FacesContext)facesContext));
                        }
                        if (this.getType().equals("currency")) {
                            throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)CURRENCY_ID, (Object[])new Object[]{value, format.format(42.25), MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)}, (FacesContext)facesContext));
                        }
                        if (!this.getType().equals("percent")) break block14;
                        throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)PERCENT_ID, (Object[])new Object[]{value, format.format(0.9), MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)}, (FacesContext)facesContext));
                    }
                }
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        NumberFormat format = this.getNumberFormat(facesContext);
        format.setGroupingUsed(this.isGroupingUsed());
        Integer maxFractionDigits = this.getMaxFractionDigits();
        Integer maxIntegerDigits = this.getMaxIntegerDigits();
        Integer minFractionDigits = this.getMinFractionDigits();
        Integer minIntegerDigits = this.getMinIntegerDigits();
        if (maxFractionDigits != null) {
            format.setMaximumFractionDigits(maxFractionDigits);
        }
        if (maxIntegerDigits != null) {
            format.setMaximumIntegerDigits(maxIntegerDigits);
        }
        if (minFractionDigits != null) {
            format.setMinimumFractionDigits(minFractionDigits);
        }
        if (minIntegerDigits != null) {
            format.setMinimumIntegerDigits(minIntegerDigits);
        }
        this.formatCurrency(format);
        try {
            return format.format(value);
        }
        catch (Exception e) {
            throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)STRING_ID, (Object[])new Object[]{value, MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)}, (FacesContext)facesContext), (Throwable)e);
        }
    }

    private NumberFormat getNumberFormat(FacesContext facesContext) {
        Locale lokale = this.getLocale();
        if (this.getPattern() == null && this.getType() == null) {
            throw new ConverterException("Cannot get NumberFormat, either type or pattern needed.");
        }
        if (this.getPattern() != null) {
            return new DecimalFormat(this.getPattern(), new DecimalFormatSymbols(lokale));
        }
        if (this.getType().equals("number")) {
            return NumberFormat.getNumberInstance(lokale);
        }
        if (this.getType().equals("currency")) {
            return NumberFormat.getCurrencyInstance(lokale);
        }
        if (this.getType().equals("percent")) {
            return NumberFormat.getPercentInstance(lokale);
        }
        throw new ConverterException("Cannot get NumberFormat, illegal type " + this.getType());
    }

    private void formatCurrency(NumberFormat format) {
        boolean useCurrencyCode;
        if (this.getLocalCurrencyCode() == null && this.getLocalCurrencySymbol() == null) {
            return;
        }
        if (JAVA_VERSION_14) {
            useCurrencyCode = this.getLocalCurrencyCode() != null;
        } else {
            boolean bl = useCurrencyCode = this.getLocalCurrencySymbol() == null;
        }
        if (useCurrencyCode) {
            try {
                format.setCurrency(Currency.getInstance(this.getLocalCurrencyCode()));
            }
            catch (Exception e) {
                throw new ConverterException("Unable to get Currency instance for currencyCode " + this.getLocalCurrencyCode());
            }
        } else if (format instanceof DecimalFormat) {
            DecimalFormat dFormat = (DecimalFormat)format;
            DecimalFormatSymbols symbols = dFormat.getDecimalFormatSymbols();
            symbols.setCurrencySymbol(this.getLocalCurrencySymbol());
            dFormat.setDecimalFormatSymbols(symbols);
        }
    }

    public String getCurrencyCode() {
        String value = (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currencyCode));
        if (value != null) {
            return value;
        }
        return this.getDecimalFormatSymbols().getInternationalCurrencySymbol();
    }

    protected String getLocalCurrencyCode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currencyCode));
    }

    public void setCurrencyCode(String currencyCode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currencyCode), (Object)currencyCode);
    }

    public String getCurrencySymbol() {
        String value = (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currencySymbol));
        if (value != null) {
            return value;
        }
        return this.getDecimalFormatSymbols().getCurrencySymbol();
    }

    protected String getLocalCurrencySymbol() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currencySymbol));
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currencySymbol), (Object)currencySymbol);
    }

    public abstract boolean isGroupingUsed();

    public abstract boolean isIntegerOnly();

    public Locale getLocale() {
        Object value = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale));
        if (value instanceof String) {
            value = TagUtils.getLocale((Object)value);
        }
        if (value != null) {
            return (Locale)value;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public void setLocale(Locale locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), (Object)locale);
    }

    public abstract Integer getMaxFractionDigits();

    public abstract Integer getMaxIntegerDigits();

    public abstract Integer getMinFractionDigits();

    public abstract Integer getMinIntegerDigits();

    public abstract String getPattern();

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean aTransient) {
        this._transient = aTransient;
    }

    public abstract String getType();

    private static boolean checkJavaVersion14() {
        String version = System.getProperty("java.version");
        if (version == null) {
            return false;
        }
        int java14 = 0;
        int idx = version.indexOf(46);
        int i = 0;
        while (idx > 0 || version != null) {
            byte value;
            if (idx > 0) {
                value = Byte.parseByte(version.substring(0, 1));
                version = version.substring(idx + 1, version.length());
                idx = version.indexOf(46);
                switch (i) {
                    case 0: {
                        if (value == 1) {
                            java14 = 1;
                            break;
                        }
                        if (value > 1) {
                            java14 = 2;
                        }
                    }
                    case 1: {
                        if (java14 > 0 && value >= 4) {
                            java14 = 2;
                        }
                    }
                    default: {
                        idx = 0;
                        version = null;
                        break;
                    }
                }
            } else {
                value = Byte.parseByte(version.substring(0, 1));
                if (java14 <= 0 || value < 4) break;
                java14 = 2;
                break;
            }
            ++i;
        }
        return java14 == 2;
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        return new DecimalFormatSymbols(this.getLocale());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        destType,
        currencyCode,
        currencySymbol,
        locale;

    }
}

