/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutcomeTarget;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlFormRendererBase;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonEventUtils;
import org.apache.myfaces.renderkit.html.util.CommonPropertyUtils;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.util.SharedStringBuilder;

public abstract class HtmlLinkRendererBase
extends HtmlRenderer {
    public static final String END_LINK_OUTCOME_AS_SPAN = "oam.shared.HtmlLinkRendererBase.END_LINK_OUTCOME_AS_SPAN";
    private static final String SB_BUILD_ONCLICK = HtmlLinkRendererBase.class.getName() + "#buildOnClick";
    private static final String SB_ADD_CHILD_PARAMETERS = HtmlLinkRendererBase.class.getName() + "#addChildParameters";
    private MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance();

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        if (component instanceof UICommand) {
            String clientId = component.getClientId(facesContext);
            UIForm form = (UIForm)ComponentUtils.findClosest(UIForm.class, (UIComponent)component);
            boolean disabled = HtmlRendererUtils.isDisabled(component);
            boolean activateActionEvent = false;
            if (form != null && !disabled) {
                String reqValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName((UIComponent)form, facesContext));
                boolean bl = activateActionEvent = reqValue != null && reqValue.equals(clientId) || HtmlRendererUtils.isPartialOrBehaviorSubmit(facesContext, clientId);
            }
            if (component instanceof ClientBehaviorHolder && !disabled) {
                ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, component);
            }
            if (activateActionEvent) {
                component.queueEvent((FacesEvent)new ActionEvent(component));
            }
        } else if (component instanceof UIOutput) {
            if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
                ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, component);
            }
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        Map behaviors;
        super.encodeBegin(facesContext, component);
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if (component instanceof UICommand) {
            this.renderCommandLinkStart(facesContext, component, component.getClientId(facesContext), ((UICommand)component).getValue(), this.getStyle(facesContext, component), this.getStyleClass(facesContext, component));
        } else if (component instanceof UIOutcomeTarget) {
            this.renderOutcomeLinkStart(facesContext, (UIOutcomeTarget)component);
        } else if (component instanceof UIOutput) {
            this.renderOutputLinkStart(facesContext, (UIOutput)component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected String getStyle(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyle();
        }
        return (String)link.getAttributes().get("style");
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyleClass();
        }
        return (String)link.getAttributes().get("styleClass");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        if (component instanceof UICommand) {
            this.renderCommandLinkEnd(facesContext, component);
            UIForm form = (UIForm)ComponentUtils.findClosest(UIForm.class, (UIComponent)component);
            if (form != null) {
                HtmlFormRendererBase.renderScrollHiddenInputIfNecessary((UIComponent)form, facesContext, facesContext.getResponseWriter());
            }
        } else if (component instanceof UIOutcomeTarget) {
            this.renderOutcomeLinkEnd(facesContext, component);
        } else if (component instanceof UIOutput) {
            this.renderOutputLinkEnd(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderCommandLinkStart(FacesContext facesContext, UIComponent component, String clientId, Object value, String style, String styleClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        UIForm form = (UIForm)ComponentUtils.findClosest(UIForm.class, (UIComponent)component);
        boolean disabled = HtmlRendererUtils.isDisabled(component);
        if (disabled || form == null) {
            writer.startElement("span", component);
            if (component instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
                } else {
                    HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
                }
                if (!disabled) {
                    if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                        CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, component);
                        CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
                    } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                        Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(component);
                        CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                        CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                    } else {
                        HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
                        HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, component, behaviors);
                    }
                } else if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventPropertiesWithoutOnclick(writer, commonPropertiesMarked, component);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(component);
                    CommonEventUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, component, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, component, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabledWithoutEvents(writer, commonPropertiesMarked, component);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED);
                }
            }
        } else {
            if (component instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
                this.renderBehaviorizedJavaScriptAnchorStart(facesContext, writer, component, clientId, behaviors, (UIComponent)form);
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
                } else {
                    String commandOnclick = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getOnclick() : (String)component.getAttributes().get("onclick");
                    if (commandOnclick != null) {
                        HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
                    } else {
                        HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                    }
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventPropertiesWithoutOnclick(writer, commonPropertiesMarked, component);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, component, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, component, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesWithoutStyleAndEvents(writer, commonPropertiesMarked, component);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_STYLE_AND_EVENTS);
                }
            } else {
                this.renderJavaScriptAnchorStart(facesContext, writer, component, clientId, (UIComponent)form);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesWithoutOnclickAndStyle(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_ONCLICK_WITHOUT_STYLE);
                }
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
            HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
        }
        if (value != null) {
            writer.writeText((Object)value.toString(), "value");
        }
        if (form == null) {
            writer.writeText((Object)": This link is deactivated, because it is not embedded in a JSF form.", null);
        }
    }

    protected void renderJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component, String clientId, UIComponent form) throws IOException {
        StringBuilder onClick = SharedStringBuilder.get(facesContext, SB_BUILD_ONCLICK);
        String commandOnclick = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getOnclick() : (String)component.getAttributes().get("onclick");
        if (commandOnclick != null) {
            onClick.append("var cf = function(){");
            onClick.append(commandOnclick);
            onClick.append('}');
            onClick.append(';');
            onClick.append("var oamSF = function(){");
        }
        StringBuilder params = this.addChildParameters(facesContext, component, form);
        String target = this.getTarget(component);
        onClick.append("return ").append("myfaces.oam.submitForm").append("('").append(form.getClientId(facesContext)).append("','").append(clientId).append('\'');
        if (params.length() > 2 || target != null) {
            onClick.append(',').append(target == null ? "null" : '\'' + target + '\'').append(',').append((CharSequence)params);
        }
        onClick.append(");");
        if (commandOnclick != null) {
            onClick.append('}');
            onClick.append(';');
            onClick.append("return (cf.apply(this, [])==false)? false : oamSF.apply(this, []); ");
        }
        writer.startElement("a", component);
        writer.writeURIAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)onClick.toString(), null);
    }

    protected void renderBehaviorizedJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component, String clientId, Map<String, List<ClientBehavior>> behaviors, UIComponent formInfo) throws IOException {
        String commandOnclick = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getOnclick() : (String)component.getAttributes().get("onclick");
        String serverEventCode = this.buildServerOnclick(facesContext, component, clientId, formInfo);
        String onclick = null;
        if (commandOnclick == null && (behaviors.isEmpty() || !behaviors.containsKey("click") && !behaviors.containsKey("action"))) {
            onclick = serverEventCode;
        } else {
            boolean hasSubmittingBehavior;
            boolean bl = hasSubmittingBehavior = this.hasSubmittingBehavior(behaviors, "click") || this.hasSubmittingBehavior(behaviors, "action");
            if (!hasSubmittingBehavior) {
                ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
            }
            Collection<ClientBehaviorContext.Parameter> paramList = ClientBehaviorRendererUtils.getClientBehaviorContextParameters(HtmlRendererUtils.mapAttachedParamsToStringValues(facesContext, component));
            onclick = ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, component, "click", paramList, "action", paramList, behaviors, commandOnclick, hasSubmittingBehavior ? null : serverEventCode);
        }
        writer.startElement("a", component);
        writer.writeURIAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)onclick, null);
    }

    private boolean hasSubmittingBehavior(Map<String, List<ClientBehavior>> clientBehaviors, String eventName) {
        block4: {
            List<ClientBehavior> eventBehaviors = clientBehaviors.get(eventName);
            if (eventBehaviors == null || eventBehaviors.isEmpty()) break block4;
            if (eventBehaviors instanceof RandomAccess) {
                int size = eventBehaviors.size();
                for (int i = 0; i < size; ++i) {
                    ClientBehavior behavior = eventBehaviors.get(i);
                    if (!behavior.getHints().contains(ClientBehaviorHint.SUBMITTING)) continue;
                    return true;
                }
            } else {
                for (ClientBehavior behavior : eventBehaviors) {
                    if (!behavior.getHints().contains(ClientBehaviorHint.SUBMITTING)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected String buildServerOnclick(FacesContext facesContext, UIComponent component, String clientId, UIComponent form) throws IOException {
        ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        StringBuilder onClick = SharedStringBuilder.get(facesContext, SB_BUILD_ONCLICK);
        StringBuilder params = this.addChildParameters(facesContext, component, form);
        String target = this.getTarget(component);
        onClick.append("return ").append("myfaces.oam.submitForm").append("('").append(form.getClientId(facesContext)).append("','").append(clientId).append('\'');
        if (params.length() > 2 || target != null) {
            onClick.append(',').append(target == null ? "null" : '\'' + target + '\'').append(',').append((CharSequence)params);
        }
        onClick.append(");");
        return onClick.toString();
    }

    private String getTarget(UIComponent component) {
        String target = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getTarget() : (String)component.getAttributes().get("target");
        return target;
    }

    private StringBuilder addChildParameters(FacesContext context, UIComponent component, UIComponent nestingForm) {
        StringBuilder params = SharedStringBuilder.get(context, SB_ADD_CHILD_PARAMETERS);
        params.append('[');
        List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(context, this.getChildren(component), false, false);
        int size = validParams.size();
        for (int j = 0; j < size; ++j) {
            UIParameter param = validParams.get(j);
            String name = param.getName();
            Object value = param.getValue();
            String strParamValue = "";
            if (value != null) {
                strParamValue = value.toString();
                StringBuilder buff = null;
                for (int i = 0; i < strParamValue.length(); ++i) {
                    char c = strParamValue.charAt(i);
                    if (c == '\'' || c == '\\') {
                        if (buff == null) {
                            buff = new StringBuilder();
                            buff.append(strParamValue.substring(0, i));
                        }
                        buff.append('\\');
                        buff.append(c);
                        continue;
                    }
                    if (buff == null) continue;
                    buff.append(c);
                }
                if (buff != null) {
                    strParamValue = buff.toString();
                }
            }
            if (params.length() > 1) {
                params.append(',');
            }
            params.append("['");
            params.append(name);
            params.append("','");
            params.append(strParamValue);
            params.append("']");
        }
        params.append(']');
        return params;
    }

    private void addChildParametersToHref(FacesContext facesContext, UIComponent linkComponent, StringBuilder hrefBuf, boolean firstParameter, String charEncoding) throws IOException {
        List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, this.getChildren(linkComponent), false, false);
        int size = validParams.size();
        for (int i = 0; i < size; ++i) {
            UIParameter param = validParams.get(i);
            String name = param.getName();
            Object value = param.getValue();
            HtmlLinkRendererBase.addParameterToHref(name, value, hrefBuf, firstParameter, charEncoding, this.myfacesConfig.isStrictXhtmlLinks());
            firstParameter = false;
        }
    }

    protected void renderOutputLinkStart(FacesContext facesContext, UIOutput output) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (HtmlRendererUtils.isDisabled((UIComponent)output)) {
            writer.startElement("span", (UIComponent)output);
            if (output instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)output).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, (UIComponent)output, facesContext);
                } else {
                    HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)output, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)output);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, (UIComponent)output);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, (UIComponent)output);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked((UIComponent)output);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)output, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)output, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)output, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, (UIComponent)output, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabledWithoutEvents(writer, commonPropertiesMarked, (UIComponent)output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)output, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)output), (UIComponent)output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED);
                }
            }
        } else {
            boolean isAnchorInHref;
            String href = RendererUtils.getStringValue(facesContext, (UIComponent)output);
            int index = href.indexOf(35);
            String anchorString = null;
            boolean bl = isAnchorInHref = index > -1;
            if (isAnchorInHref) {
                anchorString = href.substring(index, href.length());
                href = href.substring(0, index);
            }
            if (this.getChildCount((UIComponent)output) > 0) {
                StringBuilder hrefBuf = new StringBuilder(href);
                this.addChildParametersToHref(facesContext, (UIComponent)output, hrefBuf, href.indexOf(63) == -1, writer.getCharacterEncoding());
                href = hrefBuf.toString();
            }
            String fragmentAttr = null;
            fragmentAttr = output instanceof HtmlOutputLink ? ((HtmlOutputLink)output).getFragment() : (String)output.getAttributes().get("fragment");
            if (fragmentAttr != null && !fragmentAttr.isEmpty()) {
                href = href + '#' + fragmentAttr;
            } else if (isAnchorInHref) {
                href = href + anchorString;
            }
            href = facesContext.getExternalContext().encodeResourceURL(href);
            writer.startElement("a", (UIComponent)output);
            writer.writeURIAttribute("href", (Object)href, null);
            if (output instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)output).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, (UIComponent)output, facesContext);
                } else {
                    HtmlRendererUtils.writeIdAndNameIfNecessary(writer, (UIComponent)output, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)output);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, (UIComponent)output);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, (UIComponent)output);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked((UIComponent)output);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)output, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)output, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)output, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, (UIComponent)output, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, (UIComponent)output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdAndNameIfNecessary(writer, (UIComponent)output, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)output), (UIComponent)output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
                }
            }
            writer.flush();
        }
    }

    protected void renderOutcomeLinkStart(FacesContext facesContext, UIOutcomeTarget output) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        String targetHref = HtmlRendererUtils.getOutcomeTargetHref(facesContext, output);
        if (HtmlRendererUtils.isDisabled((UIComponent)output) || targetHref == null) {
            facesContext.getAttributes().put(END_LINK_OUTCOME_AS_SPAN, Boolean.TRUE);
            writer.startElement("span", (UIComponent)output);
            if (output instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)output).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, (UIComponent)output, facesContext);
                } else {
                    HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)output, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)output);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, (UIComponent)output);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, (UIComponent)output);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked((UIComponent)output);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)output, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)output, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)output, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, (UIComponent)output, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabledWithoutEvents(writer, commonPropertiesMarked, (UIComponent)output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)output, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)output), (UIComponent)output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED);
                }
            }
            Object value = output.getValue();
            if (value != null) {
                writer.writeText((Object)value.toString(), "value");
            }
        } else {
            writer.startElement("a", (UIComponent)output);
            writer.writeURIAttribute("href", (Object)targetHref, null);
            if (output instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)output).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, (UIComponent)output, facesContext);
                } else {
                    HtmlRendererUtils.writeIdAndNameIfNecessary(writer, (UIComponent)output, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)output);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, (UIComponent)output);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, (UIComponent)output);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked((UIComponent)output);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)output, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)output, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)output, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, (UIComponent)output, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, (UIComponent)output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdAndNameIfNecessary(writer, (UIComponent)output, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)output), (UIComponent)output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
                }
            }
            writer.flush();
        }
    }

    private static void addParameterToHref(String name, Object value, StringBuilder hrefBuf, boolean firstParameter, String charEncoding, boolean strictXhtmlLinks) throws UnsupportedEncodingException {
        if (name == null) {
            throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
        }
        if (firstParameter) {
            hrefBuf.append('?');
        } else if (strictXhtmlLinks) {
            hrefBuf.append("&amp;");
        } else {
            hrefBuf.append('&');
        }
        hrefBuf.append(URLEncoder.encode(name, charEncoding));
        hrefBuf.append('=');
        if (value != null) {
            hrefBuf.append(URLEncoder.encode(value.toString(), charEncoding));
        }
    }

    protected void renderOutcomeLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component) || Boolean.TRUE.equals(facesContext.getAttributes().get(END_LINK_OUTCOME_AS_SPAN))) {
            writer.endElement("span");
            facesContext.getAttributes().put(END_LINK_OUTCOME_AS_SPAN, Boolean.FALSE);
        } else {
            writer.writeText((Object)RendererUtils.getStringValue(facesContext, component), null);
            writer.endElement("a");
        }
    }

    protected void renderOutputLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component)) {
            writer.endElement("span");
        } else {
            writer.writeText((Object)"", null);
            writer.endElement("a");
        }
    }

    protected void renderCommandLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIForm form = (UIForm)ComponentUtils.findClosest(UIForm.class, (UIComponent)component);
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component) || form == null) {
            writer.endElement("span");
        } else {
            writer.writeText((Object)"", null);
            writer.endElement("a");
        }
    }
}

