/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import javax.el.MethodExpression;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public final class MethodRule
extends MetaRule {
    private final String methodName;
    private final Class<?> returnTypeClass;
    private final Class<?>[] params;

    public MethodRule(String methodName, Class<?> returnTypeClass, Class<?>[] params) {
        this.methodName = methodName;
        this.returnTypeClass = returnTypeClass;
        this.params = params;
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method method;
        if (!name.equals(this.methodName)) {
            return null;
        }
        if (MethodExpression.class.equals((Object)meta.getPropertyType(name)) && (method = meta.getWriteMethod(name)) != null) {
            return new MethodExpressionMetadata(method, attribute, this.returnTypeClass, this.params);
        }
        return null;
    }

    private class MethodExpressionMetadata
    extends Metadata {
        private final Method method;
        private final BiConsumer<Object, Object> function;
        private final TagAttribute attribute;
        private Class<?>[] paramList;
        private Class<?> returnType;

        public MethodExpressionMetadata(Method method, TagAttribute attribute, Class<?> returnType, Class<?>[] paramList) {
            this.method = method;
            this.function = null;
            this.attribute = attribute;
            this.paramList = paramList;
            this.returnType = returnType;
        }

        public MethodExpressionMetadata(BiConsumer<Object, Object> function, TagAttribute attribute, Class<?> returnType, Class<?>[] paramList) {
            this.method = null;
            this.function = function;
            this.attribute = attribute;
            this.paramList = paramList;
            this.returnType = returnType;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this.attribute.getMethodExpression(ctx, this.returnType, (Class[])this.paramList);
            try {
                if (this.method != null) {
                    this.method.invoke(instance, expr);
                } else if (this.function != null) {
                    this.function.accept(instance, expr);
                }
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }
}

