/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class DelegateValidator
implements Validator,
StateHolder {
    private ValueExpression _validatorId;
    private ValueExpression _binding;
    private String _validatorIdString = null;

    public DelegateValidator() {
    }

    public DelegateValidator(ValueExpression id, ValueExpression binding, String converterIdString) {
        this._validatorId = id;
        this._binding = binding;
        this._validatorIdString = converterIdString;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this._validatorId = (ValueExpression)values[0];
        this._binding = (ValueExpression)values[1];
        this._validatorIdString = (String)values[2];
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this._validatorId, this._binding, this._validatorIdString};
        return values;
    }

    @Override
    public void setTransient(boolean arg0) {
    }

    private Validator _getDelegate() {
        return this._createValidator();
    }

    private Validator _createValidator() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        if (null != this._binding) {
            Object validator;
            try {
                validator = this._binding.getValue(elContext);
            }
            catch (Exception e) {
                throw new ValidatorException(new FacesMessage("Error while creating the Validator"), (Throwable)e);
            }
            if (validator instanceof Validator) {
                return (Validator)validator;
            }
        }
        Application application = facesContext.getApplication();
        Validator validator = null;
        try {
            if (null != this._validatorIdString) {
                validator = application.createValidator(this._validatorIdString);
            } else if (null != this._validatorId) {
                String validatorId = (String)this._validatorId.getValue(elContext);
                validator = application.createValidator(validatorId);
            }
        }
        catch (Exception e) {
            throw new ValidatorException(new FacesMessage("Error while creating the Validator"), (Throwable)e);
        }
        if (null != validator) {
            if (null != this._binding) {
                this._binding.setValue(elContext, (Object)validator);
            }
            return validator;
        }
        throw new ValidatorException(new FacesMessage("validatorId and/or binding must be specified"));
    }

    public void validate(FacesContext facesContext, UIComponent component, Object value) throws ValidatorException {
        this._getDelegate().validate(facesContext, component, value);
    }
}

