/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.component;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.view.facelets.component.JsfElement;

public class JsfElementRenderer
extends HtmlRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String elementName = (String)component.getPassThroughAttributes().get("elementName");
        if (elementName == null) {
            throw new FacesException("jsf:element with clientId" + component.getClientId(facesContext) + " requires 'elementName' passthrough attribute");
        }
        JsfElement jsfElement = (JsfElement)component;
        Map behaviors = jsfElement.getClientBehaviors();
        if (behaviors != null && !behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement(elementName, component);
        if (!behaviors.isEmpty()) {
            HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
        }
        long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
        if (behaviors.isEmpty()) {
            CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, component);
            CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
            CommonPropertyUtils.renderChangeSelectEventProperties(writer, commonPropertiesMarked, component);
        } else {
            long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(component);
            CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
            CommonEventUtils.renderBehaviorizedFieldEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, component.getClientId(facesContext), behaviors);
        }
        CommonPropertyUtils.renderStyleProperties(writer, commonPropertiesMarked, component);
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onload", component, "load", behaviors, "onload");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onunload", component, "unload", behaviors, "onunload");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String elementName = (String)component.getPassThroughAttributes().get("elementName");
        writer.endElement(elementName);
    }

    @Override
    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return true;
    }
}

