/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import org.apache.myfaces.extensions.validator.core.renderkit.ConvertedValueCacheEntry;

public class ConvertedValueCache {
    private static ThreadLocal<ConvertedValueCacheEntry> value = new ThreadLocal();

    public static void reset() {
        value.set(null);
        value.remove();
    }

    static boolean isCachedValueAvailable() {
        return ConvertedValueCache.getCacheEntry().isCachedValueAvailable();
    }

    static Object getCachedValue() {
        return ConvertedValueCache.getCacheEntry().getCachedValue();
    }

    static void setCachedValue(Object convertedObject) {
        ConvertedValueCache.getCacheEntry().setCachedValue(convertedObject);
    }

    private static ConvertedValueCacheEntry getCacheEntry() {
        ConvertedValueCacheEntry entry = value.get();
        if (entry == null) {
            entry = new ConvertedValueCacheEntry();
            value.set(entry);
        }
        return entry;
    }
}

