/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.util;

import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.proxy.DefaultProxyHelper;
import org.apache.myfaces.extensions.validator.core.proxy.ProxyHelper;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.JsfUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class ProxyUtils {
    private static ProxyHelper proxyHelper;

    public static <T> Class<T> getUnproxiedClass(Class currentClass, Class<T> targetType) {
        return ProxyUtils.getProxyHelper().getUnproxiedClass(currentClass, targetType);
    }

    public static Class getUnproxiedClass(Class currentClass) {
        return ProxyUtils.getProxyHelper().getUnproxiedClass(currentClass);
    }

    public static String getClassName(Class proxiedClass) {
        return ProxyUtils.getProxyHelper().getNameOfClass(proxiedClass);
    }

    public static String getClassNameOfObject(Object proxiedObject) {
        return ProxyUtils.getProxyHelper().getClassNameOfObject(proxiedObject);
    }

    public static boolean isProxiedClass(Class currentClass) {
        return ProxyUtils.getProxyHelper().isProxiedClass(currentClass);
    }

    public static boolean isProxiedObject(Object proxiedObject) {
        return ProxyUtils.getProxyHelper().isProxiedObject(proxiedObject);
    }

    private static ProxyHelper getProxyHelper() {
        if (proxyHelper == null) {
            if (!JsfUtils.isApplicationInitialized()) {
                return new DefaultProxyHelper();
            }
            proxyHelper = ExtValCoreConfiguration.get().proxyHelper();
        }
        return proxyHelper;
    }
}

