/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.myfaces.trinidadinternal.ui.RendererFactory;
import org.apache.myfaces.trinidadinternal.ui.RendererFactoryImpl;
import org.apache.myfaces.trinidadinternal.ui.RendererManager;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.BaseDesktopConstants;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.PrintablePageLayoutRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLookAndFeel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BaseDesktopLookAndFeel
extends XhtmlLookAndFeel
implements BaseDesktopConstants {
    private static final String _PREFIX = "org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.";
    private static final String[] _SUPPORTED_NAMES = new String[]{"applicationSwitcher", "borderLayout", "breadCrumbs", "cellFormat", "colorButton", "colorField", "colorPalette", "colorSwatch", "column", "columnGroup", "contentFooter", "dateButton", "dateField", "html", "footer", "header", "globalButton", "globalHeader", "html", "menuList", "navigationPath", "navigationTree", "messageBox", "navigationBar", "pageHeaderLayout", "pageLayout", "pageMenuBar", "pageMenuList", "pageNavigationPath", "pageMenuTabs", "pageNavigationTree", "processChoiceBar", "processTrain", "processing", "separator", "panelTabbed", "sideBar", "sideNav", "subTabBar", "tabBar", "tableFooter", "table", "tree"};
    private static final RendererFactory _FACTORY = BaseDesktopLookAndFeel.createDefaultFactory();
    private RendererManager _printableRendererManager;
    private RendererManager _emailRendererManager;
    private RendererManager _editableRendererManager;
    private RendererManager _portletRendererManager;
    private static final String _EDITABLE_FACET = "editable";
    private static final String[] _SUPPORTED_FACETS = new String[]{"default", "printable", "email", "portlet", "editable"};

    @Override
    public String getId() {
        return "base.desktop";
    }

    @Override
    public String getFamily() {
        return "base";
    }

    public String getStyleSheetName() {
        return "META-INF/adf/styles/base-desktop.xss";
    }

    @Override
    public RendererManager getRendererManager(String facet) {
        if ("printable".equals(facet)) {
            return this._getPrintableRendererManager();
        }
        if ("portlet".equals(facet)) {
            return this._getPortletRendererManager();
        }
        if ("email".equals(facet)) {
            return this._getEmailRendererManager();
        }
        if (_EDITABLE_FACET.equals(facet)) {
            return this._getEditableRendererManager();
        }
        return super.getRendererManager(facet);
    }

    @Override
    public Iterator<String> getSupportedFacets() {
        if (_SUPPORTED_FACETS != null) {
            return Arrays.asList(_SUPPORTED_FACETS).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public static RendererFactoryImpl createDefaultFactory() {
        RendererFactoryImpl rendererFactory = XhtmlLookAndFeel.createDefaultFactory();
        rendererFactory.registerRenderers(BaseDesktopLookAndFeel.createInstantiators(_PREFIX, _SUPPORTED_NAMES));
        return rendererFactory;
    }

    public static void applyFacet(RendererFactoryImpl rendererFactory, String facet) {
        XhtmlLookAndFeel.applyFacet(rendererFactory, facet);
        if ("printable".equals(facet) || "email".equals(facet)) {
            rendererFactory.registerRenderer("pageLayout", new PrintablePageLayoutRenderer());
        }
    }

    @Override
    protected RendererFactory getDefaultFactory() {
        return _FACTORY;
    }

    @Override
    protected RendererFactory getFactory(String facet) {
        if ("printable".equals(facet)) {
            return this._createPrintableFactory();
        }
        if ("portlet".equals(facet)) {
            return this.getDefaultFactory();
        }
        if ("email".equals(facet)) {
            return this._createEmailFactory();
        }
        if (_EDITABLE_FACET.equals(facet)) {
            return this.getDefaultFactory();
        }
        return super.getFactory(facet);
    }

    private synchronized RendererManager _getPrintableRendererManager() {
        if (this._printableRendererManager == null) {
            this._printableRendererManager = this.createRendererManager("printable");
        }
        return this._printableRendererManager;
    }

    private synchronized RendererManager _getEmailRendererManager() {
        if (this._emailRendererManager == null) {
            this._emailRendererManager = this.createRendererManager("email");
        }
        return this._emailRendererManager;
    }

    private synchronized RendererManager _getEditableRendererManager() {
        if (this._editableRendererManager == null) {
            this._editableRendererManager = this.createRendererManager(_EDITABLE_FACET);
        }
        return this._editableRendererManager;
    }

    private synchronized RendererManager _getPortletRendererManager() {
        if (this._portletRendererManager == null) {
            this._portletRendererManager = this.createRendererManager("portlet");
        }
        return this._portletRendererManager;
    }

    private RendererFactoryImpl _createPrintableFactory() {
        RendererFactoryImpl rendererFactory = BaseDesktopLookAndFeel.createDefaultFactory();
        BaseDesktopLookAndFeel.applyFacet(rendererFactory, "printable");
        return rendererFactory;
    }

    private RendererFactoryImpl _createEmailFactory() {
        RendererFactoryImpl rendererFactory = BaseDesktopLookAndFeel.createDefaultFactory();
        BaseDesktopLookAndFeel.applyFacet(rendererFactory, "email");
        return rendererFactory;
    }
}

