/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.data.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.expl.Coercions;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.data.MutableDataObject;
import org.apache.myfaces.trinidadinternal.ui.data.bean.BeanDOAdapter;
import org.apache.myfaces.trinidadinternal.util.JavaIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class IntrospectionAdapter
implements BeanDOAdapter {
    private Class<?> _class;
    private Object _instance;
    private ClassInfo _classInfo;
    private static Map<Class<?>, ClassInfo> _sIntrospectionInfo;
    private static final ClassInfo _sEmptyClassInfo;
    private static final TrinidadLogger _LOG;

    public static BeanDOAdapter getAdapter(Object instance) {
        if (instance == null) {
            return null;
        }
        Class<?> objClass = instance.getClass();
        ClassInfo classInfo = IntrospectionAdapter._getIntrospectionInfo(objClass);
        IntrospectionAdapter adapter = classInfo.hasWriters() ? new MutableIntrospectionAdapter(objClass, classInfo) : new IntrospectionAdapter(objClass, classInfo);
        adapter.setInstance(instance);
        return adapter;
    }

    @Override
    public void setInstance(Object instance) {
        if (instance != null && !this._class.isInstance(instance)) {
            throw new IllegalArgumentException(_LOG.getMessage("NOT_AN_INSTANCE", new Object[]{instance.toString(), this._class}));
        }
        this._instance = instance;
    }

    @Override
    public Object selectValue(UIXRenderingContext context, Object select) {
        Object instance = this._instance;
        if (instance == null || select == null) {
            return null;
        }
        if (".".equals(select)) {
            return instance;
        }
        return this._classInfo.selectValue(context, select, instance);
    }

    public void updateValue(UIXRenderingContext context, Object select, Object value) {
        Object instance = this._instance;
        if (instance != null && select != null) {
            this._classInfo.updateValue(context, select, value, instance);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(40);
        String className = this.getClass().getName();
        buffer.append(className);
        buffer.append('[');
        buffer.append(this._instance);
        buffer.append(']');
        return buffer.toString();
    }

    IntrospectionAdapter(Class<?> objClass, ClassInfo classInfo) {
        this._class = objClass;
        this._classInfo = classInfo;
    }

    private static ClassInfo _getIntrospectionInfo(Class<?> objClass) {
        ClassInfo classInfo = _sIntrospectionInfo.get(objClass);
        if (classInfo == null) {
            classInfo = IntrospectionAdapter._createIntrospectionInfo(objClass);
            if (classInfo == null) {
                classInfo = _sEmptyClassInfo;
            }
            _sIntrospectionInfo.put(objClass, classInfo);
        }
        return classInfo;
    }

    private static ClassInfo _createIntrospectionInfo(Class<?> objClass) {
        if (objClass == Object.class) {
            return null;
        }
        HashMap<String, PropertyReader> readers = null;
        HashMap<String, PropertyWriter> writers = null;
        if (!Modifier.isPublic(objClass.getModifiers())) {
            ClassInfo superClassInfo;
            Class<?> superClass = objClass.getSuperclass();
            if (superClass != null && (superClassInfo = IntrospectionAdapter._getIntrospectionInfo(superClass)) != null) {
                readers = new HashMap();
                writers = new HashMap();
                superClassInfo.putAllReadersInto(readers);
                superClassInfo.putAllWritersInto(writers);
            }
            Class<?>[] interfaces = objClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                ClassInfo interfaceInfo = IntrospectionAdapter._getIntrospectionInfo(interfaces[i]);
                if (interfaceInfo == null) continue;
                if (readers == null) {
                    readers = new HashMap();
                }
                interfaceInfo.putAllReadersInto(readers);
                if (writers == null) {
                    writers = new HashMap();
                }
                interfaceInfo.putAllWritersInto(writers);
            }
        } else {
            readers = new HashMap<String, PropertyReader>();
            writers = new HashMap<String, PropertyWriter>();
            try {
                BeanInfo info = JavaIntrospector.getBeanInfo(objClass);
                PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                if (descriptors != null) {
                    for (int i = 0; i < descriptors.length; ++i) {
                        String name = descriptors[i].getName();
                        Method reader = descriptors[i].getReadMethod();
                        Method writer = descriptors[i].getWriteMethod();
                        if (name == null) continue;
                        if (reader != null) {
                            readers.put(name, new MethodReader(reader));
                        }
                        if (writer == null) continue;
                        writers.put(name, new MethodWriter(writer));
                    }
                }
                Field[] fields = objClass.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    FieldReaderWriter frw = new FieldReaderWriter(fields[i]);
                    readers.put(fields[i].getName(), frw);
                    writers.put(fields[i].getName(), frw);
                }
            }
            catch (IntrospectionException ie) {
                _LOG.severe((Throwable)ie);
            }
        }
        if (readers == null && writers == null) {
            return null;
        }
        return new ClassInfo(readers, writers);
    }

    private static Object _coerceType(Object value, Class<?> type) {
        return Coercions.coerce(value, type);
    }

    private static void _logInvocationTargetException(InvocationTargetException ite) {
        Throwable t = ite.getTargetException();
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        _LOG.severe(t);
    }

    static {
        _sEmptyClassInfo = new ClassInfo(new HashMap<String, PropertyReader>(1), new HashMap<String, PropertyWriter>(1));
        _sIntrospectionInfo = Collections.synchronizedMap(new WeakHashMap());
        _LOG = TrinidadLogger.createTrinidadLogger(IntrospectionAdapter.class);
    }

    private static class FieldReaderWriter
    implements PropertyReader,
    PropertyWriter {
        private final Field _field;

        public FieldReaderWriter(Field field) {
            this._field = field;
        }

        public Object readProperty(UIXRenderingContext context, Object instance) throws IllegalAccessException {
            return this._field.get(instance);
        }

        public void writeProperty(UIXRenderingContext context, Object instance, Object value) throws IllegalAccessException {
            value = IntrospectionAdapter._coerceType(value, this._field.getType());
            this._field.set(instance, value);
        }
    }

    private static class MethodWriter
    implements PropertyWriter {
        private final Method _method;
        private final Class<?> _type;

        public MethodWriter(Method method) {
            this._method = method;
            this._type = method.getParameterTypes()[0];
        }

        public void writeProperty(UIXRenderingContext context, Object instance, Object value) throws IllegalAccessException {
            if ((value = IntrospectionAdapter._coerceType(value, this._type)) == null && this._type.isPrimitive()) {
                return;
            }
            try {
                this._method.invoke(instance, value);
            }
            catch (InvocationTargetException ite) {
                IntrospectionAdapter._logInvocationTargetException(ite);
            }
        }
    }

    private static class MethodReader
    implements PropertyReader {
        private final Method _method;

        public MethodReader(Method method) {
            this._method = method;
        }

        public Object readProperty(UIXRenderingContext context, Object instance) throws IllegalAccessException {
            try {
                return this._method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                IntrospectionAdapter._logInvocationTargetException(ite);
                return null;
            }
        }
    }

    private static interface PropertyWriter {
        public void writeProperty(UIXRenderingContext var1, Object var2, Object var3) throws IllegalAccessException;
    }

    private static interface PropertyReader {
        public Object readProperty(UIXRenderingContext var1, Object var2) throws IllegalAccessException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassInfo {
        private Map<String, PropertyReader> _readers;
        private Map<String, PropertyWriter> _writers;

        public ClassInfo(Map<String, PropertyReader> readers, Map<String, PropertyWriter> writers) {
            this._readers = readers;
            this._writers = writers;
        }

        public void putAllReadersInto(Map<String, PropertyReader> into) {
            into.putAll(this._readers);
        }

        public void putAllWritersInto(Map<String, PropertyWriter> into) {
            into.putAll(this._writers);
        }

        public boolean hasWriters() {
            return this._writers != null && this._writers.size() > 0;
        }

        public Object selectValue(UIXRenderingContext context, Object select, Object instance) {
            PropertyReader o = this._readers.get(select);
            if (o == null) {
                this._reportMissingProperty(select, instance);
            } else {
                try {
                    return o.readProperty(context, instance);
                }
                catch (IllegalAccessException iae) {
                    _LOG.severe((Throwable)iae);
                }
            }
            return null;
        }

        public void updateValue(UIXRenderingContext context, Object select, Object value, Object instance) {
            PropertyWriter o = this._writers.get(select);
            if (o == null) {
                this._reportMissingProperty(select, instance);
            } else {
                try {
                    o.writeProperty(context, instance, value);
                }
                catch (IllegalAccessException iae) {
                    _LOG.severe((Throwable)iae);
                }
            }
        }

        private void _reportMissingProperty(Object select, Object instance) {
            if (_LOG.isFine()) {
                _LOG.fine("No bean property named " + select + " on instance:" + instance + " of class:" + instance.getClass().getName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private static class MutableIntrospectionAdapter
    extends IntrospectionAdapter
    implements MutableDataObject {
        public MutableIntrospectionAdapter(Class<?> objClass, ClassInfo classInfo) {
            super(objClass, classInfo);
        }
    }
}

