/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context.external;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.context.external.EnumerationIterator;
import org.apache.myfaces.trinidadinternal.context.external.ServletApplicationMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletCookieMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletInitParameterMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestHeaderMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestHeaderValuesMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestParameterMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestParameterValuesMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletSessionMap;

public class ServletExternalContext
extends ExternalContext {
    private Map<String, Object> _applicationMap;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private Map<String, String> _initParameterMap;
    private Map<String, Object> _requestCookieMap;
    private Map<String, String> _requestHeaderMap;
    private Map<String, String[]> _requestHeaderValuesMap;
    private Map<String, Object> _requestMap;
    private Map<String, String> _requestParameterMap;
    private Map<String, String[]> _requestParameterValuesMap;
    private String _requestPathInfo;
    private String _requestServletPath;
    private ServletContext _servletContext;
    private ServletRequest _servletRequest;
    private ServletResponse _servletResponse;
    private Map<String, Object> _sessionMap;
    private static final String _URL_PARAM_SEPERATOR = "&";
    private static final String _URL_QUERY_SEPERATOR = "?";
    private static final String _URL_FRAGMENT_SEPERATOR = "#";
    private static final String _URL_NAME_VALUE_PAIR_SEPERATOR = "=";
    private static final String _INIT_PARAMETER_MAP_ATTRIBUTE = ServletInitParameterMap.class.getName();
    private static final String _CHAR_ENCODING_CALLED = ServletExternalContext.class.getName() + ".CHAR_ENCODING_CALLED";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ServletExternalContext.class);

    public ServletExternalContext(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        assert (servletContext != null);
        this._servletContext = servletContext;
        this._servletRequest = servletRequest;
        this._servletResponse = servletResponse;
        if (servletRequest != null && servletRequest instanceof HttpServletRequest) {
            this._httpServletRequest = (HttpServletRequest)servletRequest;
            if (this._servletResponse != null) {
                this._httpServletResponse = (HttpServletResponse)servletResponse;
            }
        }
        if (this._httpServletRequest != null) {
            this._initHttpServletRequest();
        }
    }

    public void dispatch(String path) throws IOException, FacesException {
        this._checkRequest();
        this._checkResponse();
        RequestDispatcher requestDispatcher = this._servletRequest.getRequestDispatcher(path);
        if (requestDispatcher == null) {
            if (this._httpServletResponse != null) {
                this._httpServletResponse.sendError(404);
            }
            return;
        }
        try {
            requestDispatcher.forward(this._servletRequest, this._servletResponse);
        }
        catch (ServletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public String encodeActionURL(String url) {
        this._checkRequest();
        this._checkNull(url, "url");
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return this._httpServletResponse.encodeURL(url);
    }

    public String encodeNamespace(String s) {
        this._checkRequest();
        return s;
    }

    public String encodeResourceURL(String s) {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return this._httpServletResponse.encodeURL(s);
    }

    public Map<String, Object> getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new ServletApplicationMap(this._servletContext);
        }
        return this._applicationMap;
    }

    public String getAuthType() {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return this._httpServletRequest.getAuthType();
    }

    public Object getContext() {
        return this._servletContext;
    }

    public String getInitParameter(String s) {
        return this._servletContext.getInitParameter(s);
    }

    public Map<String, String> getInitParameterMap() {
        if (this._initParameterMap == null && (this._initParameterMap = (Map)this._servletContext.getAttribute(_INIT_PARAMETER_MAP_ATTRIBUTE)) == null) {
            this._initParameterMap = new ServletInitParameterMap(this._servletContext);
            this._servletContext.setAttribute(_INIT_PARAMETER_MAP_ATTRIBUTE, this._initParameterMap);
        }
        return this._initParameterMap;
    }

    public String getRemoteUser() {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return this._httpServletRequest.getRemoteUser();
    }

    public Object getRequest() {
        return this._servletRequest;
    }

    public String getRequestContextPath() {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return this._httpServletRequest.getContextPath();
    }

    public Map<String, Object> getRequestCookieMap() {
        this._checkRequest();
        if (this._requestCookieMap == null) {
            if (this._httpServletRequest == null) {
                throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
            }
            this._requestCookieMap = new ServletCookieMap(this._httpServletRequest);
        }
        return this._requestCookieMap;
    }

    public Map<String, String> getRequestHeaderMap() {
        this._checkRequest();
        if (this._requestHeaderMap == null) {
            if (this._httpServletRequest == null) {
                throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
            }
            this._requestHeaderMap = new ServletRequestHeaderMap(this._httpServletRequest);
        }
        return this._requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        this._checkRequest();
        if (this._requestHeaderValuesMap == null) {
            if (this._httpServletRequest == null) {
                throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
            }
            this._requestHeaderValuesMap = new ServletRequestHeaderValuesMap(this._httpServletRequest);
        }
        return this._requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        this._checkRequest();
        return this._servletRequest.getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return new EnumerationIterator<Locale>(this._httpServletRequest.getLocales());
    }

    public Map<String, Object> getRequestMap() {
        this._checkRequest();
        if (this._requestMap == null) {
            this._requestMap = new ServletRequestMap(this._servletRequest);
        }
        return this._requestMap;
    }

    public Map<String, String> getRequestParameterMap() {
        this._checkRequest();
        if (this._requestParameterMap == null) {
            this._requestParameterMap = new ServletRequestParameterMap(this._servletRequest);
        }
        return this._requestParameterMap;
    }

    public Iterator<String> getRequestParameterNames() {
        this._checkRequest();
        EnumerationIterator<String> it = new EnumerationIterator<String>(this._servletRequest.getParameterNames());
        return it;
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        this._checkRequest();
        if (this._requestParameterValuesMap == null) {
            this._requestParameterValuesMap = new ServletRequestParameterValuesMap(this._servletRequest);
        }
        return this._requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return this._requestPathInfo;
    }

    public String getRequestServletPath() {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return this._requestServletPath;
    }

    public URL getResource(String s) throws MalformedURLException {
        return this._servletContext.getResource(s);
    }

    public InputStream getResourceAsStream(String s) {
        return this._servletContext.getResourceAsStream(s);
    }

    public Set<String> getResourcePaths(String s) {
        return this._servletContext.getResourcePaths(s);
    }

    public Object getResponse() {
        return this._servletResponse;
    }

    public Writer getResponseOutputWriter() throws IOException {
        return this._servletResponse.getWriter();
    }

    public OutputStream getResponseOutputStream() throws IOException {
        return this._servletResponse.getOutputStream();
    }

    public Object getSession(boolean create) {
        if (this._httpServletRequest == null) {
            return null;
        }
        return this._httpServletRequest.getSession(create);
    }

    public Map<String, Object> getSessionMap() {
        this._checkRequest();
        if (this._sessionMap == null) {
            if (this._httpServletRequest == null) {
                throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
            }
            this._sessionMap = new ServletSessionMap(this._httpServletRequest);
        }
        return this._sessionMap;
    }

    public Principal getUserPrincipal() {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return this._httpServletRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        this._checkRequest();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETREQUEST_SUPPORTED"));
        }
        return this._httpServletRequest.isUserInRole(role);
    }

    public void log(String message) {
        this._servletContext.log(message);
    }

    public void log(String message, Throwable t) {
        this._servletContext.log(message, t);
    }

    public void redirect(String url) throws IOException {
        this._checkResponse();
        if (this._servletResponse instanceof HttpServletResponse) {
            this._httpServletResponse.sendRedirect(url);
            FacesContext fc = FacesContext.getCurrentInstance();
            if (fc != null) {
                fc.responseComplete();
            }
        } else {
            throw new IllegalArgumentException(_LOG.getMessage("ONLY_HTTPSERVLETRESPONSE_SUPPORTED"));
        }
    }

    public String getRequestCharacterEncoding() {
        this._checkRequest();
        return this._servletRequest.getCharacterEncoding();
    }

    public String getRequestContentType() {
        this._checkRequest();
        return this._servletRequest.getContentType();
    }

    public String getResponseCharacterEncoding() {
        this._checkResponse();
        return this._servletResponse.getCharacterEncoding();
    }

    public String getResponseContentType() {
        this._checkResponse();
        return this._servletResponse.getContentType();
    }

    public void setRequest(Object object) {
        this._servletRequest = (ServletRequest)object;
        if (object instanceof HttpServletRequest) {
            this._httpServletRequest = (HttpServletRequest)object;
            this._initHttpServletRequest();
        } else {
            this._httpServletRequest = null;
        }
        this._requestCookieMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
    }

    public void setRequestCharacterEncoding(String string) throws UnsupportedEncodingException {
        this._checkRequest();
        this._servletRequest.setCharacterEncoding(string);
    }

    public void setResponse(Object object) {
        this._servletResponse = (ServletResponse)object;
        this._httpServletResponse = this._servletResponse instanceof HttpServletResponse ? (HttpServletResponse)object : null;
    }

    public void setResponseCharacterEncoding(String string) {
        this._checkResponse();
        this._servletResponse.setCharacterEncoding(string);
    }

    public void release() {
        this._servletContext = null;
        this._servletRequest = null;
        this._servletResponse = null;
        this._applicationMap = null;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestCookieMap = null;
        this._initParameterMap = null;
    }

    public String encodePartialActionURL(String url) {
        this._checkNull(url, "url");
        this._checkResponse();
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return this._httpServletResponse.encodeURL(url);
    }

    public String encodeBookmarkableURL(String url, Map<String, List<String>> params) {
        this._checkNull(url, "url");
        return this._encodeURL(url, params);
    }

    public String encodeRedirectURL(String url, Map<String, List<String>> params) {
        this._checkResponse();
        this._checkNull(url, "url");
        if (this._httpServletRequest == null) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        if (params == null) {
            return this._httpServletResponse.encodeRedirectURL(url);
        }
        return this._httpServletResponse.encodeRedirectURL(this._encodeURL(url, params));
    }

    private void _checkNull(Object o, String param) {
        if (o == null) {
            throw new NullPointerException(_LOG.getMessage("CANNOT_BE_NULL", (Object)param));
        }
    }

    private void _checkRequest() {
        if (this._servletRequest == null) {
            throw new UnsupportedOperationException(_LOG.getMessage("NULL_REQUEST_ON_THIS_CONTEXT"));
        }
    }

    private void _checkResponse() {
        if (this._servletResponse == null) {
            throw new UnsupportedOperationException(_LOG.getMessage("NULL_RESPONSE_ON_THIS_CONTEXT"));
        }
    }

    private String _lookupCharacterEncoding(String contentType) {
        String characterEncoding = null;
        if (contentType != null) {
            int charsetFind = contentType.indexOf("charset=");
            if (charsetFind != -1) {
                if (charsetFind == 0) {
                    characterEncoding = contentType.substring(8);
                } else {
                    char charBefore = contentType.charAt(charsetFind - 1);
                    if (charBefore == ';' || Character.isWhitespace(charBefore)) {
                        characterEncoding = contentType.substring(charsetFind + 8);
                    }
                }
                if (_LOG.isFine()) {
                    _LOG.fine("Incoming request has Content-Type header with character encoding " + characterEncoding);
                }
            } else if (_LOG.isFine()) {
                _LOG.fine("Incoming request has Content-Type header without character encoding: " + contentType);
            }
        }
        return characterEncoding;
    }

    private void _initHttpServletRequest() {
        this._requestServletPath = this._httpServletRequest.getServletPath();
        this._requestPathInfo = this._httpServletRequest.getPathInfo();
        String contentType = this._httpServletRequest.getHeader("Content-Type");
        String characterEncoding = this._lookupCharacterEncoding(contentType);
        if (characterEncoding == null) {
            HttpSession session = this._httpServletRequest.getSession(false);
            if (session != null) {
                characterEncoding = (String)session.getAttribute("javax.faces.request.charset");
            }
            if (characterEncoding != null) {
                try {
                    this._servletRequest.setCharacterEncoding(characterEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    _LOG.warning((Throwable)uee);
                }
            }
        }
    }

    private String _encodeURL(String baseUrl, Map<String, List<String>> parameters) {
        String fragment = null;
        String queryString = null;
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        int index = baseUrl.indexOf(_URL_FRAGMENT_SEPERATOR);
        if (index != -1) {
            fragment = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
        }
        if ((index = baseUrl.indexOf(_URL_QUERY_SEPERATOR)) != -1) {
            queryString = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
            String[] nameValuePairs = queryString.split(_URL_PARAM_SEPERATOR);
            for (int i = 0; i < nameValuePairs.length; ++i) {
                String[] currentPair = nameValuePairs[i].split(_URL_NAME_VALUE_PAIR_SEPERATOR);
                ArrayList<String> value = new ArrayList<String>(1);
                try {
                    value.add(currentPair.length > 1 ? URLDecoder.decode(currentPair[1], this.getResponseCharacterEncoding()) : "");
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException("Encoding type=" + this.getResponseCharacterEncoding() + " not supported", e);
                }
                paramMap.put(currentPair[0], value);
            }
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (parameters != null && parameters.size() > 0) {
            for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
                if (pair.getKey() == null || pair.getKey().trim().length() == 0) continue;
                paramMap.put(pair.getKey(), this._evaluateValueExpressions(context, pair.getValue()));
            }
        }
        StringBuilder newUrl = new StringBuilder(baseUrl);
        if (paramMap.size() > 0) {
            boolean isFirstPair = true;
            for (Map.Entry pair : paramMap.entrySet()) {
                for (String value : (List)pair.getValue()) {
                    if (!isFirstPair) {
                        newUrl.append(_URL_PARAM_SEPERATOR);
                    } else {
                        newUrl.append(_URL_QUERY_SEPERATOR);
                        isFirstPair = false;
                    }
                    newUrl.append((String)pair.getKey());
                    newUrl.append(_URL_NAME_VALUE_PAIR_SEPERATOR);
                    try {
                        newUrl.append(URLEncoder.encode(value, this.getResponseCharacterEncoding()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnsupportedOperationException("Encoding type=" + this.getResponseCharacterEncoding() + " not supported", e);
                    }
                }
            }
        }
        if (fragment != null) {
            newUrl.append(_URL_FRAGMENT_SEPERATOR + fragment);
        }
        return newUrl.toString();
    }

    private List<String> _evaluateValueExpressions(FacesContext context, List<String> values) {
        ArrayList<String> target = new ArrayList<String>(values.size());
        for (String value : values) {
            if (this._isExpression(value)) {
                if (context == null) {
                    throw new UnsupportedOperationException("FacesContext not established yet. Unable to resolve EL bound queryparameter value: \"" + value + "\"");
                }
                Application app = context.getApplication();
                String dynamicValue = (String)app.evaluateExpressionGet(context, value, String.class);
                target.add(dynamicValue);
                continue;
            }
            target.add(value);
        }
        return target;
    }

    private boolean _isExpression(String text) {
        return text.indexOf("#{") != -1;
    }
}

