/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import org.apache.myfaces.trinidad.change.AddComponentDocumentChange;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SetFacetChildDocumentChange
extends AddComponentDocumentChange {
    private static final String _JSF_CORE_NAMESPACE = "http://java.sun.com/jsf/core";
    private static final String _XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final String _FACET_ATTRIBUTE_NAME = "name";
    private final String _facetName;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SetFacetChildDocumentChange.class);

    public SetFacetChildDocumentChange(String facetName, DocumentFragment fragment) {
        super(fragment);
        if (facetName == null || facetName.length() == 0) {
            throw new IllegalArgumentException(_LOG.getMessage("FACET_NAME_MUST_SPECIFIED"));
        }
        this._facetName = facetName;
    }

    public String getFacetName() {
        return this._facetName;
    }

    @Override
    public void changeDocument(Node componentNode) {
        if (componentNode == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NO_NODE_SPECIFIED"));
        }
        DocumentFragment targetFragment = this.getImportedComponentFragment(componentNode);
        Element facetElement = ChangeUtils.__getFacetElement(componentNode, this._facetName);
        if (facetElement != null) {
            ChangeUtils.__removeAllChildren(facetElement);
        } else {
            Document targetDocument = componentNode.getOwnerDocument();
            facetElement = targetDocument.createElementNS(_JSF_CORE_NAMESPACE, "f:facet");
            facetElement.setAttributeNS(_XMLNS_NAMESPACE, "xmlns:f", _JSF_CORE_NAMESPACE);
            facetElement.setAttribute(_FACET_ATTRIBUTE_NAME, this._facetName);
            componentNode.appendChild(facetElement);
        }
        facetElement.appendChild(targetFragment);
    }

    @Override
    public boolean getForcesDocumentReload() {
        return false;
    }
}

