/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinAddition;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.skin.DocumentProviderSkin;
import org.apache.myfaces.trinidadinternal.skin.SkinUtils;
import org.apache.myfaces.trinidadinternal.skin.StyleSheetEntry;
import org.apache.myfaces.trinidadinternal.skin.icon.ReferenceIcon;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.xml.StyleSheetDocumentUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SkinImpl
extends Skin
implements DocumentProviderSkin {
    private ConcurrentHashMap<Locale, KeyValueMapStatus> _translations = new ConcurrentHashMap(13);
    private ConcurrentHashMap<String, Icon> _icons = new ConcurrentHashMap();
    private StyleSheetDocument _styleSheetDocument;
    private StyleSheetEntry _skinStyleSheet;
    private List<String> _skinAdditionStyleSheetNames;
    private StyleSheetEntry[] _skinAdditionStyleSheets;
    private List<TranslationSource> _translationSourceList;
    private List<SkinAddition> _skinAdditions;
    private ConcurrentHashMap<Object, Object> _properties = new ConcurrentHashMap();
    private boolean _dirty;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinImpl.class);

    public String getId() {
        return null;
    }

    public String getFamily() {
        return null;
    }

    public String getRenderKitId() {
        return null;
    }

    public String getStyleSheetDocumentId(RenderingContext arc) {
        StyleContext sContext = ((CoreRenderingContext)arc).getStyleContext();
        return this.getStyleSheetDocument(sContext).getDocumentId(sContext);
    }

    public abstract String getStyleSheetName();

    public String getTranslatedString(LocaleContext lContext, String key) throws MissingResourceException {
        Object o = this.getTranslatedValue(lContext, key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Object getTranslatedValue(LocaleContext lContext, String key) throws MissingResourceException {
        if (lContext == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_LOCALE_CONTEXT"));
        }
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        List<TranslationSource> translationSourceList = this._getTranslationSourceList();
        if (translationSourceList.size() == 0) {
            return null;
        }
        Object translatedValue = this.getCachedTranslatedValue(lContext, key);
        if (translatedValue == null) {
            throw new MissingResourceException("Can't find resource for bundle", this.getBundleName(), key);
        }
        return translatedValue;
    }

    public Icon getIcon(String iconName) {
        return this.getIcon(iconName, true);
    }

    public Icon getIcon(String iconName, boolean resolveIcon) {
        if (iconName == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_ICONNAME"));
        }
        Icon icon = this._icons.get(iconName);
        if (resolveIcon && icon instanceof ReferenceIcon) {
            icon = SkinUtils.resolveReferenceIcon(this, (ReferenceIcon)icon);
        }
        return icon;
    }

    public synchronized void registerIcon(String iconName, Icon icon) {
        if (iconName == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_ICONNAME"));
        }
        this._icons.put(iconName, icon);
    }

    public void addSkinAddition(SkinAddition skinAddition) {
        if (skinAddition == null) {
            throw new NullPointerException("NULL_SKINADDITION");
        }
        if (this._skinAdditions == null) {
            this._skinAdditions = new ArrayList<SkinAddition>();
        }
        this._skinAdditions.add(skinAddition);
    }

    public List<SkinAddition> getSkinAdditions() {
        if (this._skinAdditions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._skinAdditions);
    }

    public Map<String, String> getStyleClassMap(RenderingContext arc) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!this._isDisableContentCompressionParameterTrue(context)) {
            StyleContext sContext = ((CoreRenderingContext)arc).getStyleContext();
            StyleProvider sProvider = sContext.getStyleProvider();
            if (!sContext.isDisableStyleCompression()) {
                return sProvider.getShortStyleClasses(sContext);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyleSheetDocument getStyleSheetDocument(StyleContext context) {
        SkinImpl skinImpl = this;
        synchronized (skinImpl) {
            if (this._styleSheetDocument == null || this._checkStylesModified(context)) {
                this._styleSheetDocument = this._createStyleSheetDocument(context);
            }
            return this._styleSheetDocument;
        }
    }

    public Object getProperty(Object key) {
        return this._properties.get(key);
    }

    public void setProperty(Object key, Object value) {
        this._properties.put(key, value);
    }

    public void registerStyleSheet(String styleSheetName) {
        SkinAddition addition = new SkinAddition(styleSheetName);
        this.addSkinAddition(addition);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    protected Object getCachedTranslatedValue(LocaleContext lContext, String key) {
        if (lContext == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_LOCALE_CONTEXT"));
        }
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        List<TranslationSource> translationSourceList = this._getTranslationSourceList();
        return this._getCachedTranslationValueFromLocale(lContext, translationSourceList, key);
    }

    protected void putTranslatedValueInLocaleCache(LocaleContext lContext, String key, Object value) {
        Locale locale = lContext.getTranslationLocale();
        KeyValueMapStatus keyValueMapStatus = this._translations.get(locale);
        if (keyValueMapStatus != null) {
            Map<String, Object> keyValueMap = keyValueMapStatus.getKeyValueMap();
            if (keyValueMap != null) {
                keyValueMap.put(key, value);
            }
        } else {
            this._createKeyValueMapStatusInCache(locale, key, value);
        }
    }

    protected abstract String getBundleName();

    protected abstract ValueExpression getTranslationSourceValueExpression();

    private boolean _checkStylesModified(StyleContext context) {
        boolean modified = false;
        if (this._skinStyleSheet != null) {
            modified = this._skinStyleSheet.checkModified(context);
        }
        if (this._skinAdditionStyleSheets != null) {
            for (int i = 0; i < this._skinAdditionStyleSheets.length; ++i) {
                StyleSheetEntry entry = this._skinAdditionStyleSheets[i];
                if (!entry.checkModified(context)) continue;
                modified = true;
            }
        }
        return modified;
    }

    private StyleSheetDocument _createStyleSheetDocument(StyleContext context) {
        if (this._styleSheetDocument == null) {
            String styleSheetName = this.getStyleSheetName();
            if (styleSheetName != null) {
                this._skinStyleSheet = StyleSheetEntry.createEntry(context, styleSheetName);
            }
            this._skinAdditionStyleSheets = this._getSkinAdditionsStyleSheets(context);
        }
        StyleSheetDocument document = null;
        if (this._skinStyleSheet != null) {
            document = this._skinStyleSheet.getDocument();
        }
        if (this._skinAdditionStyleSheets != null) {
            for (int i = 0; i < this._skinAdditionStyleSheets.length; ++i) {
                StyleSheetDocument additionDocument;
                StyleSheetEntry entry = this._skinAdditionStyleSheets[i];
                if (entry == null || (additionDocument = entry.getDocument()) == null) continue;
                document = StyleSheetDocumentUtils.mergeStyleSheetDocuments(document, additionDocument);
            }
        }
        if (document != null) {
            return document;
        }
        return new StyleSheetDocument(null, null, -1L);
    }

    private StyleSheetEntry[] _getSkinAdditionsStyleSheets(StyleContext context) {
        List<String> skinAdditionStyleSheetNames = this._getSkinAdditionsStyleSheetNames();
        if (skinAdditionStyleSheetNames.size() == 0) {
            return null;
        }
        int count = skinAdditionStyleSheetNames.size();
        ArrayList<StyleSheetEntry> entries = new ArrayList<StyleSheetEntry>(count);
        for (String name : skinAdditionStyleSheetNames) {
            StyleSheetEntry entry = StyleSheetEntry.createEntry(context, name);
            if (entry == null) continue;
            entries.add(entry);
        }
        if (!entries.isEmpty()) {
            this._skinAdditionStyleSheets = new StyleSheetEntry[entries.size()];
            return entries.toArray(this._skinAdditionStyleSheets);
        }
        return null;
    }

    private List<String> _getSkinAdditionsStyleSheetNames() {
        if (this._skinAdditionStyleSheetNames != null) {
            return this._skinAdditionStyleSheetNames;
        }
        List<SkinAddition> additions = this.getSkinAdditions();
        ArrayList<String> styleSheetNames = new ArrayList<String>(additions.size());
        for (SkinAddition addition : additions) {
            String name = addition.getStyleSheetName();
            if (name == null) continue;
            styleSheetNames.add(name);
        }
        this._skinAdditionStyleSheetNames = styleSheetNames;
        return this._skinAdditionStyleSheetNames;
    }

    private List<TranslationSource> _getTranslationSourceList() {
        if (this._translationSourceList != null) {
            return this._translationSourceList;
        }
        int translationSourceCount = 0;
        String bName = this.getBundleName();
        ValueExpression ve = null;
        if (bName == null) {
            ve = this.getTranslationSourceValueExpression();
        }
        if (bName != null || ve != null) {
            ++translationSourceCount;
        }
        List<SkinAddition> additions = this.getSkinAdditions();
        ArrayList<TranslationSource> translationSourceList = new ArrayList<TranslationSource>(translationSourceCount += additions.size());
        if (bName != null) {
            translationSourceList.add(new ResourceBundleNameTranslationSource(bName));
        } else if (ve != null) {
            translationSourceList.add(new ValueExprTranslationSource(ve));
        }
        for (SkinAddition add : additions) {
            String name = add.getResourceBundleName();
            if (name != null) {
                translationSourceList.add(new ResourceBundleNameTranslationSource(name));
                continue;
            }
            ValueExpression additionVe = add.getTranslationSourceValueExpression();
            if (additionVe != null) {
                translationSourceList.add(new ValueExprTranslationSource(additionVe));
                continue;
            }
            ValueBinding additionVb = add.getTranslationSourceValueBinding();
            if (additionVb == null) continue;
            translationSourceList.add(new ValueBindingTranslationSource(additionVb));
        }
        this._translationSourceList = translationSourceList;
        return this._translationSourceList;
    }

    private Object _getCachedTranslationValueFromLocale(LocaleContext lContext, List<TranslationSource> translationSourceList, String key) {
        int startIndex;
        int numberOfTranslationSources;
        Locale locale = lContext.getTranslationLocale();
        KeyValueMapStatus keyValueMapStatus = this._translations.get(locale);
        Map<String, Object> keyValueMap = null;
        if (keyValueMapStatus != null) {
            Object value;
            keyValueMap = keyValueMapStatus.getKeyValueMap();
            if (keyValueMap != null && (value = keyValueMap.get(key)) != null) {
                return value;
            }
        } else {
            keyValueMapStatus = this._createKeyValueMapStatusInCache(locale, key, null);
            keyValueMap = keyValueMapStatus.getKeyValueMap();
        }
        if ((numberOfTranslationSources = translationSourceList.size()) == 0) {
            return null;
        }
        int i = startIndex = keyValueMapStatus.getProcessedBundlesIndex();
        while (i < numberOfTranslationSources) {
            TranslationSource translationSource = translationSourceList.get(i);
            translationSource.fillInKeyValueMap(lContext, keyValueMap, i != 0);
            i = keyValueMapStatus.incrementAndGetProcessedBundlesIndex();
            Object value = keyValueMap.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyValueMapStatus _createKeyValueMapStatusInCache(Locale locale, String key, Object value) {
        KeyValueMapStatus keyValueMapStatus = null;
        ConcurrentHashMap<Locale, KeyValueMapStatus> concurrentHashMap = this._translations;
        synchronized (concurrentHashMap) {
            if (!this._translations.contains(locale)) {
                keyValueMapStatus = new KeyValueMapStatus();
                if (value != null) {
                    Map<String, Object> keyValueMap = keyValueMapStatus.getKeyValueMap();
                    keyValueMap.put(key, value);
                }
                this._translations.put(locale, keyValueMapStatus);
            } else {
                keyValueMapStatus = this._translations.get(locale);
            }
        }
        return keyValueMapStatus;
    }

    private static void _fillInKeyValueMapFromResourceBundle(ResourceBundle bundle, Map keyValueMap, boolean checkForKey) {
        Enumeration<String> en;
        if (bundle != null && (en = bundle.getKeys()) != null) {
            while (en.hasMoreElements()) {
                Object value;
                String bundleKey = en.nextElement();
                if (checkForKey) {
                    if (keyValueMap.containsKey(bundleKey) || (value = bundle.getObject(bundleKey)) == null) continue;
                    keyValueMap.put(bundleKey, value);
                    continue;
                }
                value = bundle.getObject(bundleKey);
                if (value == null) continue;
                keyValueMap.put(bundleKey, value);
            }
        }
    }

    private static void _fillInKeyValueMapFromMap(Map<String, String> translationSourceMap, Map keyValueMap, boolean checkForKey) {
        if (translationSourceMap != null) {
            if (!checkForKey) {
                keyValueMap.putAll(translationSourceMap);
            } else {
                Set<Map.Entry<String, String>> keys = translationSourceMap.entrySet();
                if (keys != null) {
                    for (Map.Entry<String, String> entry : translationSourceMap.entrySet()) {
                        String translationValue;
                        String translationKey = entry.getKey();
                        if (keyValueMap.containsKey(translationKey) || (translationValue = entry.getValue()) == null) continue;
                        keyValueMap.put(translationKey, translationValue);
                    }
                }
            }
        }
    }

    private boolean _isDisableContentCompressionParameterTrue(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        return "true".equals(external.getInitParameter("org.apache.myfaces.trinidad.DISABLE_CONTENT_COMPRESSION"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyValueMapStatus {
        Map<String, Object> _keyValueMap = new ConcurrentHashMap<String, Object>();
        AtomicInteger _processedBundlesIndex = new AtomicInteger(0);

        KeyValueMapStatus() {
        }

        public Map<String, Object> getKeyValueMap() {
            return this._keyValueMap;
        }

        public int getProcessedBundlesIndex() {
            return this._processedBundlesIndex.get();
        }

        public int incrementAndGetProcessedBundlesIndex() {
            return this._processedBundlesIndex.incrementAndGet();
        }
    }

    private static class ValueBindingTranslationSource
    implements TranslationSource {
        public final ValueBinding _translationSourceVB;

        public ValueBindingTranslationSource(ValueBinding vb) {
            this._translationSourceVB = vb;
        }

        public void fillInKeyValueMap(LocaleContext lContext, Map keyValueMap, boolean checkForKey) {
            FacesContext fContext = FacesContext.getCurrentInstance();
            Object veValue = this._translationSourceVB.getValue(fContext);
            if (veValue instanceof Map) {
                Map translationSourceMap = (Map)this._translationSourceVB.getValue(fContext);
                SkinImpl._fillInKeyValueMapFromMap(translationSourceMap, keyValueMap, checkForKey);
            } else if (veValue instanceof ResourceBundle) {
                ResourceBundle bundle = (ResourceBundle)this._translationSourceVB.getValue(fContext);
                SkinImpl._fillInKeyValueMapFromResourceBundle(bundle, keyValueMap, checkForKey);
            } else {
                _LOG.warning("INVALID_TRANSLATION_SOURCE_VE_TYPE");
            }
        }
    }

    private static class ValueExprTranslationSource
    implements TranslationSource {
        public final ValueExpression _translationSourceVE;

        public ValueExprTranslationSource(ValueExpression ve) {
            this._translationSourceVE = ve;
        }

        public void fillInKeyValueMap(LocaleContext lContext, Map keyValueMap, boolean checkForKey) {
            ELContext elContext = FacesContext.getCurrentInstance().getELContext();
            Object veValue = this._translationSourceVE.getValue(elContext);
            if (veValue instanceof Map) {
                Map translationSourceMap = (Map)this._translationSourceVE.getValue(elContext);
                SkinImpl._fillInKeyValueMapFromMap(translationSourceMap, keyValueMap, checkForKey);
            } else if (veValue instanceof ResourceBundle) {
                ResourceBundle bundle = (ResourceBundle)this._translationSourceVE.getValue(elContext);
                SkinImpl._fillInKeyValueMapFromResourceBundle(bundle, keyValueMap, checkForKey);
            } else {
                _LOG.warning("INVALID_TRANSLATION_SOURCE_VE_TYPE");
            }
        }
    }

    private static class ResourceBundleNameTranslationSource
    implements TranslationSource {
        public final String _bundleName;

        public ResourceBundleNameTranslationSource(String bundleName) {
            this._bundleName = bundleName;
        }

        public void fillInKeyValueMap(LocaleContext lContext, Map keyValueMap, boolean checkForKey) {
            ResourceBundle bundle = null;
            try {
                bundle = lContext.getBundle(this._bundleName);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            SkinImpl._fillInKeyValueMapFromResourceBundle(bundle, keyValueMap, checkForKey);
        }
    }

    private static interface TranslationSource {
        public void fillInKeyValueMap(LocaleContext var1, Map var2, boolean var3);
    }
}

