/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.ant;

import java.io.IOException;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.w3c.dom.Element;

public final class UpdateHelper {
    private final UpdateImplementation updateProject;
    private final AntProjectHelper helper;

    public UpdateHelper(UpdateImplementation updateProject, AntProjectHelper helper) {
        Parameters.notNull("updateProject", updateProject);
        Parameters.notNull("helper", helper);
        this.updateProject = updateProject;
        this.helper = helper;
    }

    public EditableProperties getProperties(final String path) {
        return ProjectManager.mutex().readAccess(new Mutex.Action<EditableProperties>(){

            @Override
            public EditableProperties run() {
                if (!UpdateHelper.this.isCurrent() && "nbproject/project.properties".equals(path)) {
                    return UpdateHelper.this.updateProject.getUpdatedProjectProperties();
                }
                return UpdateHelper.this.helper.getProperties(path);
            }
        });
    }

    public void putProperties(final String path, final EditableProperties props) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(path)) {
                    UpdateHelper.this.helper.putProperties(path, props);
                } else if (UpdateHelper.this.updateProject.canUpdate()) {
                    try {
                        UpdateHelper.this.updateProject.saveUpdate(props);
                        UpdateHelper.this.helper.putProperties(path, props);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace(ioe);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        return ProjectManager.mutex().readAccess(new Mutex.Action<Element>(){

            @Override
            public Element run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(shared);
                }
                return UpdateHelper.this.updateProject.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                } else if (UpdateHelper.this.updateProject.canUpdate()) {
                    try {
                        UpdateHelper.this.updateProject.saveUpdate(null);
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace(ioe);
                    }
                }
            }
        });
    }

    public boolean requestUpdate() throws IOException {
        if (this.isCurrent()) {
            return true;
        }
        if (!this.updateProject.canUpdate()) {
            return false;
        }
        try {
            return ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException {
                    if (!UpdateHelper.this.isCurrent()) {
                        UpdateHelper.this.updateProject.saveUpdate(null);
                    }
                    return true;
                }
            });
        }
        catch (MutexException ex) {
            Exception inner = ex.getException();
            if (inner instanceof IOException) {
                throw (IOException)inner;
            }
            throw (RuntimeException)inner;
        }
    }

    public boolean isCurrent() {
        return ProjectManager.mutex().readAccess(new Mutex.Action<Boolean>(){

            @Override
            public Boolean run() {
                return UpdateHelper.this.updateProject.isCurrent();
            }
        });
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }
}

