/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class UpdateUnitProviderPanel
extends JPanel {
    private DocumentListener listener;
    private FocusListener focusNameListener;
    private FocusListener focusUrlListener;
    private final JButton bOK = new JButton(NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel_OK"));
    private Set<String> namesOfProviders = null;
    private final boolean isEdit;
    private final String originalName;
    private final Icon errorIcon = ImageUtilities.loadImageIcon("org/netbeans/modules/autoupdate/ui/resources/error.png", false);
    private JCheckBox cbActive;
    private JCheckBox cbTrusted;
    private JLabel errorLabel;
    private JLabel lName;
    private JLabel lURL;
    private JTextField tfName;
    private JTextField tfURL;

    public UpdateUnitProviderPanel(boolean isActive, String name, String url, boolean editing, boolean isTrusted) {
        this.isEdit = editing;
        this.originalName = name;
        this.initComponents();
        this.addListeners();
        this.tfURL.setText(url);
        this.tfName.setText(name);
        this.cbActive.setSelected(isActive);
        this.cbTrusted.setSelected(isTrusted);
        this.getAccessibleContext().setAccessibleName("ACN_UpdateCenterCustomizer");
        this.getAccessibleContext().setAccessibleDescription("ACD_UpdateCenterCustomizer");
    }

    JButton getOKButton() {
        return this.bOK;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void updateErrorMessage(String error) {
        if (error == null) {
            this.errorLabel.setText("");
            this.errorLabel.setIcon(null);
            this.bOK.setEnabled(true);
        } else {
            this.errorLabel.setText(error);
            this.errorLabel.setIcon(this.errorIcon);
            this.bOK.setEnabled(false);
        }
    }

    private void addListeners() {
        if (this.listener == null) {
            this.listener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                    this.update();
                }

                private void update() {
                    UpdateUnitProviderPanel.this.updateErrorMessage(this.getErrorMessage());
                }

                private String getErrorMessage() {
                    String providerName = UpdateUnitProviderPanel.this.getProviderName();
                    String url = UpdateUnitProviderPanel.this.getProviderURL();
                    if (providerName.length() == 0) {
                        return NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.error.name.short");
                    }
                    if (url.length() == 0) {
                        return NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.error.url.short");
                    }
                    if (!(UpdateUnitProviderPanel.this.isEdit && providerName.equals(UpdateUnitProviderPanel.this.originalName) || !UpdateUnitProviderPanel.this.getNamesOfProviders().contains(providerName))) {
                        return NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.error.name.dup");
                    }
                    boolean isOk = true;
                    try {
                        new URI(url).toURL();
                        if (url.startsWith("http:") && !url.startsWith("http://")) {
                            isOk = false;
                        }
                        if (isOk && (providerName + "_removed").length() > 80) {
                            return NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.error.name.toolong");
                        }
                    }
                    catch (MalformedURLException x) {
                        isOk = false;
                    }
                    catch (URISyntaxException x) {
                        isOk = false;
                    }
                    catch (IllegalArgumentException x) {
                        isOk = false;
                    }
                    if (!isOk) {
                        return NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.error.url.invalid");
                    }
                    return null;
                }
            };
            this.focusNameListener = new FocusListener(){
                int currentSelectionStart = 0;
                int currentSelectionEnd = 0;

                @Override
                public void focusGained(FocusEvent e) {
                    if (e.getOppositeComponent() != null) {
                        UpdateUnitProviderPanel.this.tfName.selectAll();
                    } else {
                        UpdateUnitProviderPanel.this.tfName.select(this.currentSelectionStart, this.currentSelectionEnd);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.currentSelectionStart = UpdateUnitProviderPanel.this.tfName.getSelectionStart();
                    this.currentSelectionEnd = UpdateUnitProviderPanel.this.tfName.getSelectionEnd();
                    UpdateUnitProviderPanel.this.tfName.select(0, 0);
                }
            };
            this.tfName.addFocusListener(this.focusNameListener);
            this.focusUrlListener = new FocusListener(){
                int currentSelectionStart = 0;
                int currentSelectionEnd = 0;

                @Override
                public void focusGained(FocusEvent e) {
                    if (e.getOppositeComponent() != null) {
                        UpdateUnitProviderPanel.this.tfURL.selectAll();
                    } else {
                        UpdateUnitProviderPanel.this.tfURL.select(this.currentSelectionStart, this.currentSelectionEnd);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.currentSelectionStart = UpdateUnitProviderPanel.this.tfURL.getSelectionStart();
                    this.currentSelectionEnd = UpdateUnitProviderPanel.this.tfURL.getSelectionEnd();
                    UpdateUnitProviderPanel.this.tfURL.select(0, 0);
                }
            };
            this.tfURL.addFocusListener(this.focusUrlListener);
            this.tfName.getDocument().addDocumentListener(this.listener);
            this.tfURL.getDocument().addDocumentListener(this.listener);
        }
    }

    private Set<String> getNamesOfProviders() {
        if (this.namesOfProviders == null) {
            this.namesOfProviders = new HashSet<String>();
            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
                this.namesOfProviders.add(p.getDisplayName());
            }
        }
        return this.namesOfProviders;
    }

    private void removeListener() {
        if (this.listener != null) {
            this.tfName.getDocument().removeDocumentListener(this.listener);
            this.tfURL.getDocument().removeDocumentListener(this.listener);
            this.tfName.removeFocusListener(this.focusNameListener);
            this.tfURL.removeFocusListener(this.focusUrlListener);
            this.listener = null;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListener();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel_displayName");
    }

    public boolean isActive() {
        return this.cbActive.isSelected();
    }

    public String getProviderName() {
        return this.tfName.getText().trim();
    }

    public String getProviderURL() {
        return this.tfURL.getText().trim();
    }

    public boolean isTrusted() {
        return this.cbTrusted.isSelected();
    }

    private void initComponents() {
        this.lName = new JLabel();
        this.tfName = new JTextField();
        this.lURL = new JLabel();
        this.tfURL = new JTextField();
        this.cbActive = new JCheckBox();
        this.errorLabel = new JLabel();
        this.cbTrusted = new JCheckBox();
        this.lName.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText(this.lName, NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.lName.text"));
        this.lURL.setLabelFor(this.tfURL);
        Mnemonics.setLocalizedText(this.lURL, NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.lURL.text"));
        Mnemonics.setLocalizedText(this.cbActive, NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.cbActive.text"));
        this.cbActive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText(this.cbTrusted, NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.cbTrusted.text"));
        this.cbTrusted.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel, -1, 534, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lName).addComponent(this.lURL)).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfURL, -1, 474, Short.MAX_VALUE).addComponent(this.tfName, -1, 474, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbTrusted).addComponent(this.cbActive)).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lName).addComponent(this.tfName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbActive).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lURL).addComponent(this.tfURL, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.cbTrusted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel).addContainerGap()));
        this.lName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.lName.adesc"));
        this.lURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.lURL.adesc"));
        this.cbActive.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateUnitProviderPanel.class, "UpdateUnitProviderPanel.cbActive.adesc"));
    }
}

