/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.ProblemPanel;
import org.netbeans.modules.autoupdate.ui.SettingsTableModel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.actions.ShowNotifications;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());
    private static Boolean isModulesOnly;
    private static String PLUGIN_MANAGER_MODULES_ONLY;
    private static String PLUGIN_MANAGER_SHARED_INSTALLATION;
    public static String PLUGIN_MANAGER_CHECK_INTERVAL;
    public static String PLUGIN_MANAGER_DONT_CARE_WRITE_PERMISSION;
    public static final SimpleDateFormat DATE_FORMAT;
    public static final String TIME_OF_MODEL_INITIALIZATION = "time_of_model_initialization";
    public static final String TIME_OF_REFRESH_UPDATE_CENTERS = "time_of_refresh_update_centers";
    static final String UNSORTED_CATEGORY;
    static final String LIBRARIES_CATEGORY;
    static final String BRIDGES_CATEGORY;
    private static final String PLUGIN_MANAGER_FIRST_CLASS_MODULES = "plugin.manager.first.class.modules";
    private static final String ALLOW_SHOWING_BALLOON = "plugin.manager.allow.showing.balloon";
    private static final String SHOWING_BALLOON_TIMEOUT = "plugin.manager.showing.balloon.timeout";
    private static final RequestProcessor WORKER_THREADS_PROCESSOR;
    private static Collection<String> first_class_modules;
    private static Set<String> acceptedLicenseIDs;
    public static final String PLUGIN_MANAGER_ACCEPTED_LICENSE_IDS = "plugin_manager_accepted_license_ids";

    public static List<UnitCategory> makeInstalledCategories(List<UpdateUnit> units) {
        ArrayList<UnitCategory> res = new ArrayList<UnitCategory>();
        ArrayList<String> names = new ArrayList<String>();
        for (UpdateUnit u : units) {
            UnitCategory cat;
            UpdateElement el = u.getInstalled();
            if (el == null && !u.isPending()) continue;
            String catName = el == null && u.isPending() ? u.getAvailableUpdates().get(0).getCategory() : el.getCategory();
            Unit.Installed i = new Unit.Installed(u, catName);
            if (names.contains(catName)) {
                cat = (UnitCategory)res.get(names.indexOf(catName));
                cat.addUnit(i);
                continue;
            }
            cat = new UnitCategory(catName);
            cat.addUnit(i);
            res.add(cat);
            names.add(catName);
        }
        logger.log(Level.FINER, "makeInstalledCategories (" + units.size() + ") returns " + res.size());
        return res;
    }

    private static Set<String> getAcceptedLicenseIds() {
        if (acceptedLicenseIDs == null) {
            Utilities.initAcceptedLicenseIDs();
        }
        return acceptedLicenseIDs;
    }

    public static boolean isLicenseIdApproved(String licenseId) {
        if (licenseId == null) {
            return false;
        }
        logger.finest("License ID - Was " + licenseId + " accepted? " + Utilities.getAcceptedLicenseIds().contains(licenseId));
        return Utilities.getAcceptedLicenseIds().contains(licenseId);
    }

    public static void addAcceptedLicenseIDs(Collection<String> licenseIds) {
        logger.fine("License ID - License ID " + licenseIds + " was accepted.");
        if (licenseIds != null) {
            Utilities.getAcceptedLicenseIds().addAll(licenseIds);
        }
    }

    public static void storeAcceptedLicenseIDs() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't call in AWT queue";
        if (acceptedLicenseIDs == null) {
            Utilities.initAcceptedLicenseIDs();
        }
        StringBuilder sb = new StringBuilder();
        for (String licenseId : acceptedLicenseIDs) {
            sb.append(licenseId).append(",");
        }
        Utilities.getPreferences().put(PLUGIN_MANAGER_ACCEPTED_LICENSE_IDS, sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1));
        logger.fine("License IDs - Stored: " + (sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1)));
    }

    public static synchronized void initAcceptedLicenseIDs() {
        String storedIds;
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't call in AWT queue";
        if (acceptedLicenseIDs == null) {
            acceptedLicenseIDs = Collections.newSetFromMap(new ConcurrentHashMap());
            for (UpdateUnit u : UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.MODULE)) {
                String id;
                UpdateElement el = u.getInstalled();
                if (el == null || (id = el.getLicenseId()) == null) continue;
                acceptedLicenseIDs.add(id);
            }
        }
        if ((storedIds = Utilities.getPreferences().get(PLUGIN_MANAGER_ACCEPTED_LICENSE_IDS, null)) != null) {
            acceptedLicenseIDs.addAll(Arrays.asList(storedIds.split(",")));
        }
        logger.fine("License IDs - Loaded: " + acceptedLicenseIDs);
    }

    public static List<UnitCategory> makeUpdateCategories(List<UpdateUnit> units, boolean isNbms) {
        Unit.CompoundUpdate compUnit;
        UnitCategory cat;
        String catName;
        long start = System.currentTimeMillis();
        Utilities.clearFirstClassModules();
        if (!isNbms && !units.isEmpty()) {
            List<UnitCategory> fcCats = Utilities.makeFirstClassUpdateCategories();
            if (!fcCats.isEmpty()) {
                return fcCats;
            }
            if (Utilities.hasPendingFirstClassModules()) {
                return new ArrayList<UnitCategory>();
            }
        }
        HashMap<String, UnitCategory> categories = new HashMap<String, UnitCategory>();
        if (units.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<UpdateUnit> invisibleUnits = new HashSet<UpdateUnit>();
        HashMap<UpdateUnit, Unit.CompoundUpdate> uu2compoundUnit = new HashMap<UpdateUnit, Unit.CompoundUpdate>();
        for (UpdateUnit u : units) {
            List<UpdateElement> updates;
            UpdateElement el = u.getInstalled();
            if (u.isPending() || el == null || !el.isEnabled() && !isNbms || (updates = u.getAvailableUpdates()).isEmpty()) continue;
            if (UpdateManager.TYPE.KIT_MODULE.equals((Object)u.getType()) || isNbms) {
                catName = el.getCategory();
                if (!categories.containsKey(catName)) {
                    categories.put(catName, new UnitCategory(catName));
                }
                cat = (UnitCategory)categories.get(catName);
                if (isNbms) {
                    cat.addUnit(new Unit.Update(u, isNbms, catName));
                    continue;
                }
                compUnit = new Unit.CompoundUpdate(u, catName);
                cat.addUnit(compUnit);
                logger.finest("Kit " + u + " makes compound unit " + compUnit);
                uu2compoundUnit.put(u, compUnit);
                continue;
            }
            invisibleUnits.add(u);
        }
        if (invisibleUnits.size() > 0 && !isNbms) {
            for (UpdateUnit invisibleUnit : invisibleUnits) {
                UpdateUnit visUnit = invisibleUnit.getVisibleAncestor();
                if (visUnit == null || visUnit.getInstalled() == null) {
                    visUnit = invisibleUnit;
                }
                UpdateElement visElement = visUnit.getInstalled();
                logger.finer(invisibleUnit + " -> " + visUnit);
                if (uu2compoundUnit.containsKey(visUnit)) {
                    logger.finest(invisibleUnit + " belongs to " + visUnit);
                } else {
                    catName = visElement.getCategory();
                    if (!categories.containsKey(catName)) {
                        categories.put(catName, new UnitCategory(catName));
                    }
                    cat = (UnitCategory)categories.get(catName);
                    compUnit = new Unit.CompoundUpdate(visUnit, catName);
                    cat.addUnit(compUnit);
                    logger.finest(visUnit + " makes new compound unit " + compUnit);
                    uu2compoundUnit.put(visUnit, compUnit);
                }
                ((Unit.CompoundUpdate)uu2compoundUnit.get(visUnit)).getUpdateUnits().add(invisibleUnit);
            }
            for (Unit.CompoundUpdate compoundUnit : new HashSet(uu2compoundUnit.values())) {
                compoundUnit.initState();
            }
        }
        logger.log(Level.FINE, "makeUpdateCategories (" + units.size() + ") returns " + categories.size() + ", took " + (System.currentTimeMillis() - start) + " ms");
        return new ArrayList<UnitCategory>(categories.values());
    }

    public static long getTimeOfInitialization() {
        return Utilities.getPreferences().getLong(TIME_OF_MODEL_INITIALIZATION, 0L);
    }

    public static void putTimeOfInitialization(long time) {
        Utilities.getPreferences().putLong(TIME_OF_MODEL_INITIALIZATION, time);
    }

    public static long getTimeOfRefreshUpdateCenters() {
        return Utilities.getPreferences().getLong(TIME_OF_REFRESH_UPDATE_CENTERS, 0L);
    }

    public static void putTimeOfRefreshUpdateCenters(long time) {
        Utilities.getPreferences().putLong(TIME_OF_REFRESH_UPDATE_CENTERS, time);
    }

    private static List<UnitCategory> makeFirstClassUpdateCategories() {
        List<UpdateUnit> units = UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.MODULE);
        ArrayList<UnitCategory> res = new ArrayList<UnitCategory>();
        ArrayList<String> names = new ArrayList<String>();
        Collection<String> firstClass = Utilities.getFirstClassModules();
        for (UpdateUnit u : units) {
            UnitCategory cat;
            List<UpdateElement> updates;
            UpdateElement el = u.getInstalled();
            if (u.isPending() || el == null || (updates = u.getAvailableUpdates()).isEmpty() || !firstClass.contains(el.getCodeName())) continue;
            String catName = el.getCategory();
            if (names.contains(catName)) {
                cat = (UnitCategory)res.get(names.indexOf(catName));
                cat.addUnit(new Unit.Update(u, false, catName));
                continue;
            }
            cat = new UnitCategory(catName);
            cat.addUnit(new Unit.Update(u, false, catName));
            res.add(cat);
            names.add(catName);
        }
        logger.log(Level.FINER, "makeFirstClassUpdateCategories (" + units.size() + ") returns " + res.size());
        return res;
    }

    private static boolean hasPendingFirstClassModules() {
        List<UpdateUnit> units = UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.MODULE);
        Collection<String> firstClass = Utilities.getFirstClassModules();
        for (UpdateUnit u : units) {
            List<UpdateElement> updates;
            UpdateElement el = u.getInstalled();
            if (!u.isPending() || el == null || (updates = u.getAvailableUpdates()).isEmpty() || !firstClass.contains(el.getCodeName())) continue;
            return true;
        }
        return false;
    }

    public static List<UnitCategory> makeAvailableCategories(List<UpdateUnit> units, boolean isNbms) {
        ArrayList<UnitCategory> res = new ArrayList<UnitCategory>();
        ArrayList<String> names = new ArrayList<String>();
        for (UpdateUnit u : units) {
            UnitCategory cat;
            List<UpdateElement> updates;
            UpdateElement el = u.getInstalled();
            if (u.isPending() || el != null || (updates = u.getAvailableUpdates()) == null || updates.isEmpty()) continue;
            UpdateElement upEl = updates.get(0);
            String catName = upEl.getCategory();
            if (names.contains(catName)) {
                cat = (UnitCategory)res.get(names.indexOf(catName));
                cat.addUnit(new Unit.Available(u, isNbms, catName));
                continue;
            }
            cat = new UnitCategory(catName);
            cat.addUnit(new Unit.Available(u, isNbms, catName));
            res.add(cat);
            names.add(catName);
        }
        logger.log(Level.FINER, "makeAvailableCategories (" + units.size() + ") returns " + res.size());
        return res;
    }

    public static void showURL(URL href) {
        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (displayer != null) {
            displayer.showURL(href);
        } else {
            logger.log(Level.INFO, "No URLDisplayer found.");
        }
    }

    public static String getDownloadSizeAsString(int size) {
        int gbSize = size / 0x40000000;
        if (gbSize > 0) {
            return gbSize + Utilities.getBundle("Utilities_DownloadSize_GB", new Object[0]);
        }
        int mbSize = size / 0x100000;
        if (mbSize > 0) {
            return mbSize + Utilities.getBundle("Utilities_DownloadSize_MB", new Object[0]);
        }
        int kbSize = size / 1024;
        if (kbSize > 0) {
            return kbSize + Utilities.getBundle("Utilities_DownloadSize_kB", new Object[0]);
        }
        return size + Utilities.getBundle("Utilities_DownloadSize_B", new Object[0]);
    }

    private static String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(Utilities.class, key, params);
    }

    public static void presentRefreshProvider(UpdateUnitProvider provider, PluginManagerUI manager, boolean force) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(Collections.singleton(provider), manager, force);
    }

    public static void presentRefreshProviders(Collection<UpdateUnitProvider> providers, PluginManagerUI manager, boolean force) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(providers, manager, force);
    }

    public static void presentRefreshProviders(PluginManagerUI manager, boolean force) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProviders() call in EQ!";
        Utilities.doRefreshProviders(null, manager, force);
    }

    private static void doRefreshProviders(Collection<UpdateUnitProvider> providers, PluginManagerUI manager, boolean force) {
        boolean finish = false;
        while (!finish) {
            finish = Utilities.tryRefreshProviders(providers, manager, force);
        }
    }

    public static void showProviderNotification(UpdateUnitProvider p) {
        ShowNotifications.checkNotification(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean tryRefreshProviders(Collection<UpdateUnitProvider> providers, PluginManagerUI manager, boolean force) {
        ProgressHandle handle = ProgressHandleFactory.createHandle(NbBundle.getMessage(SettingsTableModel.class, "Utilities_CheckingForUpdates"));
        JComponent progressComp = ProgressHandleFactory.createProgressComponent(handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent(handle);
        detailLabel.setHorizontalAlignment(2);
        try {
            manager.setProgressComponent(detailLabel, progressComp);
            handle.setInitialDelay(0);
            handle.start();
            if (providers == null) {
                providers = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
            }
            for (UpdateUnitProvider p : providers) {
                try {
                    p.refresh(handle, force);
                    Utilities.showProviderNotification(p);
                }
                catch (IOException ioe) {
                    boolean bl;
                    block12: {
                        logger.log(Level.INFO, ioe.getMessage(), ioe);
                        JButton cancel = new JButton();
                        Mnemonics.setLocalizedText(cancel, Utilities.getBundle("Utilities_NetworkProblem_Cancel", new Object[0]));
                        JButton skip = new JButton();
                        Mnemonics.setLocalizedText(skip, Utilities.getBundle("Utilities_NetworkProblem_Skip", new Object[0]));
                        skip.setEnabled(providers.size() > 1);
                        JButton tryAgain = new JButton();
                        Mnemonics.setLocalizedText(tryAgain, Utilities.getBundle("Utilities_NetworkProblem_Continue", new Object[0]));
                        ProblemPanel problem = new ProblemPanel(Utilities.getBundle("Utilities_NetworkProblem_Text", p.getDisplayName(), ioe.getLocalizedMessage()), tryAgain, skip, cancel);
                        Object ret = problem.showNetworkProblemDialog();
                        if (skip.equals(ret)) continue;
                        if (tryAgain.equals(ret)) {
                            boolean bl2 = false;
                            if (handle != null) {
                                handle.finish();
                            }
                            Containers.initNotify();
                            manager.unsetProgressComponent(detailLabel, progressComp);
                            return bl2;
                        }
                        try {
                            bl = true;
                            if (handle == null) break block12;
                            handle.finish();
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return true;
                        }
                    }
                    Containers.initNotify();
                    manager.unsetProgressComponent(detailLabel, progressComp);
                    return bl;
                }
            }
        }
        finally {
            if (handle != null) {
                handle.finish();
            }
            Containers.initNotify();
            manager.unsetProgressComponent(detailLabel, progressComp);
        }
    }

    public static void startAsWorkerThread(PluginManagerUI manager, Runnable runnableCode, String progressDisplayName) {
        Utilities.startAsWorkerThread(manager, runnableCode, progressDisplayName, 0L);
    }

    public static void startAsWorkerThread(final PluginManagerUI manager, final Runnable runnableCode, final String progressDisplayName, final long estimatedTime) {
        Utilities.startAsWorkerThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ProgressHandle handle = ProgressHandleFactory.createHandle(progressDisplayName);
                JComponent progressComp = ProgressHandleFactory.createProgressComponent(handle);
                JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent(handle);
                try {
                    detailLabel.setHorizontalAlignment(2);
                    manager.setProgressComponent(detailLabel, progressComp);
                    handle.setInitialDelay(0);
                    if (estimatedTime == 0L) {
                        handle.start();
                        handle.progress(progressDisplayName);
                        runnableCode.run();
                    } else {
                        assert (estimatedTime > 0L) : "Estimated time " + estimatedTime;
                        final long friendlyEstimatedTime = estimatedTime + 2L;
                        handle.start((int)friendlyEstimatedTime * 10, friendlyEstimatedTime);
                        handle.progress(progressDisplayName, 0);
                        final RequestProcessor.Task runnableTask = Installer.RP.post(runnableCode);
                        RequestProcessor.Task post = Installer.RP.post(new Runnable(){

                            @Override
                            public void run() {
                                int i = 0;
                                while (!runnableTask.isFinished()) {
                                    try {
                                        if (friendlyEstimatedTime * 10L <= (long)i++) {
                                            handle.switchToIndeterminate();
                                            handle.progress(progressDisplayName);
                                            return;
                                        }
                                        handle.progress(progressDisplayName, i);
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                        });
                        runnableTask.addTaskListener(new TaskListener(){

                            @Override
                            public void taskFinished(Task task) {
                                task.removeTaskListener(this);
                                handle.finish();
                            }
                        });
                        runnableTask.waitFinished();
                    }
                }
                finally {
                    if (handle != null) {
                        handle.finish();
                    }
                    manager.unsetProgressComponent(detailLabel, progressComp);
                }
            }
        });
    }

    public static RequestProcessor.Task startAsWorkerThread(Runnable runnableCode) {
        return Utilities.startAsWorkerThread(runnableCode, 0);
    }

    public static RequestProcessor.Task startAsWorkerThread(Runnable runnableCode, int delay) {
        RequestProcessor.Task retval = WORKER_THREADS_PROCESSOR.create(runnableCode);
        if (SwingUtilities.isEventDispatchThread()) {
            retval.schedule(delay);
        } else {
            if (delay > 0) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            retval.run();
        }
        return retval;
    }

    public static UpdateManager.TYPE[] getUnitTypes() {
        if (Utilities.modulesOnly()) {
            return new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE};
        }
        return new UpdateManager.TYPE[]{UpdateManager.TYPE.KIT_MODULE, UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT};
    }

    public static Boolean isGlobalInstallation() {
        String s = Utilities.getPreferences().get(PLUGIN_MANAGER_SHARED_INSTALLATION, System.getProperty("plugin.manager.install.global"));
        if (Boolean.parseBoolean(s)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(s)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static void setGlobalInstallation(Boolean isGlobal) {
        Utilities.getPreferences().put(PLUGIN_MANAGER_SHARED_INSTALLATION, isGlobal == null ? "null" : isGlobal.toString());
    }

    public static boolean modulesOnly() {
        return isModulesOnly == null ? Utilities.modulesOnlyDefault() : isModulesOnly;
    }

    public static boolean showExtendedDescription() {
        return Boolean.valueOf(System.getProperty("plugin.manager.extended.description"));
    }

    public static String getCustomCheckIntervalInMinutes() {
        return System.getProperty(PLUGIN_MANAGER_CHECK_INTERVAL);
    }

    private static String getCustomFirstClassModules() {
        return System.getProperty(PLUGIN_MANAGER_FIRST_CLASS_MODULES);
    }

    private static String getFirstClassModuleNames() {
        Preferences p = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        return p.get(PLUGIN_MANAGER_FIRST_CLASS_MODULES, "");
    }

    public static void clearFirstClassModules() {
        first_class_modules = null;
    }

    public static Collection<String> getFirstClassModules() {
        if (first_class_modules != null) {
            return first_class_modules;
        }
        String names = Utilities.getCustomFirstClassModules();
        if (names == null || names.length() == 0) {
            names = Utilities.getFirstClassModuleNames();
        }
        first_class_modules = new HashSet<String>();
        StringTokenizer en = new StringTokenizer(names, ",");
        while (en.hasMoreTokens()) {
            first_class_modules.add(en.nextToken().trim());
        }
        return first_class_modules;
    }

    public static Boolean allowShowingBalloon() {
        String allowShowing = System.getProperty(ALLOW_SHOWING_BALLOON);
        return allowShowing == null ? null : Boolean.valueOf(allowShowing);
    }

    public static int getShowingBalloonTimeout() {
        String timeoutS = System.getProperty(SHOWING_BALLOON_TIMEOUT);
        int timeout = 30000;
        try {
            if (timeoutS != null) {
                timeout = Integer.parseInt(timeoutS);
            }
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.INFO, nfe + " while parsing " + timeoutS + " for " + SHOWING_BALLOON_TIMEOUT);
        }
        return timeout;
    }

    public static boolean shouldCheckAvailableNewPlugins() {
        String shouldCheck = System.getProperty("plugin.manager.check.new.plugins");
        return shouldCheck == null ? false : Boolean.valueOf(shouldCheck);
    }

    public static boolean shouldCheckAvailableUpdates() {
        String shouldCheck = System.getProperty("plugin.manager.check.updates");
        return shouldCheck == null ? true : Boolean.valueOf(shouldCheck);
    }

    public static void setModulesOnly(boolean modulesOnly) {
        isModulesOnly = modulesOnly ? Boolean.TRUE : Boolean.FALSE;
        Utilities.getPreferences().putBoolean(PLUGIN_MANAGER_MODULES_ONLY, isModulesOnly);
    }

    private static boolean modulesOnlyDefault() {
        return Utilities.getPreferences().getBoolean(PLUGIN_MANAGER_MODULES_ONLY, Boolean.valueOf(System.getProperty("plugin.manager.modules.only")));
    }

    public static Comparator<String> getCategoryComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Collator.getInstance().compare(o1, o2);
            }
        };
    }

    public static List<File> sharedDirs() {
        File id;
        ArrayList<File> files = new ArrayList<File>();
        String dirs = System.getProperty("netbeans.dirs");
        if (dirs != null) {
            StringTokenizer en = new StringTokenizer(dirs, File.pathSeparator);
            while (en.hasMoreElements()) {
                File f = new File((String)en.nextElement());
                files.add(f);
            }
        }
        if ((id = Utilities.getPlatformDir()) != null) {
            files.add(id);
        }
        return Collections.unmodifiableList(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWriteInCluster(File cluster) {
        File trackings;
        assert (cluster != null) : "dir cannot be null";
        assert (cluster.exists()) : cluster + " must exists";
        assert (cluster.isDirectory()) : cluster + " is directory";
        if (cluster == null || !cluster.exists() || !cluster.isDirectory()) {
            logger.log(Level.INFO, "Invalid cluster " + cluster);
            return false;
        }
        if (cluster.canWrite() && cluster.canRead() && org.openide.util.Utilities.isWindows() && (trackings = new File(cluster, "update_tracking")).exists() && trackings.isDirectory()) {
            for (File f : trackings.listFiles()) {
                if (!f.exists() || !f.isFile()) continue;
                FileWriter fw = null;
                try {
                    fw = new FileWriter(f, true);
                }
                catch (IOException ioe) {
                    logger.log(Level.FINE, f + " has no write permission", ioe);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                }
                logger.log(Level.FINE, f + " has write permission");
                return true;
            }
        }
        logger.log(Level.FINE, "Can write into " + cluster + "? " + cluster.canWrite());
        return cluster.canWrite();
    }

    private static File getPlatformDir() {
        String platform = System.getProperty("netbeans.home");
        return platform == null ? null : new File(platform);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Utilities.class);
    }

    public static boolean hasBuiltDefaultCaches() {
        File cacheDir = Places.getCacheSubdirectory("catalogcache");
        if (!cacheDir.exists()) {
            return false;
        }
        try {
            return Files.list(cacheDir.toPath()).anyMatch(p -> p.getName(p.getNameCount() - 1).toString().endsWith("-update-provider"));
        }
        catch (IOException ex) {
            return false;
        }
    }

    static {
        PLUGIN_MANAGER_MODULES_ONLY = "plugin_manager_modules_only";
        PLUGIN_MANAGER_SHARED_INSTALLATION = "plugin_manager_shared_installation";
        PLUGIN_MANAGER_CHECK_INTERVAL = "plugin.manager.check.interval";
        PLUGIN_MANAGER_DONT_CARE_WRITE_PERMISSION = "plugin_manager_dont_care_write_permission";
        DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
        UNSORTED_CATEGORY = NbBundle.getMessage(Utilities.class, "Utilities_Unsorted_Category");
        LIBRARIES_CATEGORY = NbBundle.getMessage(Utilities.class, "Utilities_Libraries_Category");
        BRIDGES_CATEGORY = NbBundle.getMessage(Utilities.class, "Utilities_Bridges_Category");
        WORKER_THREADS_PROCESSOR = new RequestProcessor("autoupdate-ui-worker", 10, false);
        first_class_modules = null;
    }
}

