/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.LoggerHintsCustomizer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public final class NoLoggers {
    public static Iterable<ErrorDescription> checkNoLoggers(HintContext ctx) {
        List<String> customLoggerClasses;
        Element cls = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (cls == null || cls.getKind() != ElementKind.CLASS || cls.getModifiers().contains((Object)Modifier.ABSTRACT) || cls.getEnclosingElement() != null && cls.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return null;
        }
        TypeElement loggerTypeElement = ctx.getInfo().getElements().getTypeElement("java.util.logging.Logger");
        if (loggerTypeElement == null) {
            return null;
        }
        TypeMirror loggerTypeElementAsType = loggerTypeElement.asType();
        if (loggerTypeElementAsType == null || loggerTypeElementAsType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        ArrayList<TypeMirror> customLoggersList = new ArrayList<TypeMirror>();
        if (NoLoggers.isCustomEnabled(ctx.getPreferences()) && (customLoggerClasses = NoLoggers.getCustomLoggers(ctx.getPreferences())) != null) {
            for (String className : customLoggerClasses) {
                TypeMirror customTypeMirror;
                TypeElement customTypeElement = ctx.getInfo().getElements().getTypeElement(className);
                if (customTypeElement == null || (customTypeMirror = customTypeElement.asType()) == null || customTypeMirror.getKind() != TypeKind.DECLARED) continue;
                customLoggersList.add(customTypeMirror);
            }
        }
        LinkedList<VariableElement> loggerFields = new LinkedList<VariableElement>();
        List<VariableElement> fields = ElementFilter.fieldsIn(cls.getEnclosedElements());
        for (VariableElement f : fields) {
            if (f.getKind() != ElementKind.FIELD) continue;
            if (f.asType().equals(loggerTypeElementAsType)) {
                loggerFields.add(f);
                continue;
            }
            if (!customLoggersList.contains(f.asType())) continue;
            loggerFields.add(f);
        }
        if (loggerFields.size() == 0) {
            return Collections.singleton(ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(NoLoggers.class, "MSG_NoLoggers_checkNoLoggers", cls), new NoLoggersFix(NbBundle.getMessage(NoLoggers.class, "MSG_NoLoggers_checkNoLoggers_Fix", cls), TreePathHandle.create(cls, ctx.getInfo())).toEditorFix()));
        }
        return null;
    }

    private static boolean isCustomEnabled(Preferences p) {
        return p.getBoolean("custom-loggers", false);
    }

    private static List<String> getCustomLoggers(Preferences p) {
        String loggers = p.get("custom-loggers-list", null);
        if (loggers == null) {
            return null;
        }
        ArrayList<String> loggersList = new ArrayList<String>();
        String[] tmpArray = loggers.split(",");
        loggersList.addAll(Arrays.asList(tmpArray));
        return loggersList;
    }

    private static final class NoLoggersFix
    extends JavaFix {
        private final String description;

        public NoLoggersFix(String description, TreePathHandle loggerFieldHandle) {
            super(loggerFieldHandle);
            this.description = description;
        }

        @Override
        public String getText() {
            return this.description;
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            TreeMaker m = wc.getTreeMaker();
            ClassTree classTree = (ClassTree)tp.getLeaf();
            Element cls = wc.getTrees().getElement(tp);
            if (cls == null) {
                return;
            }
            String loggerFieldName = null;
            List<VariableElement> fields = ElementFilter.fieldsIn(cls.getEnclosedElements());
            if (!NoLoggersFix.contains(fields, "LOG")) {
                loggerFieldName = "LOG";
            } else if (!NoLoggersFix.contains(fields, "LOGGER")) {
                loggerFieldName = "LOGGER";
            } else {
                for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                    String n = "LOG" + i;
                    if (NoLoggersFix.contains(fields, n)) continue;
                    loggerFieldName = n;
                    break;
                }
            }
            if (loggerFieldName == null) {
                return;
            }
            HashSet<Modifier> mods = new HashSet<Modifier>();
            mods.add(Modifier.PRIVATE);
            mods.add(Modifier.STATIC);
            mods.add(Modifier.FINAL);
            ModifiersTree mt = m.Modifiers(mods);
            TypeElement loggerTypeElement = wc.getElements().getTypeElement("java.util.logging.Logger");
            if (loggerTypeElement == null) {
                return;
            }
            ExpressionTree loggerClassQualIdent = m.QualIdent(loggerTypeElement);
            MemberSelectTree getLogger = m.MemberSelect(loggerClassQualIdent, "getLogger");
            MethodInvocationTree initializer = m.MethodInvocation(Collections.emptyList(), getLogger, Collections.singletonList(m.MethodInvocation(Collections.emptyList(), m.MemberSelect(m.QualIdent(cls), "class.getName"), Collections.emptyList())));
            VariableTree nueLogger = m.Variable(mt, loggerFieldName, loggerClassQualIdent, initializer);
            ClassTree nueClassTree = m.addClassMember(classTree, nueLogger);
            wc.rewrite(classTree, nueClassTree);
        }

        private static boolean contains(Collection<VariableElement> fields, String name) {
            for (VariableElement f : fields) {
                if (!f.getSimpleName().contentEquals(name)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class NoLoggersCustomizer
    implements CustomizerProvider {
        @Override
        public JComponent getCustomizer(Preferences prefs) {
            return new LoggerHintsCustomizer(prefs);
        }
    }
}

