/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import java.util.EnumSet;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TypeCastTree;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class MathRandomCast {
    private static final EnumSet EXPRESSION_KINDS = EnumSet.of(Tree.Kind.DIVIDE, new Tree.Kind[]{Tree.Kind.MINUS, Tree.Kind.MULTIPLY, Tree.Kind.PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.PARENTHESIZED});

    public static ErrorDescription mathRandomCast(HintContext ctx) {
        TreePath path = ctx.getPath();
        if (path.getLeaf().getKind() != Tree.Kind.TYPE_CAST) {
            return null;
        }
        TreePath expr = path;
        for (TreePath parent = path.getParentPath(); parent != null && EXPRESSION_KINDS.contains((Object)parent.getLeaf().getKind()); parent = parent.getParentPath()) {
            expr = parent;
        }
        Fix fix = null;
        if (expr != path) {
            fix = new FixImpl(TreePathHandle.create(ctx.getPath(), ctx.getInfo()), TreePathHandle.create(expr, ctx.getInfo())).toEditorFix();
        }
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_MathRandomCastInt(), fix);
    }

    private static class FixImpl
    extends JavaFix {
        private final TreePathHandle exprHandle;

        public FixImpl(TreePathHandle handle, TreePathHandle exprHandle) {
            super(handle);
            this.exprHandle = exprHandle;
        }

        @Override
        protected String getText() {
            return Bundle.FIX_MathRandomCastInt();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath path = ctx.getPath();
            TreePath exprPath = this.exprHandle.resolve(ctx.getWorkingCopy());
            if (path.getLeaf().getKind() != Tree.Kind.TYPE_CAST || exprPath == null || !EXPRESSION_KINDS.contains((Object)exprPath.getLeaf().getKind())) {
                return;
            }
            WorkingCopy copy = ctx.getWorkingCopy();
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            TypeCastTree cast = (TypeCastTree)path.getLeaf();
            copy.rewrite(path.getLeaf(), cast.getExpression());
            ExpressionTree expr = (ExpressionTree)exprPath.getLeaf();
            if (expr.getKind() != Tree.Kind.PARENTHESIZED) {
                expr = make.Parenthesized(expr);
            }
            copy.rewrite(exprPath.getLeaf(), make.TypeCast(cast.getType(), expr));
        }
    }
}

