/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jpt.sun.source.tree.ArrayAccessTree;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompoundAssignmentTree;
import jpt.sun.source.tree.EnhancedForLoopTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.ForLoopTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.ArrayType;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.ExecutableType;
import jpt30.lang.model.type.PrimitiveType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.introduce.TreeUtils;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;

public class IteratorToFor {
    static final Set<String> SAFE_COLLECTION_METHODS = new HashSet<String>();

    public static ErrorDescription whileIdiom(HintContext ctx) {
        if (IteratorToFor.uses(ctx, ctx.getMultiVariables().get("$rest$"), ctx.getVariables().get("$it"))) {
            return null;
        }
        if (!IteratorToFor.iterable(ctx, ctx.getVariables().get("$coll"), ctx.getVariables().get("$type"))) {
            return null;
        }
        String colString = ctx.getVariables().containsKey("$coll") ? "$coll" : "this";
        Tree highlightTarget = ctx.getPath().getLeaf();
        TreePath elem = ctx.getVariables().get("$elem");
        if (elem.getParentPath() != null && elem.getParentPath().getLeaf().getKind() == Tree.Kind.BLOCK) {
            elem = elem.getParentPath();
        }
        if (elem.getParentPath() != null && elem.getParentPath().getLeaf().getKind() == Tree.Kind.WHILE_LOOP) {
            highlightTarget = elem.getParentPath().getLeaf();
        }
        return ErrorDescriptionFactory.forName(ctx, highlightTarget, Bundle.ERR_IteratorToFor(), JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_IteratorToFor(), ctx.getPath(), "for ($type $elem : " + colString + ") {$rest$;}"));
    }

    public static ErrorDescription forIdiom(HintContext ctx) {
        if (IteratorToFor.uses(ctx, ctx.getMultiVariables().get("$rest$"), ctx.getVariables().get("$it"))) {
            return null;
        }
        if (!IteratorToFor.iterable(ctx, ctx.getVariables().get("$coll"), ctx.getVariables().get("$type"))) {
            return null;
        }
        String colString = ctx.getVariables().containsKey("$coll") ? "$coll" : "this";
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_IteratorToFor(), JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_IteratorToFor(), ctx.getPath(), "for ($type $elem : " + colString + ") {$rest$;}"));
    }

    public static ErrorDescription forListCollection(HintContext ctx) {
        final boolean implicitThis = !ctx.getVariableNames().containsKey("$col");
        AccessAndVarVisitor v = new AccessAndVarVisitor(ctx){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
                ExpressionTree select = node.getMethodSelect();
                String methodName = null;
                if (implicitThis) {
                    MemberSelectTree msel;
                    if (select.getKind() == Tree.Kind.IDENTIFIER) {
                        methodName = ((IdentifierTree)select).getName().toString();
                    } else if (select.getKind() == Tree.Kind.MEMBER_SELECT && (msel = (MemberSelectTree)select).getExpression().getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)msel.getExpression()).getName().contentEquals("this")) {
                        methodName = msel.getIdentifier().toString();
                    }
                } else if (select.getKind() == Tree.Kind.MEMBER_SELECT) {
                    MemberSelectTree msel = (MemberSelectTree)select;
                    if (MatcherUtilities.matches(this.ctx, new TreePath(new TreePath(this.getCurrentPath(), select), msel.getExpression()), "$col", true)) {
                        methodName = msel.getIdentifier().toString();
                    }
                }
                if (methodName != null) {
                    if ("get".equals(methodName)) {
                        if (MatcherUtilities.matches(this.ctx, this.getCurrentPath(), "$col.get($index)", true)) {
                            this.toReplace.add(this.getCurrentPath());
                            return null;
                        }
                        this.unsuitable();
                    }
                    if (!SAFE_COLLECTION_METHODS.contains(methodName)) {
                        this.unsuitable();
                    }
                }
                return (Void)super.visitMethodInvocation(node, p);
            }
        };
        v.scan(ctx.getVariables().get("$statement"), null);
        if (v.unsuitable) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_IteratorToForArray(), new ReplaceIndexedForEachLoop(ctx.getInfo(), ctx.getPath(), ctx.getVariables().get("$col"), v.toReplace, v.definedVariables).toEditorFix());
    }

    public static ErrorDescription forIndexedArray(HintContext ctx) {
        AccessAndVarVisitor v = new AccessAndVarVisitor(ctx){

            @Override
            public Void visitArrayAccess(ArrayAccessTree node, Void p) {
                TreePath path = this.getCurrentPath();
                if (MatcherUtilities.matches(this.ctx, path, "$arr[$index]")) {
                    if (path.getParentPath() != null) {
                        if (path.getParentPath().getLeaf().getKind() == Tree.Kind.ASSIGNMENT && ((AssignmentTree)path.getParentPath().getLeaf()).getVariable() == node) {
                            this.unsuitable();
                        }
                        if (CompoundAssignmentTree.class.isAssignableFrom(path.getParentPath().getLeaf().getKind().asInterface()) && ((CompoundAssignmentTree)path.getParentPath().getLeaf()).getVariable() == node) {
                            this.unsuitable();
                        }
                    }
                    this.toReplace.add(path);
                    return null;
                }
                return (Void)super.visitArrayAccess(node, p);
            }
        };
        v.scan(ctx.getVariables().get("$statement"), null);
        if (v.unsuitable) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_IteratorToForArray(), new ReplaceIndexedForEachLoop(ctx.getInfo(), ctx.getPath(), ctx.getVariables().get("$arr"), v.toReplace, v.definedVariables).toEditorFix());
    }

    private static boolean uses(final HintContext ctx, Collection<? extends TreePath> statements, TreePath var) {
        final Element e = ctx.getInfo().getTrees().getElement(var);
        if (e == null) {
            return false;
        }
        for (TreePath treePath : statements) {
            boolean occurs = Boolean.TRUE.equals(new ErrorAwareTreePathScanner<Boolean, Void>(){

                @Override
                public Boolean scan(Tree tree, Void p) {
                    if (tree == null) {
                        return false;
                    }
                    TreePath currentPath = new TreePath(this.getCurrentPath(), tree);
                    Element currentElement = ctx.getInfo().getTrees().getElement(currentPath);
                    if (e.equals(currentElement)) {
                        return true;
                    }
                    return (Boolean)super.scan(tree, p);
                }

                @Override
                public Boolean reduce(Boolean r1, Boolean r2) {
                    if (r1 == null) {
                        return r2;
                    }
                    if (r2 == null) {
                        return r1;
                    }
                    return r1 != false || r2 != false;
                }
            }.scan(treePath, (Void)null));
            if (!occurs) continue;
            return true;
        }
        return false;
    }

    private static boolean iterable(HintContext ctx, TreePath collection, TreePath type) {
        TypeMirror collectionType = null;
        if (collection != null) {
            collectionType = ctx.getInfo().getTrees().getTypeMirror(collection);
        } else {
            TreePath enclClass = TreeUtils.findClass(type);
            if (enclClass != null) {
                collectionType = ctx.getInfo().getTrees().getTypeMirror(enclClass);
            }
        }
        if (collectionType == null) {
            return false;
        }
        TypeElement iterable = ctx.getInfo().getElements().getTypeElement("java.lang.Iterable");
        if (!org.netbeans.modules.java.hints.errors.Utilities.isValidType(collectionType) || iterable == null) {
            return false;
        }
        TypeMirror typeMirror = ctx.getInfo().getTrees().getTypeMirror(type);
        if (typeMirror != null && typeMirror.getKind().isPrimitive()) {
            typeMirror = ctx.getInfo().getTypes().boxedClass((PrimitiveType)typeMirror).asType();
        }
        DeclaredType iterableType = ctx.getInfo().getTypes().getDeclaredType(iterable, ctx.getInfo().getTypes().getWildcardType(typeMirror, null));
        DeclaredType bogusIterableType = ctx.getInfo().getTypes().getDeclaredType(iterable, ctx.getInfo().getTypes().getNullType());
        return ctx.getInfo().getTypes().isAssignable(collectionType, iterableType) && !ctx.getInfo().getTypes().isAssignable(collectionType, bogusIterableType);
    }

    static {
        SAFE_COLLECTION_METHODS.add("size");
        SAFE_COLLECTION_METHODS.add("isEmpty");
        SAFE_COLLECTION_METHODS.add("contains");
        SAFE_COLLECTION_METHODS.add("containsAll");
        SAFE_COLLECTION_METHODS.add("iterator");
        SAFE_COLLECTION_METHODS.add("listIterator");
        SAFE_COLLECTION_METHODS.add("indexOf");
        SAFE_COLLECTION_METHODS.add("lastIndexOf");
        SAFE_COLLECTION_METHODS.add("subList");
        SAFE_COLLECTION_METHODS.add("toArray");
        SAFE_COLLECTION_METHODS.add("get");
    }

    private static final class ReplaceIndexedForEachLoop
    extends JavaFix {
        private final TreePathHandle arrHandle;
        private final List<TreePathHandle> toReplace;
        private final Set<String> definedVariables;

        public ReplaceIndexedForEachLoop(CompilationInfo info, TreePath tp, TreePath arr, List<TreePath> toReplace, Set<String> definedVariables) {
            super(info, tp);
            this.arrHandle = arr == null ? null : TreePathHandle.create(arr, info);
            this.toReplace = new ArrayList<TreePathHandle>();
            for (TreePath tr : toReplace) {
                this.toReplace.add(TreePathHandle.create(tr, info));
            }
            this.definedVariables = definedVariables;
        }

        @Override
        protected String getText() {
            return Bundle.FIX_IteratorToFor();
        }

        private String assignedToVariable(JavaFix.TransformationContext ctx, TypeMirror variableType, TreePath forStatement, List<TreePath> toReplace) {
            if (forStatement.getLeaf().getKind() != Tree.Kind.BLOCK) {
                return null;
            }
            BlockTree block = (BlockTree)forStatement.getLeaf();
            if (block.getStatements().isEmpty()) {
                return null;
            }
            StatementTree first = block.getStatements().get(0);
            if (first.getKind() != Tree.Kind.VARIABLE) {
                return null;
            }
            VariableTree var = (VariableTree)first;
            TypeMirror varType = ctx.getWorkingCopy().getTrees().getTypeMirror(new TreePath(forStatement, var.getType()));
            if (varType == null || !ctx.getWorkingCopy().getTypes().isSameType(variableType, varType)) {
                return null;
            }
            for (TreePath tp : toReplace) {
                if (tp.getLeaf() != var.getInitializer()) continue;
                return var.getName().toString();
            }
            return null;
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            EnhancedForLoopTree newLoop;
            TypeMirror arrType;
            String treeName;
            Tree colArrTree;
            Tree loop = GeneratorUtilities.get(ctx.getWorkingCopy()).importComments(ctx.getPath().getLeaf(), ctx.getPath().getCompilationUnit());
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            TypeMirror variableType = null;
            if (this.arrHandle != null) {
                TreePath arr = this.arrHandle.resolve(ctx.getWorkingCopy());
                if (arr == null) {
                    return;
                }
                colArrTree = arr.getLeaf();
                treeName = Utilities.varNameSuggestion(arr);
                arrType = ctx.getWorkingCopy().getTrees().getTypeMirror(arr);
                if (!org.netbeans.modules.java.hints.errors.Utilities.isValidType(arrType)) {
                    return;
                }
                if (arrType.getKind() == TypeKind.ARRAY) {
                    variableType = ((ArrayType)arrType).getComponentType();
                }
            } else {
                TreePath enclClass = TreeUtils.findClass(ctx.getPath());
                if (enclClass == null) {
                    return;
                }
                arrType = ctx.getWorkingCopy().getTrees().getTypeMirror(enclClass);
                treeName = "my";
                colArrTree = make.Identifier("this");
            }
            if (arrType.getKind() != TypeKind.ARRAY) {
                TypeElement listEl = ctx.getWorkingCopy().getElements().getTypeElement("java.util.Collection");
                if (listEl == null) {
                    return;
                }
                TypeMirror listType = ctx.getWorkingCopy().getTypes().erasure(listEl.asType());
                if (listType.getKind() == TypeKind.ERROR) {
                    return;
                }
                if (!ctx.getWorkingCopy().getTypes().isAssignable(arrType, listType)) {
                    return;
                }
                Element addEl = ctx.getWorkingCopy().getElementUtilities().findElement("java.util.Collection.add(java.lang.Object)");
                assert (addEl != null);
                TypeMirror addType = ctx.getWorkingCopy().getTypes().asMemberOf((DeclaredType)arrType, addEl);
                variableType = ((ExecutableType)addType).getParameterTypes().get(0);
            } else if (variableType == null) {
                return;
            }
            StatementTree statement = ((ForLoopTree)ctx.getPath().getLeaf()).getStatement();
            ArrayList<TreePath> convertedToReplace = new ArrayList<TreePath>();
            for (TreePathHandle tr : this.toReplace) {
                TreePath tp = tr.resolve(ctx.getWorkingCopy());
                convertedToReplace.add(tp);
            }
            String variableName = this.assignedToVariable(ctx, variableType, new TreePath(ctx.getPath(), statement), convertedToReplace);
            if (variableName != null) {
                BlockTree block = (BlockTree)statement;
                newLoop = make.EnhancedForLoop(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), variableName, make.Type(variableType), null), (ExpressionTree)colArrTree, make.Block(block.getStatements().subList(1, block.getStatements().size()), false));
            } else {
                variableName = treeName;
                if (variableName != null && variableName.endsWith("s")) {
                    variableName = variableName.substring(0, variableName.length() - 1);
                }
                if (variableName == null || variableName.isEmpty()) {
                    variableName = "item";
                }
                CodeStyle cs = CodeStyle.getDefault(ctx.getWorkingCopy().getFileObject());
                if (variableName.equals(treeName) && cs.getLocalVarNamePrefix() == null && cs.getLocalVarNameSuffix() == null && Character.isAlphabetic(variableName.charAt(0))) {
                    StringBuilder nameSb = new StringBuilder(variableName);
                    nameSb.setCharAt(0, Character.toUpperCase(nameSb.charAt(0)));
                    nameSb.indexOf("a");
                    variableName = nameSb.toString();
                }
                variableName = org.netbeans.modules.java.hints.errors.Utilities.makeNameUnique(ctx.getWorkingCopy(), ctx.getWorkingCopy().getTrees().getScope(ctx.getPath()), variableName, this.definedVariables, cs.getLocalVarNamePrefix(), cs.getLocalVarNameSuffix());
                newLoop = make.EnhancedForLoop(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), variableName, make.Type(variableType), null), (ExpressionTree)colArrTree, statement);
            }
            ctx.getWorkingCopy().rewrite(loop, newLoop);
            for (TreePathHandle tr : this.toReplace) {
                TreePath tp = tr.resolve(ctx.getWorkingCopy());
                ctx.getWorkingCopy().rewrite(tp.getLeaf(), make.Identifier(variableName));
            }
        }
    }

    private static class AccessAndVarVisitor
    extends CancellableTreePathScanner<Void, Void> {
        protected final HintContext ctx;
        protected final Set<String> definedVariables = new HashSet<String>();
        private boolean insideClass;
        protected boolean unsuitable;
        protected final List<TreePath> toReplace = new ArrayList<TreePath>();

        public AccessAndVarVisitor(HintContext ctx) {
            this.ctx = ctx;
        }

        protected void unsuitable() {
            this.unsuitable = true;
            this.cancel();
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            if (MatcherUtilities.matches(this.ctx, this.getCurrentPath(), "$index")) {
                this.unsuitable();
                return null;
            }
            return (Void)super.visitIdentifier(node, p);
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            if (!this.insideClass) {
                this.definedVariables.add(node.getName().toString());
            }
            return (Void)super.visitVariable(node, p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitClass(ClassTree node, Void p) {
            boolean origInsideClass = this.insideClass;
            try {
                this.insideClass = true;
                Void void_ = (Void)super.visitClass(node, p);
                return void_;
            }
            finally {
                this.insideClass = origInsideClass;
            }
        }

        @Override
        protected boolean isCanceled() {
            return this.ctx.isCanceled() || super.isCanceled();
        }
    }
}

