/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.Closeable;
import java.util.List;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.env.Bitmap;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalComputable;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.management.Statistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Environment
extends Closeable,
Backupable {
    public long getCreated();

    @NotNull
    public String getLocation();

    @NotNull
    public Bitmap openBitmap(@NotNull String var1, @NotNull StoreConfig var2, @NotNull Transaction var3);

    @NotNull
    public Store openStore(@NotNull String var1, @NotNull StoreConfig var2, @NotNull Transaction var3);

    @Nullable
    public Store openStore(@NotNull String var1, @NotNull StoreConfig var2, @NotNull Transaction var3, boolean var4);

    public void executeTransactionSafeTask(@NotNull Runnable var1);

    public void clear();

    @Override
    public void close();

    public boolean isOpen();

    @NotNull
    public List<String> getAllStoreNames(@NotNull Transaction var1);

    public boolean storeExists(@NotNull String var1, @NotNull Transaction var2);

    public void truncateStore(@NotNull String var1, @NotNull Transaction var2);

    public void removeStore(@NotNull String var1, @NotNull Transaction var2);

    public void gc();

    public void suspendGC();

    public void resumeGC();

    @NotNull
    public Transaction beginTransaction();

    @NotNull
    public Transaction beginTransaction(Runnable var1);

    @NotNull
    public Transaction beginExclusiveTransaction();

    @NotNull
    public Transaction beginExclusiveTransaction(Runnable var1);

    @NotNull
    public Transaction beginReadonlyTransaction();

    @NotNull
    public Transaction beginReadonlyTransaction(Runnable var1);

    public void executeInTransaction(@NotNull TransactionalExecutable var1);

    public void executeInExclusiveTransaction(@NotNull TransactionalExecutable var1);

    public void executeInReadonlyTransaction(@NotNull TransactionalExecutable var1);

    public <T> T computeInTransaction(@NotNull TransactionalComputable<T> var1);

    public <T> T computeInExclusiveTransaction(@NotNull TransactionalComputable<T> var1);

    public <T> T computeInReadonlyTransaction(@NotNull TransactionalComputable<T> var1);

    @NotNull
    public EnvironmentConfig getEnvironmentConfig();

    @NotNull
    public Statistics getStatistics();

    @Nullable
    public StreamCipherProvider getCipherProvider();

    @Nullable
    public byte[] getCipherKey();

    public long getCipherBasicIV();

    public void executeBeforeGc(Runnable var1);
}

