/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.RandomAccessLoggable;
import org.jetbrains.annotations.NotNull;

public class RandomAccessLoggableImpl
implements RandomAccessLoggable {
    private final byte type;
    private final byte headerLength;
    private final int length;
    @NotNull
    private final ByteIterableWithAddress data;
    private final int structureId;

    public RandomAccessLoggableImpl(long address, byte type, @NotNull ByteIterableWithAddress data, int dataLength, int structureId) {
        this.type = type;
        this.headerLength = (byte)(data.getDataAddress() - address);
        this.length = dataLength + this.headerLength;
        this.data = data;
        this.structureId = structureId;
    }

    @Override
    public long getAddress() {
        return this.data.getDataAddress() - (long)this.headerLength;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    @NotNull
    public ByteIterableWithAddress getData() {
        return this.data;
    }

    @Override
    public int getDataLength() {
        return this.length - this.headerLength;
    }

    @Override
    public int getStructureId() {
        return this.structureId;
    }
}

