/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.Objects;
import org.apache.nifi.parameter.ParameterDescriptor;

public class Parameter {
    private final ParameterDescriptor descriptor;
    private final String value;
    private final String parameterContextId;
    private final boolean provided;

    public Parameter(ParameterDescriptor descriptor, String value, String parameterContextId, Boolean provided) {
        this.descriptor = descriptor;
        this.value = value;
        this.parameterContextId = parameterContextId;
        this.provided = provided == null ? false : provided;
    }

    public Parameter(Parameter parameter, String parameterContextId) {
        this(parameter.getDescriptor(), parameter.getValue(), parameterContextId, parameter.isProvided());
    }

    public Parameter(ParameterDescriptor descriptor, String value) {
        this(descriptor, value, null, false);
    }

    public ParameterDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getValue() {
        return this.value;
    }

    public String getParameterContextId() {
        return this.parameterContextId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return Objects.equals(this.descriptor, parameter.descriptor) && Objects.equals(this.value, parameter.value);
    }

    public int hashCode() {
        return Objects.hash(this.descriptor, this.value);
    }

    public boolean isProvided() {
        return this.provided;
    }
}

