/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class SplitPartCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "split_part(SAI)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function strFunc = args.getQuick(0);
        Function delimiterFunc = args.getQuick(1);
        Function indexFunc = args.getQuick(2);
        int indexPosition = argPositions.getQuick(2);
        if (delimiterFunc.isConstant()) {
            char delimiter = delimiterFunc.getChar(null);
            if (delimiter == CharConstant.ZERO.getChar(null)) {
                return StrConstant.NULL;
            }
            if (indexFunc.isConstant()) {
                int index = indexFunc.getInt(null);
                if (index == Integer.MIN_VALUE) {
                    return StrConstant.NULL;
                }
                if (index == 0) {
                    throw SqlException.$(indexPosition, "field position must not be zero");
                }
                return new SplitPartConstDelimiterConstIndexFunction(strFunc, delimiterFunc, indexFunc, indexPosition, delimiter, index);
            }
            return new SplitPartConstDelimiterFunction(strFunc, delimiterFunc, indexFunc, indexPosition, delimiter);
        }
        if (indexFunc.isConstant()) {
            int index = indexFunc.getInt(null);
            if (index == Integer.MIN_VALUE) {
                return StrConstant.NULL;
            }
            if (index == 0) {
                throw SqlException.$(indexPosition, "field position must not be zero");
            }
            return new SplitPartConstIndexFunction(strFunc, delimiterFunc, indexFunc, indexPosition, index);
        }
        if (!indexFunc.isRuntimeConstant()) {
            throw SqlException.$(indexPosition, "index must be a constant or runtime-constant");
        }
        return new SplitPartFunction(strFunc, delimiterFunc, indexFunc, indexPosition);
    }

    private static class SplitPartFunction
    extends AbstractSplitPartFunction
    implements TernaryFunction {
        public SplitPartFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition) {
            super(strFunc, delimiterFunc, indexFunc, indexPosition);
        }

        @Override
        char getDelimiter(Record rec) {
            return this.delimiterFunc.getChar(rec);
        }

        @Override
        int getIndex(Record rec) {
            return this.indexFunc.getInt(rec);
        }
    }

    private static class SplitPartConstIndexFunction
    extends AbstractSplitPartFunction {
        private final int index;

        public SplitPartConstIndexFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition, int index) {
            super(strFunc, delimiterFunc, indexFunc, indexPosition);
            this.index = index;
        }

        @Override
        char getDelimiter(Record rec) {
            return this.delimiterFunc.getChar(rec);
        }

        @Override
        int getIndex(Record rec) {
            return this.index;
        }
    }

    private static class SplitPartConstDelimiterFunction
    extends AbstractSplitPartFunction {
        private final char delimiter;

        public SplitPartConstDelimiterFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition, char delimiter) {
            super(strFunc, delimiterFunc, indexFunc, indexPosition);
            this.delimiter = delimiter;
        }

        @Override
        char getDelimiter(Record rec) {
            return this.delimiter;
        }

        @Override
        int getIndex(Record rec) {
            return this.indexFunc.getInt(rec);
        }
    }

    private static class SplitPartConstDelimiterConstIndexFunction
    extends AbstractSplitPartFunction {
        private final char delimiter;
        private final int index;

        public SplitPartConstDelimiterConstIndexFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition, char delimiter, int index) {
            super(strFunc, delimiterFunc, indexFunc, indexPosition);
            this.delimiter = delimiter;
            this.index = index;
        }

        @Override
        char getDelimiter(Record rec) {
            return this.delimiter;
        }

        @Override
        int getIndex(Record rec) {
            return this.index;
        }
    }

    private static abstract class AbstractSplitPartFunction
    extends StrFunction
    implements TernaryFunction {
        protected final Function delimiterFunc;
        protected final Function indexFunc;
        protected final Function strFunc;
        private final int indexPosition;
        private final StringSink sink = new StringSink();
        private final StringSink sinkB = new StringSink();

        public AbstractSplitPartFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition) {
            this.strFunc = strFunc;
            this.delimiterFunc = delimiterFunc;
            this.indexFunc = indexFunc;
            this.indexPosition = indexPosition;
        }

        @Override
        public Function getCenter() {
            return this.delimiterFunc;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "split_part";
        }

        @Override
        public Function getRight() {
            return this.indexFunc;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            this.getStr0(rec, sink, false);
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.getStr0(rec, this.sink, true);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr0(rec, this.sinkB, true);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            int index;
            TernaryFunction.super.init(symbolTableSource, executionContext);
            if (this.indexFunc.isRuntimeConstant() && (index = this.indexFunc.getInt(null)) == 0) {
                throw SqlException.$(this.indexPosition, "field position must not be zero");
            }
        }

        @Nullable
        private <S extends CharSink> S getStr0(Record rec, S sink, boolean clearSink) {
            int end;
            int start;
            CharSequence str = this.strFunc.getStr(rec);
            char delimiter = this.getDelimiter(rec);
            int index = this.getIndex(rec);
            if (str == null || delimiter == CharConstant.ZERO.getChar(null) || index == Integer.MIN_VALUE) {
                return null;
            }
            if (index == 0) {
                return sink;
            }
            if (index > 0) {
                if (index == 1) {
                    start = 0;
                } else {
                    start = Chars.indexOf(str, 0, str.length(), delimiter, index - 1);
                    if (start == -1) {
                        return sink;
                    }
                    ++start;
                }
                end = Chars.indexOf(str, start, str.length(), delimiter);
                if (end == -1) {
                    end = str.length();
                }
            } else {
                if (index == -1) {
                    end = str.length();
                } else {
                    end = Chars.indexOf(str, 0, str.length(), delimiter, index + 1);
                    if (end == -1) {
                        return sink;
                    }
                }
                start = Chars.indexOf(str, 0, end, delimiter, -1);
                start = start == -1 ? 0 : ++start;
            }
            if (clearSink && sink instanceof Mutable) {
                ((Mutable)((Object)sink)).clear();
            }
            sink.put(str, start, end);
            return sink;
        }

        abstract char getDelimiter(Record var1);

        abstract int getIndex(Record var1);
    }
}

