/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.status;

import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import org.apache.commons.cli.CommandLine;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.toolkit.tls.commandLine.BaseCommandLine;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.apache.nifi.toolkit.tls.commandLine.ExitCode;
import org.apache.nifi.toolkit.tls.configuration.GetStatusConfig;
import org.apache.nifi.toolkit.tls.status.TlsToolkitGetStatus;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsToolkitGetStatusCommandLine
extends BaseCommandLine {
    private final Logger logger = LoggerFactory.getLogger(TlsToolkitGetStatusCommandLine.class);
    public static final String URL_ARG = "url";
    public static final String KEYSTORE_ARG = "keyStore";
    public static final String KEYSTORE_TYPE_ARG = "keyStoreType";
    public static final String KEYSTORE_PASSWORD_ARG = "keyStorePassword";
    public static final String KEY_PASSWORD_ARG = "keyPassword";
    public static final String TRUSTSTORE_ARG = "trustStore";
    public static final String TRUSTSTORE_TYPE_ARG = "trustStoreType";
    public static final String TRUSTSTORE_PASSWORD_ARG = "trustStorePassword";
    public static final String PROTOCOL_ARG = "protocol";
    public static final String DEFAULT_PROTOCOL = TlsConfiguration.getHighestCurrentSupportedTlsProtocolVersion();
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String DESCRIPTION = "Checks the status of an HTTPS endpoint by making a GET request using a supplied keystore and truststore.";
    private URI url;
    private SSLContext sslContext;

    public TlsToolkitGetStatusCommandLine() {
        super(DESCRIPTION);
        this.addOptionWithArg("u", URL_ARG, "The full url to connect to, for example: https://localhost:9443/v1/api");
        this.addOptionWithArg("ks", KEYSTORE_ARG, "The key store to use");
        this.addOptionWithArg("kst", KEYSTORE_TYPE_ARG, "The type of key store being used (PKCS12 or JKS)", DEFAULT_KEYSTORE_TYPE);
        this.addOptionWithArg("ksp", KEYSTORE_PASSWORD_ARG, "The password of the key store being used");
        this.addOptionWithArg("kp", KEY_PASSWORD_ARG, "The key password of the key store being used");
        this.addOptionWithArg("ts", TRUSTSTORE_ARG, "The trust store being used");
        this.addOptionWithArg("tst", TRUSTSTORE_TYPE_ARG, "The type of trust store being used (PKCS12 or JKS)", DEFAULT_KEYSTORE_TYPE);
        this.addOptionWithArg("tsp", TRUSTSTORE_PASSWORD_ARG, "The password of the trust store being used");
        this.addOptionWithArg("p", PROTOCOL_ARG, "The protocol to use", DEFAULT_PROTOCOL);
    }

    public static void main(String[] args) {
        TlsToolkitGetStatusCommandLine commandLine = new TlsToolkitGetStatusCommandLine();
        try {
            commandLine.parse(args);
        }
        catch (CommandLineParseException e) {
            System.exit(e.getExitCode().ordinal());
        }
        GetStatusConfig config = commandLine.createConfig();
        try {
            TlsToolkitGetStatus tlsToolkitGetStatus = new TlsToolkitGetStatus();
            tlsToolkitGetStatus.get(config);
        }
        catch (Exception e) {
            commandLine.printUsage("Error communicating with " + config.getUrl().toString() + " (" + e.getMessage() + ")");
            System.exit(ExitCode.SERVICE_ERROR.ordinal());
        }
        System.exit(ExitCode.SUCCESS.ordinal());
    }

    @Override
    protected void postParse(CommandLine commandLine) throws CommandLineParseException {
        super.postParse(commandLine);
        String urlValue = commandLine.getOptionValue(URL_ARG);
        if (StringUtils.isBlank((String)urlValue)) {
            this.printUsageAndThrow("Url was missing or blank", ExitCode.INVALID_ARGS);
        }
        try {
            this.url = new URI(urlValue);
        }
        catch (URISyntaxException e) {
            this.printUsageAndThrow("Invalid Url", ExitCode.INVALID_ARGS);
        }
        String keystoreFilename = commandLine.getOptionValue(KEYSTORE_ARG);
        String keystoreTypeStr = commandLine.getOptionValue(KEYSTORE_TYPE_ARG, DEFAULT_KEYSTORE_TYPE);
        String keystorePassword = commandLine.getOptionValue(KEYSTORE_PASSWORD_ARG);
        String keyPassword = commandLine.getOptionValue(KEY_PASSWORD_ARG);
        String truststoreFilename = commandLine.getOptionValue(TRUSTSTORE_ARG);
        String truststoreTypeStr = commandLine.getOptionValue(TRUSTSTORE_TYPE_ARG, DEFAULT_KEYSTORE_TYPE);
        String truststorePassword = commandLine.getOptionValue(TRUSTSTORE_PASSWORD_ARG);
        String protocol = commandLine.getOptionValue(PROTOCOL_ARG, DEFAULT_PROTOCOL);
        if (StringUtils.isBlank((String)keystoreFilename)) {
            keystoreTypeStr = null;
        }
        try {
            StandardTlsConfiguration tlsConfiguration = new StandardTlsConfiguration(keystoreFilename, keystorePassword, keyPassword, keystoreTypeStr, truststoreFilename, truststorePassword, truststoreTypeStr, protocol);
            if (tlsConfiguration.isAnyTruststorePopulated()) {
                this.sslContext = SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration);
            } else {
                this.printUsageAndThrow("No truststore was provided", ExitCode.INVALID_ARGS);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.printUsageAndThrow("Failed to create SSL Context: " + e.getMessage(), ExitCode.INVALID_ARGS);
        }
    }

    public GetStatusConfig createConfig() {
        return new GetStatusConfig(this.url, this.sslContext);
    }
}

