/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.nar.ExtensionManager;

public interface ControllerServiceProvider
extends ControllerServiceLookup {
    public void onControllerServiceAdded(ControllerServiceNode var1);

    public ControllerServiceNode getControllerServiceNode(String var1);

    public void removeControllerService(ControllerServiceNode var1);

    public CompletableFuture<Void> enableControllerService(ControllerServiceNode var1);

    public void enableControllerServices(Collection<ControllerServiceNode> var1);

    public Future<Void> enableControllerServicesAsync(Collection<ControllerServiceNode> var1);

    public Future<Void> enableControllerServiceAndDependencies(ControllerServiceNode var1);

    public CompletableFuture<Void> disableControllerService(ControllerServiceNode var1);

    public CompletableFuture<Void> disableControllerServicesAsync(Collection<ControllerServiceNode> var1);

    public Collection<ControllerServiceNode> getNonRootControllerServices();

    public void verifyCanStopReferencingComponents(ControllerServiceNode var1);

    public Map<ComponentNode, Future<Void>> unscheduleReferencingComponents(ControllerServiceNode var1);

    public void verifyCanDisableReferencingServices(ControllerServiceNode var1);

    public Set<ComponentNode> disableReferencingServices(ControllerServiceNode var1);

    public void verifyCanEnableReferencingServices(ControllerServiceNode var1);

    public Set<ComponentNode> enableReferencingServices(ControllerServiceNode var1);

    public void verifyCanScheduleReferencingComponents(ControllerServiceNode var1);

    public Set<ComponentNode> scheduleReferencingComponents(ControllerServiceNode var1);

    public Set<ComponentNode> scheduleReferencingComponents(ControllerServiceNode var1, Set<ComponentNode> var2, ComponentScheduler var3);

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> var1, String var2) throws IllegalArgumentException;

    public Class<? extends ControllerService> getControllerServiceType(String var1);

    public ControllerService getControllerServiceForComponent(String var1, String var2);

    public ExtensionManager getExtensionManager();
}

