/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.IOException;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.properties.BootstrapProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownParameterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GracefulShutdownParameterProvider.class);
    private static final String INVALID_GRACEFUL_SHUTDOWN_SECONDS_MESSAGE = "The {} property in Bootstrap Config File has an invalid value. Must be a non-negative integer, Falling back to the default {} value";
    protected static final String GRACEFUL_SHUTDOWN_PROP = "graceful.shutdown.seconds";
    protected static final String DEFAULT_GRACEFUL_SHUTDOWN_VALUE = "20";
    private final BootstrapFileProvider bootstrapFileProvider;

    public GracefulShutdownParameterProvider(BootstrapFileProvider bootstrapFileProvider) {
        this.bootstrapFileProvider = bootstrapFileProvider;
    }

    public int getGracefulShutdownSeconds() throws IOException {
        int gracefulShutdownSeconds;
        BootstrapProperties bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
        String gracefulShutdown = bootstrapProperties.getProperty(GRACEFUL_SHUTDOWN_PROP, DEFAULT_GRACEFUL_SHUTDOWN_VALUE);
        try {
            gracefulShutdownSeconds = Integer.parseInt(gracefulShutdown);
        }
        catch (NumberFormatException nfe) {
            gracefulShutdownSeconds = Integer.parseInt(DEFAULT_GRACEFUL_SHUTDOWN_VALUE);
            LOGGER.warn(INVALID_GRACEFUL_SHUTDOWN_SECONDS_MESSAGE, (Object)GRACEFUL_SHUTDOWN_PROP, (Object)gracefulShutdownSeconds);
        }
        if (gracefulShutdownSeconds < 0) {
            gracefulShutdownSeconds = Integer.parseInt(DEFAULT_GRACEFUL_SHUTDOWN_VALUE);
            LOGGER.warn(INVALID_GRACEFUL_SHUTDOWN_SECONDS_MESSAGE, (Object)GRACEFUL_SHUTDOWN_PROP, (Object)gracefulShutdownSeconds);
        }
        return gracefulShutdownSeconds;
    }
}

