/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl.request;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;

public class BasicAuthRequestConfig
implements RequestConfig {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BASIC = "Basic";
    private final String username;
    private final String password;

    public BasicAuthRequestConfig(String username, String password) {
        this.username = (String)Validate.notBlank((CharSequence)username);
        this.password = (String)Validate.notBlank((CharSequence)password);
    }

    @Override
    public Map<String, String> getHeaders() {
        String basicCreds = this.username + ":" + this.password;
        byte[] basicCredsBytes = basicCreds.getBytes(StandardCharsets.UTF_8);
        Base64.Encoder encoder = Base64.getEncoder();
        String encodedBasicCreds = encoder.encodeToString(basicCredsBytes);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(AUTHORIZATION_HEADER, "Basic " + encodedBasicCreds);
        return headers;
    }
}

