/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.bucket;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import org.apache.nifi.registry.authorization.Permissions;
import org.apache.nifi.registry.link.LinkableEntity;
import org.apache.nifi.registry.revision.entity.RevisableEntity;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

@XmlRootElement
public class Bucket
extends LinkableEntity
implements RevisableEntity {
    @NotBlank
    private String identifier;
    @NotBlank
    private String name;
    @Min(value=1L)
    private @Min(value=1L) long createdTimestamp;
    private String description;
    private Boolean allowBundleRedeploy;
    private Boolean allowPublicRead;
    private Permissions permissions;
    private RevisionInfo revision;

    @Schema(description="An ID to uniquely identify this object.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Schema(description="The name of the bucket.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The timestamp of when the bucket was first created. This is set by the server at creation time.", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    @Schema(description="A description of the bucket.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Schema(description="Indicates if this bucket allows the same version of an extension bundle to be redeployed and thus overwrite the existing artifact. By default this is false.")
    public Boolean isAllowBundleRedeploy() {
        return this.allowBundleRedeploy;
    }

    public void setAllowBundleRedeploy(Boolean allowBundleRedeploy) {
        this.allowBundleRedeploy = allowBundleRedeploy;
    }

    @Schema(description="Indicates if this bucket allows read access to unauthenticated anonymous users")
    public Boolean isAllowPublicRead() {
        return this.allowPublicRead;
    }

    public void setAllowPublicRead(Boolean allowPublicRead) {
        this.allowPublicRead = allowPublicRead;
    }

    @Schema(description="The access that the current user has to this bucket.", accessMode=Schema.AccessMode.READ_ONLY)
    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    @Schema(description="The revision of this entity used for optimistic-locking during updates.", accessMode=Schema.AccessMode.READ_ONLY)
    public RevisionInfo getRevision() {
        return this.revision;
    }

    public void setRevision(RevisionInfo revision) {
        this.revision = revision;
    }

    public int hashCode() {
        return Objects.hashCode(this.getIdentifier());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bucket other = (Bucket)obj;
        return Objects.equals(this.getIdentifier(), other.getIdentifier());
    }
}

