/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciithemes;

import de.vandermeer.asciithemes.TA_List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public interface TA_ItemizeList
extends TA_List {
    public String getLabel(int var1);

    public int getMaxLevel();

    default public StrBuilder toDoc() {
        if (this.getMaxLevel() == 0) {
            throw new IllegalArgumentException("itemize list toDoc: max level is 0");
        }
        if (this.getMaxLevel() < -1) {
            throw new IllegalArgumentException("itemize list toDoc: max level is < -1");
        }
        StrBuilder ret = new StrBuilder(30);
        ret.append(this.getLabel(1)).append(" item 1").appendNewLine();
        ret.append(this.getLabel(1)).append(" item 2");
        int n = 2;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(2)).append(" item 1").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(2)).append(" item 2");
        }
        n = 3;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(3)).append(" item 1").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(3)).append(" item 2");
        }
        n = 4;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(4)).append(" item 1").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(4)).append(" item 2");
        }
        n = 5;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(5)).append(" item 1").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(5)).append(" item 2");
        }
        n = 6;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(6)).append(" item 1").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(6)).append(" item 2");
        }
        return ret;
    }

    public static TA_ItemizeList create(final Character label, final String description) {
        Validate.notNull((Object)label);
        Validate.notBlank((CharSequence)description);
        return new TA_ItemizeList(){

            @Override
            public int getMaxLevel() {
                return -1;
            }

            @Override
            public String getLabel(int level) {
                return label.toString();
            }

            public String getDescription() {
                return description;
            }
        };
    }

    public static TA_ItemizeList createIncremental(final Character label, final String description) {
        Validate.notNull((Object)label);
        Validate.notBlank((CharSequence)description);
        return new TA_ItemizeList(){

            @Override
            public int getMaxLevel() {
                return -1;
            }

            @Override
            public String getLabel(int level) {
                StrBuilder ret = new StrBuilder();
                for (int i = 0; i < level; ++i) {
                    ret.append((Object)label);
                }
                return ret.toString();
            }

            public String getDescription() {
                return description;
            }
        };
    }

    public static TA_ItemizeList create(final String description, final Character ... characters) {
        Validate.notBlank((CharSequence)description);
        Validate.notNull((Object)characters);
        Validate.noNullElements((Object[])characters);
        return new TA_ItemizeList(){

            @Override
            public int getMaxLevel() {
                return characters.length;
            }

            @Override
            public String getLabel(int level) {
                Validate.validState((level <= this.getMaxLevel() ? 1 : 0) != 0, (String)"level larger than supported max level", (Object[])new Object[0]);
                return characters[level - 1].toString();
            }

            public String getDescription() {
                return description;
            }
        };
    }
}

